/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import com.formdev.flatlaf.icons.FlatWindowCloseIcon;
import com.formdev.flatlaf.icons.FlatWindowIconifyIcon;
import com.formdev.flatlaf.icons.FlatWindowMaximizeIcon;
import com.formdev.flatlaf.icons.FlatWindowRestoreIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import net.hironico.common.swing.ribbon.Ribbon;

public class RibbonWindowUI
extends LayerUI<Ribbon> {
    protected final Color hoverBackground = UIManager.getColor("TitlePane.closeHoverBackground");
    private RibbonCloseIcon iconClose = null;
    private Icon iconMaximize = null;
    private Icon iconRestore = null;
    private Icon iconMinimize = null;

    public RibbonWindowUI() {
        this.initialize();
    }

    private void initialize() {
        this.iconClose = new RibbonCloseIcon();
        this.iconMaximize = new FlatWindowMaximizeIcon();
        this.iconRestore = new FlatWindowRestoreIcon();
        this.iconMinimize = new FlatWindowIconifyIcon();
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        if (w2 == 0 || h2 == 0) {
            return;
        }
        if (!c2.isVisible() || !c2.isValid()) {
            return;
        }
        super.paint(g2, c2);
        int iconWidth = this.iconClose.getIconWidth();
        int iconHeight = this.iconClose.getIconHeight();
        if (this.iconClose.isSelected()) {
            g2.setColor(this.hoverBackground);
            g2.fillRect(w2 - iconWidth, 0, iconWidth, iconHeight);
        }
        this.iconClose.paintIcon(c2, g2, w2 - iconWidth, 0);
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(c2);
        if (topFrame.getExtendedState() == 6) {
            this.iconRestore.paintIcon(c2, g2, w2 - iconWidth * 2, 0);
        } else {
            this.iconMaximize.paintIcon(c2, g2, w2 - iconWidth * 2, 0);
        }
        this.iconMinimize.paintIcon(c2, g2, w2 - iconWidth * 3, 0);
    }

    @Override
    protected void processMouseEvent(MouseEvent e2, JLayer<? extends Ribbon> l2) {
        if (e2.getClickCount() != 1 || e2.getID() != 500) {
            return;
        }
        Ribbon ribbon = l2.getView();
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(ribbon);
        if (this.isOverIcon(this.iconClose, e2, l2)) {
            if (ribbon.getExitAction() != null) {
                ribbon.getExitAction().actionPerformed(null);
            } else {
                topFrame.dispatchEvent(new WindowEvent(topFrame, 201));
            }
        }
        if (this.isOverIcon(this.iconMaximize, e2, l2)) {
            if (topFrame.getExtendedState() != 6) {
                topFrame.setExtendedState(6);
            } else {
                topFrame.setExtendedState(0);
            }
        }
        if (this.isOverIcon(this.iconMinimize, e2, l2)) {
            topFrame.setExtendedState(1);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e2, JLayer<? extends Ribbon> l2) {
        if (this.isOverIcon(this.iconClose, e2, l2)) {
            this.iconClose.setSelected(true);
            l2.repaint();
        } else {
            this.iconClose.setSelected(false);
            l2.repaint();
        }
    }

    private boolean isOverIcon(Icon icon, MouseEvent evt, JLayer<? extends Ribbon> layer) {
        int w2 = layer.getWidth();
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        int x2 = w2 - iconWidth - 5;
        if (icon.equals(this.iconMaximize)) {
            x2 = w2 - iconWidth * 2 - 5;
        }
        if (icon.equals(this.iconMinimize)) {
            x2 = w2 - iconWidth * 3 - 5;
        }
        Rectangle rect = new Rectangle(x2, 2, iconWidth, iconHeight);
        return rect.contains(evt.getPoint());
    }

    static class RibbonCloseIcon
    extends FlatWindowCloseIcon {
        private boolean selected = false;
        protected final Color hoverForeground = UIManager.getColor("TitlePane.closeHoverForeground");

        RibbonCloseIcon() {
        }

        @Override
        protected Color getForeground(Component c2) {
            return this.selected ? this.hoverForeground : super.getForeground(c2);
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

