/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.table;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import net.hironico.common.swing.table.TableColumnAdjuster;

public class ResizeColumnListener
implements MouseListener {
    private static final Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private MouseListener uiListener;
    private final JTableHeader header;
    private final TableColumnAdjuster tca;

    public ResizeColumnListener(JTable table) {
        this(table, null);
    }

    public ResizeColumnListener(JTable table, TableColumnAdjuster tca) {
        MouseListener[] listeners;
        this.header = table.getTableHeader();
        this.tca = tca == null ? new TableColumnAdjuster(table) : tca;
        for (MouseListener ml : listeners = this.header.getMouseListeners()) {
            String className = ml.getClass().toString();
            if (!className.contains("BasicTableHeaderUI")) continue;
            this.uiListener = ml;
            this.header.removeMouseListener(ml);
            this.header.addMouseListener(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.header.getCursor() != resizeCursor) {
            this.uiListener.mouseClicked(e2);
            return;
        }
        if (e2.getClickCount() == 2) {
            Point p2 = e2.getPoint();
            p2.x -= 3;
            int column = this.header.columnAtPoint(p2);
            this.tca.adjustColumn(column);
            this.header.dispatchEvent(new MouseEvent(this.header, 503, e2.getWhen(), e2.getModifiersEx(), e2.getX(), e2.getY(), 0, false));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.uiListener.mouseEntered(e2);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.uiListener.mouseExited(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.uiListener.mousePressed(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.uiListener.mouseReleased(e2);
    }
}

