/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LangUtils {
    private static final Logger LOGGER = Logger.getLogger(LangUtils.class.getName());

    public static boolean hasOneNull(Object ... objs) {
        for (Object o2 : objs) {
            if (o2 != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNull(Object ... objs) {
        for (Object o2 : objs) {
            if (o2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotNull(Object ... objs) {
        for (Object o2 : objs) {
            if (o2 != null) continue;
            return false;
        }
        return true;
    }

    public static List<Class<? extends Object>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            LOGGER.info("Found resource: " + fileName);
            if (fileName.startsWith("file:/")) {
                fileName = fileName.substring(5);
            }
            if (fileName.contains(".jar!")) {
                fileName = fileName.split("!")[0];
            }
            fileName = fileName.replace("%20", " ");
            LOGGER.info("Adding resource: " + fileName);
            dirs.add(new File(fileName));
        }
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>();
        for (File directory : dirs) {
            LOGGER.info("Examine resource : " + directory.getAbsolutePath());
            if (directory.getAbsolutePath().endsWith(".jar")) {
                classes.addAll(LangUtils.getClassesFromJarFile(directory, packageName, classLoader));
                continue;
            }
            classes.addAll(LangUtils.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<? extends Object>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>();
        if (!directory.exists()) {
            LOGGER.severe("Cannot find classes in " + directory.getAbsolutePath() + ". Does not exist.");
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(LangUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + "." + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    private static String fromFileToClassName(String fileName) {
        return fileName.substring(0, fileName.length() - 6).replaceAll("/|\\\\", "\\.");
    }

    private static List<Class<? extends Object>> getClassesFromJarFile(File path, String packageName, ClassLoader classLoader) {
        ArrayList<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>();
        LOGGER.log(Level.INFO, "getClassesFromJarFile: Getting classes for " + path.getAbsolutePath());
        try {
            if (path.canRead()) {
                JarFile jar = new JarFile(path);
                Enumeration<JarEntry> en = jar.entries();
                while (en.hasMoreElements()) {
                    String className;
                    JarEntry entry = en.nextElement();
                    if (!entry.getName().endsWith("class") || !(className = LangUtils.fromFileToClassName(entry.getName())).startsWith(packageName)) continue;
                    LOGGER.log(Level.INFO, "\tgetClassesFromJarFile: found " + className);
                    Class<?> claz = Class.forName(className, false, classLoader);
                    classes.add(claz);
                }
                jar.close();
            } else {
                LOGGER.severe("Cannot read file: " + path.getAbsolutePath());
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to read classes from jar file: " + path, e2);
        }
        return classes;
    }
}

