/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import net.hironico.common.utils.NicoCrypto;

@JsonRootName(value="dbConfig")
@JacksonXmlRootElement(localName="dbConfig")
@JsonIgnoreProperties(value={"connection"}, ignoreUnknown=true)
public class DbConfig
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(DbConfig.class.getName());
    private static final String superSecret = "EkRg0PcE2yv80Zhal+xTsGLSsIyZhlkttEbd2bMNT3Q=";
    private static final SecretKey secretKey = NicoCrypto.generate("EkRg0PcE2yv80Zhal+xTsGLSsIyZhlkttEbd2bMNT3Q=");
    private static final NicoCrypto crypto = new NicoCrypto();
    @JsonProperty(value="name")
    @JacksonXmlProperty(localName="name", isAttribute=true)
    public String name = null;
    @JsonProperty(value="jdbcUrl")
    @JacksonXmlProperty(localName="jdbc-url", isAttribute=true)
    public String jdbcUrl = null;
    @JsonProperty(value="driverClassName")
    @JacksonXmlProperty(localName="driver-class-name", isAttribute=true)
    public String driverClassName = "oracle.jdbc.OracleDriver";
    @JsonProperty(value="user")
    @JacksonXmlProperty(localName="user", isAttribute=true)
    public String user = null;
    @JsonProperty(value="password")
    @JacksonXmlProperty(localName="password", isAttribute=true)
    public String password = null;
    @JsonProperty(value="batchStatementSeparator")
    @JacksonXmlProperty(localName="batch-statement-separator", isAttribute=true)
    public String batchStatementSeparator = "GO";
    @JsonProperty(value="color")
    @JacksonXmlProperty(localName="color", isAttribute=true)
    public String color;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean test() {
        boolean bl;
        block8: {
            Connection con = this.getConnection();
            try {
                bl = true;
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    return false;
                }
            }
            con.close();
        }
        return bl;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        LOGGER.finest("Get connection: Loading driver class: " + this.driverClassName);
        Class.forName(this.driverClassName).newInstance();
        Properties props = new Properties();
        props.put("user", this.user);
        props.put("password", DbConfig.decryptPassword(this.password));
        if (this.jdbcUrl.contains("oracle")) {
            props = this.addOracleProperties(props);
        }
        return DriverManager.getConnection(this.jdbcUrl, props);
    }

    private Properties addOracleProperties(Properties props) {
        props.put("v$session.osuser", System.getProperty("user.name").toString());
        try {
            props.put("v$session.machine", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        props.put("v$session.program", "Hironico MiniSQL");
        return props;
    }

    public static String encryptPassword(String clearPassword) {
        try {
            return crypto.encrypt(clearPassword, secretKey);
        }
        catch (Exception ex) {
            return clearPassword;
        }
    }

    public static String decryptPassword(String encryptedPassword) {
        try {
            return crypto.decrypt(encryptedPassword, secretKey);
        }
        catch (Exception ex) {
            return encryptedPassword;
        }
    }

    public EntityManagerFactory toEntityManagerFactory(String name) {
        return this.toEntityManagerFactory(name, null);
    }

    public EntityManagerFactory toEntityManagerFactory(String name, Map<String, Object> additionalProperties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("javax.persistence.jdbc.user", this.user);
        props.put("javax.persistence.jdbc.password", DbConfig.decryptPassword(this.password));
        props.put("javax.persistence.jdbc.url", this.jdbcUrl);
        props.put("javax.persistence.jdbc.driver", this.driverClassName);
        if (additionalProperties != null) {
            props.putAll(additionalProperties);
        }
        return Persistence.createEntityManagerFactory(name, props);
    }

    public String toString() {
        return this.name == null ? "NULL" : this.name;
    }
}

