/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ctrl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLObjectTypeEnum;

public class ObjectListCallable
implements Callable<List<String[]>>,
Supplier<List<String[]>> {
    private static final Logger LOGGER = Logger.getLogger(ObjectListCallable.class.getName());
    private final String schemaName;
    private final DbConfig configToUse;
    private final SQLObjectTypeEnum objectFilter;

    public ObjectListCallable(DbConfig configToUse, String schemaName) {
        this(configToUse, schemaName, null);
    }

    public ObjectListCallable(DbConfig configToUse, String schemaName, SQLObjectTypeEnum objectFilter) {
        this.configToUse = configToUse;
        this.schemaName = schemaName;
        this.objectFilter = objectFilter;
    }

    @Override
    public List<String[]> call() {
        ArrayList<String[]> result;
        block29: {
            if (this.schemaName == null) {
                LOGGER.severe("Cannot get object list for null schema.");
                return null;
            }
            if (this.configToUse == null) {
                LOGGER.severe("Config to use is null. Cannot get object list.");
                return null;
            }
            result = new ArrayList<String[]>();
            try (Connection con = this.configToUse.getConnection();){
                CharSequence[] row;
                ResultSet rs;
                Statement stmt;
                String sql;
                DatabaseMetaData metaData = con.getMetaData();
                if (this.objectFilter == null || SQLObjectTypeEnum.isTableOrView(this.objectFilter) || this.objectFilter == SQLObjectTypeEnum.SEQUENCE) {
                    ArrayList<String> types = new ArrayList<String>();
                    if (this.objectFilter == null) {
                        types = null;
                    } else {
                        ResultSet rsTypes = metaData.getTableTypes();
                        String objectFilterStr = this.objectFilter.toString();
                        while (rsTypes.next()) {
                            String theType = rsTypes.getString(1).toUpperCase();
                            if (!theType.contains(objectFilterStr)) continue;
                            types.add(theType);
                        }
                        rsTypes.close();
                    }
                    ResultSet rs2 = metaData.getTables(null, this.schemaName, null, types == null ? null : types.toArray(new String[0]));
                    while (rs2.next()) {
                        CharSequence[] row2 = new String[]{rs2.getString(2), rs2.getString(3), rs2.getString(4)};
                        LOGGER.fine("Table found: " + String.join((CharSequence)" ; ", row2));
                        result.add((String[])row2);
                    }
                    rs2.close();
                }
                if (this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.PROCEDURE) {
                    ResultSet rs3 = metaData.getProcedures(null, this.schemaName, null);
                    while (rs3.next()) {
                        CharSequence[] row3 = new String[]{rs3.getString(2), rs3.getString(3), SQLObjectTypeEnum.PROCEDURE.toString()};
                        LOGGER.fine("Procedure found: " + String.join((CharSequence)" ; ", row3));
                        result.add((String[])row3);
                    }
                    rs3.close();
                }
                if ((this.objectFilter == null || this.objectFilter == SQLObjectTypeEnum.SEQUENCE) && this.configToUse.jdbcUrl.contains("oracle")) {
                    LOGGER.info("Loading sequences ...");
                    sql = String.format("SELECT s.sequence_name FROM all_sequences s WHERE s.sequence_owner = '%s' ORDER BY s.sequence_name", this.schemaName);
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        row = new String[]{this.schemaName, rs.getString(1), SQLObjectTypeEnum.SEQUENCE.toString()};
                        LOGGER.fine("Sequence found: " + String.join((CharSequence)" ; ", row));
                        result.add((String[])row);
                    }
                }
                if (this.objectFilter != null && this.objectFilter != SQLObjectTypeEnum.FUNCTION || !this.configToUse.jdbcUrl.contains("postgres")) break block29;
                LOGGER.fine("Loading Postgresql functions...");
                sql = null;
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("net/hironico/minisql/metadata/postgresql/pg_get_functions.sql");){
                    sql = new String(is.readAllBytes());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Cannot load the postgresql query for listing functions.", ex);
                }
                if (sql != null) {
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        if (!rs.getString("schema").equalsIgnoreCase(this.schemaName)) continue;
                        row = new String[]{this.schemaName, rs.getString("name"), SQLObjectTypeEnum.FUNCTION.toString()};
                        LOGGER.fine("Function found: " + String.join((CharSequence)" ; ", row));
                        result.add((String[])row);
                    }
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                String[] row = new String[]{"Error while getting the object list. See log.", t2.getMessage(), ""};
                result.add(row);
            }
        }
        return result;
    }

    @Override
    public List<String[]> get() {
        return this.call();
    }
}

