/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLColumn;
import net.hironico.minisql.model.SQLObjectTypeEnum;

public class SQLObject
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SQLObject.class.getName());
    public String schemaName;
    public String name;
    public SQLObjectTypeEnum type;
    public String color;

    public String getDDL(DDLActionEnum action) {
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case DDLActionEnum.CREATE -> this.getDDLCreate();
            case DDLActionEnum.DROP -> this.getDDLDrop();
        };
    }

    public String getDDLCreate() {
        return "";
    }

    public String getDDLDrop() {
        return "";
    }

    public static String getCompatibleType(SQLColumn col) {
        if (col.typeName.toUpperCase().startsWith("TIMESTAMP")) {
            return "TIMESTAMP";
        }
        if (col.typeName.toUpperCase().startsWith("DATETIME")) {
            return "DATETIME";
        }
        return col.typeName.toUpperCase().replace("NUMBER", "NUMERIC").replace("VARCHAR2", "VARCHAR").replace("NVAR", "VAR");
    }

    protected int executeUpdate(String sql, DbConfig dbConfig) throws Exception {
        try (Connection con = dbConfig.getConnection();){
            int n2;
            block12: {
                Statement stmt = con.createStatement();
                try {
                    LOGGER.fine(String.format("Execute update for: %s", sql));
                    n2 = stmt.executeUpdate(sql);
                    if (stmt == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n2;
        }
    }

    public String toString() {
        return String.join((CharSequence)".", this.schemaName, this.name);
    }

    public static enum DDLActionEnum {
        CREATE,
        DROP;

    }
}

