/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.parser.postgresql;

import java.util.List;
import net.hironico.minisql.parser.postgresql.LexerDispatchingErrorListener;
import net.hironico.minisql.parser.postgresql.ParserDispatchingErrorListener;
import net.hironico.minisql.parser.postgresql.PostgreSQLLexer;
import net.hironico.minisql.parser.postgresql.PostgreSQLParser;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class PostgreSQLParserBase
extends Parser {
    public PostgreSQLParserBase(TokenStream input) {
        super(input);
    }

    ParserRuleContext GetParsedSqlTree(String script, int line) {
        PostgreSQLParser ph = this.getPostgreSQLParser(script);
        PostgreSQLParser.RootContext result = ph.root();
        return result;
    }

    public void ParseRoutineBody(PostgreSQLParser.Createfunc_opt_listContext _localctx) {
        String lang = null;
        for (PostgreSQLParser.Createfunc_opt_itemContext createfunc_opt_itemContext : _localctx.createfunc_opt_item()) {
            if (createfunc_opt_itemContext.LANGUAGE() == null || createfunc_opt_itemContext.nonreservedword_or_sconst() == null || createfunc_opt_itemContext.nonreservedword_or_sconst().nonreservedword() == null || createfunc_opt_itemContext.nonreservedword_or_sconst().nonreservedword().identifier() == null || createfunc_opt_itemContext.nonreservedword_or_sconst().nonreservedword().identifier().Identifier() == null) continue;
            lang = createfunc_opt_itemContext.nonreservedword_or_sconst().nonreservedword().identifier().Identifier().getText();
            break;
        }
        if (null == lang) {
            return;
        }
        PostgreSQLParser.Createfunc_opt_itemContext func_as = null;
        for (PostgreSQLParser.Createfunc_opt_itemContext a2 : _localctx.createfunc_opt_item()) {
            if (a2.func_as() == null) continue;
            func_as = a2;
            break;
        }
        if (func_as != null) {
            String string = this.GetRoutineBodyString(func_as.func_as().sconst(0));
            PostgreSQLParser ph = this.getPostgreSQLParser(string);
            switch (lang) {
                case "plpgsql": {
                    func_as.func_as().Definition = ph.plsqlroot();
                    break;
                }
                case "sql": {
                    func_as.func_as().Definition = ph.root();
                }
            }
        }
    }

    private String TrimQuotes(String s2) {
        return s2 == null || s2.isEmpty() ? s2 : s2.substring(1, s2.length() - 1);
    }

    public String unquote(String s2) {
        int slength = s2.length();
        StringBuilder r2 = new StringBuilder(slength);
        for (int i2 = 0; i2 < slength; ++i2) {
            Character c2 = Character.valueOf(s2.charAt(i2));
            r2.append(c2);
            if (c2.charValue() != '\'' || i2 >= slength - 1 || s2.charAt(i2 + 1) != '\'') continue;
            ++i2;
        }
        return r2.toString();
    }

    public String GetRoutineBodyString(PostgreSQLParser.SconstContext rule) {
        PostgreSQLParser.AnysconstContext anysconst = rule.anysconst();
        TerminalNode StringConstant = anysconst.StringConstant();
        if (null != StringConstant) {
            return this.unquote(this.TrimQuotes(StringConstant.getText()));
        }
        TerminalNode UnicodeEscapeStringConstant = anysconst.UnicodeEscapeStringConstant();
        if (null != UnicodeEscapeStringConstant) {
            return this.TrimQuotes(UnicodeEscapeStringConstant.getText());
        }
        TerminalNode EscapeStringConstant = anysconst.EscapeStringConstant();
        if (null != EscapeStringConstant) {
            return this.TrimQuotes(EscapeStringConstant.getText());
        }
        Object result = "";
        List<TerminalNode> dollartext = anysconst.DollarText();
        for (TerminalNode s2 : dollartext) {
            result = (String)result + s2.getText();
        }
        return result;
    }

    public PostgreSQLParser getPostgreSQLParser(String script) {
        CodePointCharStream charStream = CharStreams.fromString(script);
        PostgreSQLLexer lexer = new PostgreSQLLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PostgreSQLParser parser = new PostgreSQLParser(tokens);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        LexerDispatchingErrorListener listener_lexer = new LexerDispatchingErrorListener((Lexer)((CommonTokenStream)this.getInputStream()).getTokenSource());
        ParserDispatchingErrorListener listener_parser = new ParserDispatchingErrorListener(this);
        lexer.addErrorListener(listener_lexer);
        parser.addErrorListener(listener_parser);
        return parser;
    }
}

