/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui;

import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.minisql.ctrl.QueryResultCallable;
import net.hironico.minisql.model.SQLResultSetTableModel;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.editor.QueryPanel;
import net.hironico.minisql.ui.history.QueryHistory;

public abstract class AbstractQueryAction
extends AbstractRibbonAction {
    private static final Logger LOGGER = Logger.getLogger(AbstractQueryAction.class.getName());

    public AbstractQueryAction(String name, String icon) {
        super(name, icon);
    }

    public static void executeQueryAsync(QueryPanel queryPanel, boolean batchMode) {
        String sql = queryPanel.getQueryText();
        int resultDisplayType = queryPanel.getResultDisplayType();
        LOGGER.fine("Executing '" + sql + "'");
        queryPanel.setResultsComponent(new JLabel("Executing query, please wait."));
        QueryResultCallable queryCall = new QueryResultCallable(sql, queryPanel.getConfig(), batchMode);
        queryCall.addQueryHistoryListener(QueryHistory.getInstance());
        Future<List<SQLResultSetTableModel>> futureResults = MainWindow.executorService.submit(queryCall);
        Runnable waitQueryRun = () -> {
            try {
                List results = (List)futureResults.get();
                results.forEach(result -> result.setDisplayType(resultDisplayType));
                JComponent compResults = QueryPanel.getResultComponentTab(results);
                queryPanel.setResultsComponent(compResults);
            }
            catch (Exception ex) {
                JTextPane txtErr = new JTextPane();
                txtErr.setText(ex.getMessage());
                txtErr.setBorder(BorderFactory.createEmptyBorder());
                txtErr.setEditable(false);
                txtErr.setEnabled(false);
                JScrollPane scrollErr = new JScrollPane(txtErr);
                scrollErr.setBorder(BorderFactory.createEmptyBorder());
                queryPanel.setResultsComponent(scrollErr);
            }
        };
        Thread waitQueryThread = new Thread(waitQueryRun);
        waitQueryThread.start();
    }
}

