/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.hironico.common.swing.CloseableTabComponent;
import net.hironico.common.swing.JSplitPaneNoDivider;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.common.swing.ribbon.Ribbon;
import net.hironico.common.swing.ribbon.RibbonGroup;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.minisql.App;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.ui.ExitAction;
import net.hironico.minisql.ui.ShowLogAction;
import net.hironico.minisql.ui.ShowQueryPanelAction;
import net.hironico.minisql.ui.config.ShowConfigPanelAction;
import net.hironico.minisql.ui.dbexplorer.SchemaExplorerPanel;
import net.hironico.minisql.ui.dbexplorer.ribbon.DbExplorerRibbonTab;
import net.hironico.minisql.ui.editor.ribbon.EditorRibbonTab;
import net.hironico.minisql.ui.editor.ribbon.FileRibbonGroup;
import net.hironico.minisql.ui.history.QueryHistoryPanel;
import net.hironico.minisql.ui.visualdb.action.NewVisualDbTabAction;
import net.hironico.minisql.ui.visualdb.ribbon.VisualDbRibbonTab;

public class MainWindow
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(MainWindow.class.getName());
    public static final ExecutorService executorService = Executors.newFixedThreadPool(4);
    public static final Map<String, AbstractRibbonAction> appActions = new HashMap<String, AbstractRibbonAction>();
    private static final MainWindow instance = new MainWindow();
    private Ribbon ribbon = null;
    private RibbonTab homeRibbonTab = null;
    private RibbonTab editorRibbonTab = null;
    private RibbonGroup fileRibbonGroup = null;
    private RibbonGroup systemRibbonGroup = null;
    private RibbonGroup toolsRibbonGroup = null;
    private RibbonTab explorerRibbonTab = null;
    private RibbonTab visualDbRibbonTab = null;
    private JSplitPaneNoDivider splitMain = null;
    private JTabbedPane tabExplorer = null;
    private SchemaExplorerPanel schemaExplorerPanel = null;
    private JTabbedPane tabEditors = null;
    private JSplitPaneNoDivider splitEditor = null;
    private JTabbedPane tabTools = null;
    private QueryHistoryPanel pnlHistory = null;
    private JPanel pnlStatusBar = null;
    private JLabel lblConnectionStatus = null;

    private MainWindow() {
        super("MiniSQL");
        this.initActions();
        this.initialize();
    }

    public static MainWindow getInstance() {
        return instance;
    }

    private void initialize() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MainWindow.this.setSplitSizes();
            }
        });
        this.addWindowStateListener(evt -> {
            int state = evt.getNewState();
            if ((state & 6) == 6) {
                this.setSplitSizes();
            } else if ((state & 2) != 0) {
                this.setSplitSizes();
            }
        });
        this.setMinimumSize(new Dimension(1024, 768));
        this.setExtendedState(6);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                try {
                    LOGGER.info("Saving config file...");
                    DbConfigFile.saveConfig();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Unable to save config file.", ex);
                }
                System.exit(0);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getRibbon(), "First");
        this.getContentPane().add((Component)this.getSplitMain(), "Center");
        this.getContentPane().add((Component)this.getStatusBar(), "Last");
    }

    private void setSplitSizes() {
        SwingUtilities.invokeLater(() -> {
            try {
                Thread.sleep(50L);
                this.getSplitMain().setDividerLocation(0.25);
                this.getSplitEditor().setDividerLocation(0.75);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void addAction(AbstractRibbonAction action) {
        if (action.getValue("Name") == null) {
            LOGGER.warning("Action has no name: " + action.getClass().getName());
        } else if (appActions.get((String)action.getValue("Name")) != null) {
            LOGGER.warning("There is already an action named: " + action.getValue("Name") + " defined.");
        } else {
            appActions.put((String)action.getValue("Name"), action);
        }
    }

    private void initActions() {
        appActions.clear();
        this.addAction(new ShowConfigPanelAction());
        this.addAction(new ExitAction());
        this.addAction(new ShowQueryPanelAction());
    }

    public Ribbon getRibbon() {
        if (this.ribbon == null) {
            this.ribbon = new Ribbon();
            this.ribbon.setOpaque(true);
            this.ribbon.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
            this.ribbon.addRibbonTab(this.getHomeRibbonTab());
            this.ribbon.addRibbonTab(this.getExplorerRibbonTab());
            this.ribbon.addRibbonTab(this.getEditorRibbonTab());
            this.ribbon.addRibbonTab(this.getVisualDbRibbonTab());
        }
        return this.ribbon;
    }

    private RibbonTab getExplorerRibbonTab() {
        if (this.explorerRibbonTab == null) {
            this.explorerRibbonTab = new DbExplorerRibbonTab();
        }
        return this.explorerRibbonTab;
    }

    private RibbonTab getVisualDbRibbonTab() {
        if (this.visualDbRibbonTab == null) {
            this.visualDbRibbonTab = new VisualDbRibbonTab();
        }
        return this.visualDbRibbonTab;
    }

    private RibbonTab getHomeRibbonTab() {
        if (this.homeRibbonTab == null) {
            this.homeRibbonTab = new RibbonTab("Home");
            this.homeRibbonTab.addGroup(this.getFileRibbonGroup());
            this.homeRibbonTab.addGroup(this.getToolsRibbonGroup());
            this.homeRibbonTab.addGroup(this.getSystemRibbonGroup());
        }
        return this.homeRibbonTab;
    }

    private RibbonTab getEditorRibbonTab() {
        if (this.editorRibbonTab == null) {
            this.editorRibbonTab = new EditorRibbonTab();
        }
        return this.editorRibbonTab;
    }

    private RibbonGroup getFileRibbonGroup() {
        if (this.fileRibbonGroup == null) {
            this.fileRibbonGroup = new FileRibbonGroup();
        }
        return this.fileRibbonGroup;
    }

    private RibbonGroup getToolsRibbonGroup() {
        if (this.toolsRibbonGroup == null) {
            this.toolsRibbonGroup = new RibbonGroup("Tools");
            this.toolsRibbonGroup.addButton(new NewVisualDbTabAction(), 3);
        }
        return this.toolsRibbonGroup;
    }

    private RibbonGroup getSystemRibbonGroup() {
        if (this.systemRibbonGroup == null) {
            this.systemRibbonGroup = new RibbonGroup("System");
            this.systemRibbonGroup.addButton(appActions.get("Config"), 3);
            this.systemRibbonGroup.addButton(new ShowLogAction(), 3);
            this.systemRibbonGroup.addButton(appActions.get("Exit"), 3);
        }
        return this.systemRibbonGroup;
    }

    private JPanel getStatusBar() {
        if (this.pnlStatusBar == null) {
            this.pnlStatusBar = new JPanel();
            this.pnlStatusBar.setOpaque(true);
            this.pnlStatusBar.setBackground(Color.WHITE);
            this.pnlStatusBar.setLayout(new BorderLayout());
            this.pnlStatusBar.add((Component)this.getLblConnectionStatus(), "West");
            this.pnlStatusBar.add((Component)new JLabel("version " + App.getVersion()), "East");
        }
        return this.pnlStatusBar;
    }

    private JLabel getLblConnectionStatus() {
        if (this.lblConnectionStatus == null) {
            this.lblConnectionStatus = new JLabel();
            this.lblConnectionStatus.setText("Welcome to MiniSQL by Hironico.com");
        }
        return this.lblConnectionStatus;
    }

    private JSplitPaneNoDivider getSplitMain() {
        if (this.splitMain == null) {
            this.splitMain = new JSplitPaneNoDivider();
            this.splitMain.setLeftComponent(this.getTabExplorer());
            this.splitMain.setRightComponent(this.getSplitEditor());
            this.splitMain.setDividerSize(7);
            this.splitMain.setDividerLocation(0.15);
            this.splitMain.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.splitMain;
    }

    private JTabbedPane getTabExplorer() {
        if (this.tabExplorer == null) {
            this.tabExplorer = new JTabbedPane();
            this.tabExplorer.addTab("Explorer", this.getSchemaExcplorerPanel());
        }
        return this.tabExplorer;
    }

    public SchemaExplorerPanel getSchemaExcplorerPanel() {
        if (this.schemaExplorerPanel == null) {
            this.schemaExplorerPanel = new SchemaExplorerPanel();
        }
        return this.schemaExplorerPanel;
    }

    private JSplitPaneNoDivider getSplitEditor() {
        if (this.splitEditor == null) {
            this.splitEditor = new JSplitPaneNoDivider();
            this.splitEditor.setLeftComponent(this.getTabEditors());
            this.splitEditor.setRightComponent(this.getTabTools());
            this.splitEditor.setDividerSize(7);
            this.splitEditor.setDividerLocation(0.75);
            this.splitEditor.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.splitEditor;
    }

    private JTabbedPane getTabTools() {
        if (this.tabTools == null) {
            this.tabTools = new JTabbedPane();
            this.tabTools.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.tabTools.addTab("History", this.getPnlHistory());
        }
        return this.tabTools;
    }

    private QueryHistoryPanel getPnlHistory() {
        if (this.pnlHistory == null) {
            this.pnlHistory = new QueryHistoryPanel();
        }
        return this.pnlHistory;
    }

    private JTabbedPane getTabEditors() {
        if (this.tabEditors == null) {
            this.tabEditors = new JTabbedPane();
            this.tabEditors.setBorder(BorderFactory.createEmptyBorder(-3, 0, -2, -3));
        }
        return this.tabEditors;
    }

    public boolean hasOneEditorNamed(String name) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!name.equalsIgnoreCase(this.getTabEditors().getTitleAt(index))) continue;
            return true;
        }
        return false;
    }

    public void setSelectedEditor(String name) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!name.equalsIgnoreCase(this.getTabEditors().getTitleAt(index))) continue;
            this.getTabEditors().setSelectedIndex(index);
            return;
        }
    }

    public void displayCloseableComponent(JComponent comp, String title) {
        Runnable run = () -> {
            JTabbedPane tabResults = this.getTabEditors();
            tabResults.add((Component)comp, title);
            tabResults.setSelectedIndex(tabResults.getTabCount() - 1);
            tabResults.setTabComponentAt(tabResults.getTabCount() - 1, new CloseableTabComponent(tabResults, title));
        };
        SwingUtilities.invokeLater(run);
    }

    public void closeCurrentTab() {
        int selectedIndex = this.getTabEditors().getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.getTabEditors().removeTabAt(selectedIndex);
    }

    public void setTabComponentTitle(JComponent comp, String title) {
        int count = this.getTabEditors().getTabCount();
        for (int index = 0; index < count; ++index) {
            Component myComp = this.getTabEditors().getComponentAt(index);
            if (!myComp.equals(comp)) continue;
            Component tc = this.getTabEditors().getTabComponentAt(index);
            CloseableTabComponent ctc = (CloseableTabComponent)tc;
            ctc.setTitle(title);
            return;
        }
    }

    public Component getCurrentTabComponent() {
        int selectedIndex = this.getTabEditors().getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.getTabEditors().getComponentAt(selectedIndex);
    }

    public int getTabIndexOfTitle(String title, boolean autoSelect) {
        for (int index = 0; index < this.getTabEditors().getTabCount(); ++index) {
            if (!title.equals(this.getTabEditors().getTitleAt(index))) continue;
            if (autoSelect) {
                this.getTabEditors().setSelectedIndex(index);
            }
            return index;
        }
        return -1;
    }
}

