/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.DbConfigFile;
import org.jdesktop.swingx.JXColorSelectionButton;
import org.jdesktop.swingx.JXLabel;

public class ConfigPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(ConfigPanel.class.getName());
    private JToolBar toolbar;
    private JComboBox<String> cmbConnectionList;
    private JButton btnNew;
    private JButton btnSave;
    private JButton btnDelete;
    private JButton btnDuplicate;
    private JLabel lblName;
    private JTextField txtName;
    private JLabel lblJdbcUrl;
    private JTextField txtJdbcUrl;
    private JLabel lblUser;
    private JTextField txtUser;
    private JLabel lblPassword;
    private JPasswordField txtPassword;
    private JLabel lblDriverClassName;
    private JTextField txtDriverClassName;
    private JLabel lblStatementSeparator;
    private JTextField txtStatementSeparator;
    private JButton btnTestConnection = null;
    private JXLabel txtColor = null;
    private JXColorSelectionButton colorChooser = null;

    public ConfigPanel() {
        this.initialize();
        this.loadAllConfigs();
    }

    protected void loadAllConfigs() {
        JComboBox<String> cmb = this.getCmbConnectionList();
        cmb.removeAllItems();
        for (String name : DbConfigFile.getConfigNames()) {
            cmb.addItem(name);
        }
    }

    protected void clearForm() {
        this.getTxtName().setText("");
        this.getTxtJdbcUrl().setText("");
        this.getTxtUser().setText("");
        this.getTxtPassword().setText("");
        this.getTxtDriverClassName().setText("");
        this.getTxtStatementSeparator().setText("");
    }

    protected void loadSelectedConfig(String name) {
        DbConfig cfg = DbConfigFile.getConfig(name);
        if (cfg == null) {
            return;
        }
        this.clearForm();
        this.getTxtName().setText(cfg.name);
        this.getTxtJdbcUrl().setText(cfg.jdbcUrl);
        this.getTxtUser().setText(cfg.user);
        this.getTxtPassword().setText(DbConfig.decryptPassword(cfg.password));
        this.getTxtDriverClassName().setText(cfg.driverClassName);
        this.getTxtStatementSeparator().setText(cfg.batchStatementSeparator);
        Color conColor = cfg.color == null ? Color.BLUE : Color.decode(cfg.color);
        this.getColorChooser().getChooser().setColor(conColor);
        this.getColorChooser().setBackground(conColor);
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(-2, 5, 5, 5));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        gc.fill = 2;
        this.add((Component)this.getToolbar(), gc);
        gc.gridy = 1;
        gc.insets.top = 5;
        this.add((Component)this.getLblName(), gc);
        gc.gridy = 2;
        gc.insets.top = 0;
        this.add((Component)this.getTxtName(), gc);
        gc.gridy = 3;
        gc.insets.top = 5;
        this.add((Component)this.getLblJdbcUrl(), gc);
        gc.gridy = 4;
        gc.insets.top = 0;
        this.add((Component)this.getTxtJdbcUrl(), gc);
        gc.gridy = 5;
        gc.insets.top = 5;
        this.add((Component)this.getLblUser(), gc);
        gc.gridy = 6;
        gc.insets.top = 0;
        this.add((Component)this.getTxtUser(), gc);
        gc.gridy = 7;
        gc.insets.top = 5;
        this.add((Component)this.getLblPassword(), gc);
        gc.gridy = 8;
        gc.insets.top = 0;
        this.add((Component)this.getTxtPassword(), gc);
        gc.gridy = 9;
        gc.insets.top = 5;
        this.add((Component)this.getLblDriverClassName(), gc);
        gc.gridy = 10;
        gc.insets.top = 0;
        this.add((Component)this.getTxtDriverClassName(), gc);
        gc.gridy = 11;
        gc.insets.top = 5;
        this.add((Component)this.getLblStatementSeparator(), gc);
        gc.gridy = 12;
        gc.insets.top = 5;
        this.add((Component)this.getTxtStatementSeparator(), gc);
        gc.gridy = 13;
        gc.insets.top = 5;
        this.add((Component)this.getTxtColor(), gc);
        gc.gridy = 14;
        gc.anchor = 11;
        gc.weighty = 1.0;
        gc.insets.top = 0;
        this.add((Component)this.getColorChooser(), gc);
    }

    protected JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.add(this.getBtnNew());
            this.toolbar.add(this.getBtnDuplicate());
            this.toolbar.add(this.getCmbConnectionList());
            this.toolbar.add(this.getBtnSave());
            this.toolbar.addSeparator();
            this.toolbar.add(this.getBtnTestConnection());
            this.toolbar.addSeparator();
            this.toolbar.add(this.getBtnDelete());
        }
        return this.toolbar;
    }

    protected JButton getBtnTestConnection() {
        if (this.btnTestConnection == null) {
            this.btnTestConnection = new JButton();
            this.btnTestConnection.setText("Test");
            this.btnTestConnection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    DbConfig cfg = ConfigPanel.this.saveDbConfig();
                    try (Connection con = cfg.getConnection();){
                        JOptionPane.showMessageDialog(ConfigPanel.this, "It works !", "Yeah...", 1);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "PRoblem while testing connection.", ex);
                        JOptionPane.showMessageDialog(ConfigPanel.this, "Problem while testing connection.\n" + ex.getMessage(), "Error...", 0);
                    }
                }
            });
        }
        return this.btnTestConnection;
    }

    protected JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton("New");
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String name = JOptionPane.showInputDialog(ConfigPanel.this, (Object)"Please enter new configuration name:");
                    if (name == null) {
                        return;
                    }
                    DbConfig cfg = DbConfigFile.getConfig(name);
                    if (cfg != null) {
                        ConfigPanel.this.cmbConnectionList.setSelectedItem(name);
                        return;
                    }
                    DbConfigFile.addConfig(name);
                    ConfigPanel.this.loadAllConfigs();
                }
            });
        }
        return this.btnNew;
    }

    private DbConfig saveDbConfig() {
        String name = this.getTxtName().getText();
        DbConfig cfg = DbConfigFile.getConfig(name);
        if (cfg == null) {
            JOptionPane.showMessageDialog(this, "Error: This config name is unknown. This should not have happened: " + name, "Error", 0);
            return null;
        }
        cfg.jdbcUrl = this.getTxtJdbcUrl().getText();
        cfg.user = this.getTxtUser().getText();
        cfg.password = DbConfig.encryptPassword(String.copyValueOf(this.getTxtPassword().getPassword()));
        cfg.driverClassName = this.getTxtDriverClassName().getText();
        cfg.batchStatementSeparator = this.getTxtStatementSeparator().getText();
        Color bg = this.getColorChooser().getBackground();
        cfg.color = String.format("#%02x%02x%02x", bg.getRed(), bg.getGreen(), bg.getBlue());
        return cfg;
    }

    protected JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton("Save");
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    ConfigPanel.this.saveDbConfig();
                }
            });
        }
        return this.btnSave;
    }

    protected JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("Delete");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String name = ConfigPanel.this.getTxtName().getText();
                    DbConfig cfg = DbConfigFile.getConfig(name);
                    if (cfg == null) {
                        JOptionPane.showMessageDialog(ConfigPanel.this, "Error: This config name is unknown. This should not have happened: " + name, "Error", 0);
                        return;
                    }
                    int resp = JOptionPane.showConfirmDialog(ConfigPanel.this, "Delete this configuration ?\nThis operation cannot be undone.", "Warning", 0);
                    if (resp != 0) {
                        return;
                    }
                    DbConfigFile.removeConfig(name);
                    ConfigPanel.this.loadAllConfigs();
                }
            });
        }
        return this.btnDelete;
    }

    protected JButton getBtnDuplicate() {
        if (this.btnDuplicate == null) {
            this.btnDuplicate = new JButton("Duplicate");
            this.btnDuplicate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    String sourceConfig = (String)ConfigPanel.this.getCmbConnectionList().getSelectedItem();
                    if (sourceConfig == null) {
                        return;
                    }
                    String name = JOptionPane.showInputDialog(ConfigPanel.this, (Object)"Please enter new configuration name:");
                    if (name == null) {
                        return;
                    }
                    DbConfig cfg = DbConfigFile.getConfig(name);
                    if (cfg != null) {
                        ConfigPanel.this.cmbConnectionList.setSelectedItem(name);
                        return;
                    }
                    cfg = DbConfigFile.duplicate(sourceConfig, name);
                    ConfigPanel.this.loadAllConfigs();
                    ConfigPanel.this.getCmbConnectionList().setSelectedItem(name);
                }
            });
        }
        return this.btnDuplicate;
    }

    protected JComboBox<String> getCmbConnectionList() {
        if (this.cmbConnectionList == null) {
            this.cmbConnectionList = new JComboBox();
            this.cmbConnectionList.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    if (e2.getStateChange() == 1) {
                        ConfigPanel.this.loadSelectedConfig((String)e2.getItem());
                    }
                }
            });
        }
        return this.cmbConnectionList;
    }

    protected JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel("Connection name:");
        }
        return this.lblName;
    }

    protected JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.setEditable(false);
        }
        return this.txtName;
    }

    protected JLabel getLblJdbcUrl() {
        if (this.lblJdbcUrl == null) {
            this.lblJdbcUrl = new JLabel("JDBC URL:");
        }
        return this.lblJdbcUrl;
    }

    protected JTextField getTxtJdbcUrl() {
        if (this.txtJdbcUrl == null) {
            this.txtJdbcUrl = new JTextField();
        }
        return this.txtJdbcUrl;
    }

    protected JLabel getLblUser() {
        if (this.lblUser == null) {
            this.lblUser = new JLabel("User name:");
        }
        return this.lblUser;
    }

    protected JTextField getTxtUser() {
        if (this.txtUser == null) {
            this.txtUser = new JTextField();
        }
        return this.txtUser;
    }

    protected JLabel getLblPassword() {
        if (this.lblPassword == null) {
            this.lblPassword = new JLabel("Password:");
        }
        return this.lblPassword;
    }

    protected JPasswordField getTxtPassword() {
        if (this.txtPassword == null) {
            this.txtPassword = new JPasswordField();
        }
        return this.txtPassword;
    }

    protected JLabel getLblDriverClassName() {
        if (this.lblDriverClassName == null) {
            this.lblDriverClassName = new JLabel();
            this.lblDriverClassName.setText("Driver class name:");
        }
        return this.lblDriverClassName;
    }

    protected JTextField getTxtDriverClassName() {
        if (this.txtDriverClassName == null) {
            this.txtDriverClassName = new JTextField();
        }
        return this.txtDriverClassName;
    }

    protected JLabel getLblStatementSeparator() {
        if (this.lblStatementSeparator == null) {
            this.lblStatementSeparator = new JLabel("SQL statement separator (for batch mode only):");
        }
        return this.lblStatementSeparator;
    }

    protected JTextField getTxtStatementSeparator() {
        if (this.txtStatementSeparator == null) {
            this.txtStatementSeparator = new JTextField();
            this.txtStatementSeparator.setToolTipText("Separator used to segregate statements to be executed one by one in a batch. Only valid for batch execution mode.");
        }
        return this.txtStatementSeparator;
    }

    protected JXLabel getTxtColor() {
        if (this.txtColor == null) {
            this.txtColor = new JXLabel("Connection color:");
        }
        return this.txtColor;
    }

    protected JXColorSelectionButton getColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new JXColorSelectionButton();
            this.colorChooser.setText("Connection color");
        }
        return this.colorChooser;
    }
}

