/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.dbexplorer;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.hironico.common.utils.StreamUtils;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLObjectTypeEnum;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class SQLObjectsTreeTableModel
extends DefaultTreeTableModel {
    private static final Logger LOGGER = Logger.getLogger(SQLObjectsTreeTableModel.class.getName());
    private DefaultMutableTreeTableNode tablesNode;
    private DefaultMutableTreeTableNode viewsNode;
    private DefaultMutableTreeTableNode procsNode;
    private DefaultMutableTreeTableNode sequencesNode;
    private boolean showSystemObjects = Boolean.FALSE;
    private final Class<?>[] columnClass = new Class[]{String.class, String.class};

    public SQLObjectsTreeTableModel() {
        super(new DefaultMutableTreeTableNode("ROOT"), Arrays.asList("Name", "Type"));
        this.addRootNodes();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.columnClass[col];
    }

    @Override
    public Object getValueAt(Object node, int col) {
        DefaultMutableTreeTableNode objNode = (DefaultMutableTreeTableNode)node;
        if (objNode.getUserObject() instanceof String) {
            return col == 0 ? objNode.getUserObject() : null;
        }
        Object userObject = objNode.getUserObject();
        if (userObject instanceof String) {
            return userObject;
        }
        if (!(userObject instanceof SQLObject)) {
            LOGGER.severe("Unknow user object in the tree table of the object explorer: " + userObject.getClass().getName());
            return null;
        }
        SQLObject sqlObj = (SQLObject)userObject;
        switch (col) {
            case 0: {
                return sqlObj.name;
            }
            case 1: {
                return sqlObj.type;
            }
        }
        LOGGER.warning("Invalid column for common object tree table model: " + col);
        return null;
    }

    private void addRootNodes() {
        this.addTablesRootNode();
        this.addViewsRootNode();
        this.addProcsRootNode();
        this.addSequencesRootNode();
    }

    private void addTablesRootNode() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        this.tablesNode = new DefaultMutableTreeTableNode("Tables");
        this.insertNodeInto(this.tablesNode, root, 0);
    }

    private void addViewsRootNode() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        this.viewsNode = new DefaultMutableTreeTableNode("Views");
        this.insertNodeInto(this.viewsNode, root, 1);
    }

    private void addProcsRootNode() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        this.procsNode = new DefaultMutableTreeTableNode("Procedures");
        this.insertNodeInto(this.procsNode, root, 2);
    }

    private void addSequencesRootNode() {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.getRoot();
        this.sequencesNode = new DefaultMutableTreeTableNode("Sequences");
        this.insertNodeInto(this.sequencesNode, root, 3);
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(SQLObjectTypeEnum objectFilter) {
        List<MutableTreeTableNode> nodes;
        if (objectFilter == null || objectFilter == SQLObjectTypeEnum.TABLE) {
            nodes = StreamUtils.stream(this.tablesNode.children()).collect(Collectors.toList());
            nodes.forEach(this::removeNodeFromParent);
        }
        if (objectFilter == null || objectFilter == SQLObjectTypeEnum.VIEW) {
            nodes = StreamUtils.stream(this.viewsNode.children()).collect(Collectors.toList());
            nodes.forEach(this::removeNodeFromParent);
        }
        if (objectFilter == null || objectFilter == SQLObjectTypeEnum.PROCEDURE) {
            nodes = StreamUtils.stream(this.procsNode.children()).collect(Collectors.toList());
            nodes.forEach(this::removeNodeFromParent);
        }
        if (objectFilter == null || objectFilter == SQLObjectTypeEnum.SEQUENCE) {
            nodes = StreamUtils.stream(this.sequencesNode.children()).collect(Collectors.toList());
            nodes.forEach(this::removeNodeFromParent);
        }
    }

    private void addSQLObject(DefaultMutableTreeTableNode parent, SQLObject obj) {
        DefaultMutableTreeTableNode objNode = new DefaultMutableTreeTableNode(obj);
        this.insertNodeInto(objNode, parent, parent.getChildCount());
    }

    public void setSQLObjects(List<String[]> objects) {
        if (objects == null) {
            return;
        }
        objects.forEach(sqlObj -> {
            SQLObject myObj = this.createSQLObject((String[])sqlObj);
            DefaultMutableTreeTableNode myObjNode = this.getSQLObjectParentNode(myObj);
            if (myObjNode != null) {
                this.addSQLObject(myObjNode, myObj);
            }
        });
    }

    private DefaultMutableTreeTableNode getSQLObjectParentNode(SQLObject myObj) {
        if (myObj == null) {
            return null;
        }
        switch (myObj.type) {
            case TABLE: 
            case SYNONYM: {
                return this.tablesNode;
            }
            case SYSTEM_TABLE: {
                if (!this.showSystemObjects) break;
                return this.tablesNode;
            }
            case VIEW: 
            case MATERIALIZED_VIEW: {
                return this.viewsNode;
            }
            case SYSTEM_VIEW: {
                if (!this.showSystemObjects) break;
                return this.viewsNode;
            }
            case PROCEDURE: 
            case FUNCTION: {
                return this.procsNode;
            }
            case SYSTEM_PROCEDURE: 
            case SYSTEM_FUNCTION: {
                if (!this.showSystemObjects) break;
                return this.procsNode;
            }
            case SEQUENCE: {
                return this.sequencesNode;
            }
            case SYSTEM_SEQUENCE: {
                if (!this.showSystemObjects) break;
                return this.sequencesNode;
            }
            case INDEX: 
            case SYSTEM_INDEX: {
                break;
            }
            default: {
                LOGGER.severe("Unsupported object type: " + myObj.type.toString());
            }
        }
        return null;
    }

    private SQLObject createSQLObject(String[] infos) {
        try {
            SQLObject obj = new SQLObject();
            obj.schemaName = infos[0];
            obj.name = infos[1];
            obj.type = SQLObjectTypeEnum.valueOfStr(infos[2]);
            return obj;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }
}

