/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.editor.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.minisql.parser.plsql.PlSqlParserBaseListener;
import net.hironico.minisql.parser.postgresql.PostgreSQLLexer;
import net.hironico.minisql.parser.postgresql.PostgreSQLParser;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.editor.QueryPanel;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CheckSQLAction
extends AbstractRibbonAction {
    private static final Logger LOGGER = Logger.getLogger(CheckSQLAction.class.getName());
    private QueryPanel queryPanel = null;

    public CheckSQLAction() {
        super("Check SQL", "icons8_eye_checked_64px.png");
    }

    private void validateSQL(String sql) throws IOException {
        LOGGER.info("Starting SQL validation ...");
        this.queryPanel.setStatusMessage("");
        CodePointCharStream charStream = CharStreams.fromString(sql);
        PostgreSQLLexer lexer = new PostgreSQLLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PostgreSQLParser parser = new PostgreSQLParser(tokens);
        final ArrayList errors = new ArrayList();
        ANTLRErrorListener errorListener = new ANTLRErrorListener(){

            @Override
            public void reportAmbiguity(Parser parser, DFA dfa, int line, int charPosition, boolean b2, BitSet bitSet, ATNConfigSet atnConfigSet) {
                LOGGER.severe("Report ambiguity");
            }

            @Override
            public void reportAttemptingFullContext(Parser parser, DFA dfa, int i2, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
                LOGGER.severe("Report attempting full context");
            }

            @Override
            public void reportContextSensitivity(Parser parser, DFA dfa, int i2, int i1, int i22, ATNConfigSet atnConfigSet) {
                LOGGER.severe("Report context sensitivity");
            }

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) {
                int errorLine = line - 1;
                int errorColumn = charPositionInLine - 1;
                String errMsg = String.format("<html><b>Syntax error at line %d : %d</b></html>", line, charPositionInLine);
                LOGGER.severe(errMsg);
                CheckSQLAction.this.queryPanel.setStatusMessage(errMsg);
                errors.add(errMsg);
            }
        };
        parser.addErrorListener(errorListener);
        PostgreSQLParser.RootContext tree = parser.root();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(new PlSqlParserBaseListener(), tree);
        if (errors.isEmpty()) {
            this.queryPanel.setStatusMessage("SQL seems correct.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Component comp = MainWindow.getInstance().getCurrentTabComponent();
        if (!(comp instanceof QueryPanel)) {
            return;
        }
        this.queryPanel = (QueryPanel)comp;
        String sql = this.queryPanel.getQueryText();
        try {
            this.validateSQL(sql);
        }
        catch (IOException ioe) {
            String errMsg = String.format("Cannot check SQL syntax: %s", ioe.getMessage());
            LOGGER.log(Level.SEVERE, errMsg, ioe);
            JOptionPane.showMessageDialog(this.queryPanel, errMsg);
        }
    }
}

