/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.hironico.common.swing.table.FilterableTable;
import net.hironico.minisql.ui.CopyAllAction;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.editor.QueryPanel;
import net.hironico.minisql.ui.history.QueryHistory;
import net.hironico.minisql.ui.history.QueryHistoryEntry;
import net.hironico.minisql.ui.history.QueryHistoryTableModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class QueryHistoryPanel
extends JPanel {
    private static final long serialVersionUID = -1L;
    private static final DateFormat localeDateFormat = DateFormat.getDateTimeInstance();
    private JToolBar searchBar = null;
    private JXTextField txtFilter = null;
    private JScrollPane scrollHistory = null;
    private FilterableTable tableHistory = null;
    private QueryHistoryTableModel queryHistoryTableModel = null;
    private JXPanel pnlInfos = null;
    private JXLabel lblInfos = null;
    private JButton btnCopy = null;
    private RTextScrollPane scrollPreview = null;
    private RSyntaxTextArea txtPreview = null;

    public QueryHistoryPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setOpaque(true);
        this.setBackground(new Color(236, 243, 250));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.add((Component)this.getSearchBar(), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.75;
        gbc.fill = 1;
        this.add((Component)this.getScrollHistory(), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        this.add((Component)this.getPnlInfos(), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.25;
        this.add((Component)this.getScrollPreview(), gbc);
    }

    private JToolBar getSearchBar() {
        if (this.searchBar == null) {
            this.searchBar = new JToolBar();
            this.searchBar.setFloatable(false);
            this.searchBar.add(new JLabel("Filter:"));
            this.searchBar.add(this.getTxtFilter());
        }
        return this.searchBar;
    }

    private JXTextField getTxtFilter() {
        if (this.txtFilter == null) {
            this.txtFilter = new JXTextField();
            this.txtFilter.setPrompt("keyword filter");
            this.txtFilter.addActionListener(evt -> this.getTableHistory().applyFilter(this.txtFilter.getText(), 1));
        }
        return this.txtFilter;
    }

    private QueryHistoryEntry getSelectedQueryHistoryEntry() {
        int row = this.getTableHistory().getSelectedRow();
        return QueryHistory.getInstance().getQueryHistoryAt(row);
    }

    private JScrollPane getScrollHistory() {
        if (this.scrollHistory == null) {
            this.scrollHistory = new JScrollPane(this.getTableHistory());
            this.scrollHistory.setBorder(BorderFactory.createEmptyBorder());
            this.scrollHistory.setOpaque(true);
            this.scrollHistory.getViewport().setOpaque(true);
            this.scrollHistory.getViewport().setBackground(new Color(236, 243, 250));
            this.scrollHistory.setBackground(new Color(236, 243, 250));
            this.scrollHistory.setVerticalScrollBarPolicy(22);
        }
        return this.scrollHistory;
    }

    private FilterableTable getTableHistory() {
        if (this.tableHistory == null) {
            this.tableHistory = new FilterableTable();
            this.tableHistory.setOpaque(true);
            this.tableHistory.setBackground(new Color(236, 243, 250));
            this.tableHistory.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.tableHistory.setEditable(false);
            this.tableHistory.setColumnControlVisible(false);
            this.tableHistory.setAutoResizeMode(3);
            this.tableHistory.setSortable(false);
            this.tableHistory.setModel(this.getQueryHistoryTableModel());
            Font font = this.getTxtPreview().getFont();
            this.tableHistory.setFont(font);
            FontMetrics fm = this.tableHistory.getFontMetrics(font);
            int width = fm.stringWidth(" MM/MM/MMMM 99:99:99 ") + 10;
            TableColumn colDate = this.tableHistory.getColumn(0);
            colDate.setMinWidth(width);
            colDate.setMaxWidth(width);
            colDate.setResizable(false);
            DefaultTableCellRenderer datetimeRenderer = new DefaultTableCellRenderer(){
                final SimpleDateFormat shortDateTimeFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value instanceof Date) {
                        value = this.shortDateTimeFormat.format(value);
                    } else if (value instanceof Long) {
                        value = this.shortDateTimeFormat.format(new Date((Long)value));
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
            colDate.setCellRenderer(datetimeRenderer);
            this.tableHistory.setDefaultRenderer(Date.class, datetimeRenderer);
            this.tableHistory.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() >= 2) {
                        QueryHistoryEntry selectedEntry = QueryHistoryPanel.this.getSelectedQueryHistoryEntry();
                        if (selectedEntry == null) {
                            return;
                        }
                        Component comp = MainWindow.getInstance().getCurrentTabComponent();
                        if (comp instanceof QueryPanel) {
                            QueryPanel queryPanel = (QueryPanel)comp;
                            String newSql = String.format("%s\n\n%s", queryPanel.getQueryText(), selectedEntry.query);
                            queryPanel.setQueryText(newSql);
                        }
                    }
                }
            });
            this.tableHistory.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e2) {
                    super.mouseMoved(e2);
                    int index = QueryHistoryPanel.this.getTableHistory().rowAtPoint(e2.getPoint());
                    if (index < 0) {
                        return;
                    }
                    index = QueryHistoryPanel.this.getTableHistory().getRowSorter().convertRowIndexToModel(index);
                    QueryHistoryEntry entry = QueryHistory.getInstance().getQueryHistoryAt(index);
                    String value = entry.query;
                    int length = Math.min(value.length(), 300);
                    Date time = new Date(entry.timestamp);
                    String queryText = value.substring(0, length).replaceAll("\n", "<br/>");
                    String html = String.format("<html><h4>Executed at %s</h4><code style=\"background-color: white;\">%s</code></html>", time, queryText);
                    QueryHistoryPanel.this.getTableHistory().setToolTipText(html);
                }
            });
            this.tableHistory.getSelectionModel().addListSelectionListener(evt -> {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                QueryHistoryEntry entry = this.getSelectedQueryHistoryEntry();
                this.getTxtPreview().setText(entry == null ? "" : entry.query);
                this.getLblInfos().setText(entry == null ? "" : localeDateFormat.format(new Date(entry.timestamp)));
            });
        }
        return this.tableHistory;
    }

    private QueryHistoryTableModel getQueryHistoryTableModel() {
        if (this.queryHistoryTableModel == null) {
            this.queryHistoryTableModel = new QueryHistoryTableModel();
        }
        return this.queryHistoryTableModel;
    }

    private JXPanel getPnlInfos() {
        if (this.pnlInfos == null) {
            this.pnlInfos = new JXPanel();
            this.pnlInfos.setLayout(new FlowLayout(4));
            this.pnlInfos.setOpaque(true);
            this.pnlInfos.setBackground(Color.WHITE);
            this.pnlInfos.add(this.getLblInfos());
            this.pnlInfos.add(this.getBtnCopy());
        }
        return this.pnlInfos;
    }

    private JXLabel getLblInfos() {
        if (this.lblInfos == null) {
            this.lblInfos = new JXLabel(" ");
        }
        return this.lblInfos;
    }

    private JButton getBtnCopy() {
        if (this.btnCopy == null) {
            CopyAllAction action = new CopyAllAction(this.getTxtPreview());
            this.btnCopy = new JButton(action);
            this.btnCopy.setToolTipText("Copy to clipboard");
            this.btnCopy.setPreferredSize(new Dimension(24, 24));
            this.btnCopy.setText("");
            this.btnCopy.setIcon(action.getSmallIcon());
        }
        return this.btnCopy;
    }

    private RTextScrollPane getScrollPreview() {
        if (this.scrollPreview == null) {
            this.scrollPreview = new RTextScrollPane(this.getTxtPreview());
            this.scrollPreview.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.scrollPreview;
    }

    private RTextArea getTxtPreview() {
        if (this.txtPreview == null) {
            this.txtPreview = new RSyntaxTextArea();
            this.txtPreview.setEditable(false);
            this.txtPreview.setSyntaxEditingStyle("text/sql");
        }
        return this.txtPreview;
    }
}

