/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.logging.Logger;
import net.hironico.minisql.ui.visualdb.DbGraphNodeBorder;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.anchor.PointShapeFactory;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;

public class DbColorScheme
extends VMDColorScheme {
    private static final Logger LOGGER = Logger.getLogger(DbColorScheme.class.getName());
    private Color baseColor;
    private Color COLOR_NORMAL = new Color(12242416);
    private Color COLOR_HIGHLIGHTED = new Color(3238597);
    private Color COLOR1 = new Color(221, 235, 246);
    private Color COLOR2 = new Color(255, 255, 255);
    public static final Color COLOR60_SELECT = new Color(16745728);
    private Color COLOR60_HOVER = new Color(5990320);
    private Color COLOR60_HOVER_BACKGROUND = new Color(11584481);
    private Border BORDER60 = new DbGraphNodeBorder(this.COLOR_NORMAL, 2, this.COLOR1, this.COLOR2);
    private Border BORDER60_SELECT = new DbGraphNodeBorder(COLOR60_SELECT, 2, this.COLOR1, this.COLOR2);
    private Border BORDER60_HOVER = new DbGraphNodeBorder(this.COLOR60_HOVER, 2, this.COLOR1, this.COLOR2);
    static final Border BORDER_PIN = BorderFactory.createOpaqueBorder(2, 8, 2, 8);
    private static final Border BORDER60_PIN_SELECT = BorderFactory.createCompositeBorder(BorderFactory.createLineBorder(0, 1, 0, 1, COLOR60_SELECT), BorderFactory.createLineBorder(2, 7, 2, 7, COLOR60_SELECT));
    private static final PointShape POINT_SHAPE60_IMAGE = PointShapeFactory.createImagePointShape(ImageUtilities.loadImage("org/netbeans/modules/visual/resources/vmd-pin-60.png"));
    private Color BORDER_CATEGORY_BACKGROUND = new Color(13491704);

    public DbColorScheme(String baseColorCode) {
        try {
            Color baseColor;
            this.COLOR_NORMAL = baseColor = Color.decode(baseColorCode);
            this.COLOR_HIGHLIGHTED = baseColor;
            this.COLOR1 = baseColor;
            this.COLOR2 = Color.WHITE;
            this.COLOR60_HOVER = baseColor.darker();
            this.COLOR60_HOVER_BACKGROUND = baseColor.darker();
            this.BORDER_CATEGORY_BACKGROUND = baseColor.darker();
            this.BORDER60 = new DbGraphNodeBorder(this.COLOR_NORMAL, 2, this.COLOR1, this.COLOR2);
            this.BORDER60_SELECT = new DbGraphNodeBorder(COLOR60_SELECT, 2, this.COLOR1, this.COLOR2);
            this.BORDER60_HOVER = new DbGraphNodeBorder(this.COLOR60_HOVER, 2, this.COLOR1, this.COLOR2);
        }
        catch (NumberFormatException nfe) {
            LOGGER.severe("Cannot decode base color code. Let color as default !");
        }
    }

    @Override
    public void installUI(VMDNodeWidget widget) {
        widget.setBorder(this.BORDER60);
        Widget header = widget.getHeader();
        header.setBackground(this.COLOR60_HOVER_BACKGROUND);
        widget.getNodeNameWidget().setForeground(this.getLabelColorFromBackground(this.COLOR60_HOVER_BACKGROUND));
        header.getChildren().get(2).setForeground(this.getLabelColorFromBackground(this.COLOR60_HOVER_BACKGROUND));
        header.setBorder(BORDER_PIN);
        Widget pinsSeparator = widget.getPinsSeparator();
        pinsSeparator.setForeground(this.BORDER_CATEGORY_BACKGROUND);
    }

    @Override
    public void updateUI(VMDNodeWidget widget, ObjectState previousState, ObjectState state) {
        if (!previousState.isSelected() && state.isSelected()) {
            widget.bringToFront();
        }
        boolean hover = state.isHovered() || state.isFocused();
        widget.getHeader().setOpaque(hover);
        if (state.isSelected()) {
            widget.setBorder(this.BORDER60_SELECT);
        } else if (state.isHovered()) {
            widget.setBorder(this.BORDER60_HOVER);
        } else if (state.isFocused()) {
            widget.setBorder(this.BORDER60_HOVER);
        } else {
            widget.setBorder(this.BORDER60);
        }
    }

    @Override
    public void installUI(VMDConnectionWidget widget) {
        widget.setSourceAnchorShape(AnchorShape.NONE);
        widget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        widget.setPaintControlPoints(true);
    }

    @Override
    public void updateUI(VMDConnectionWidget widget, ObjectState previousState, ObjectState state) {
        if (state.isSelected()) {
            widget.setForeground(COLOR60_SELECT);
        } else if (state.isHighlighted()) {
            widget.setForeground(this.COLOR_HIGHLIGHTED);
        } else if (state.isHovered() || state.isFocused()) {
            widget.setForeground(this.COLOR60_HOVER);
        } else {
            widget.setForeground(this.COLOR_NORMAL);
        }
        if (state.isSelected() || state.isHovered()) {
            widget.setControlPointShape(PointShape.SQUARE_FILLED_SMALL);
            widget.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
            widget.setControlPointCutDistance(0);
        } else {
            widget.setControlPointShape(PointShape.NONE);
            widget.setEndPointShape(POINT_SHAPE60_IMAGE);
            widget.setControlPointCutDistance(5);
        }
    }

    @Override
    public void installUI(VMDPinWidget widget) {
        widget.setBorder(BORDER_PIN);
        widget.setBackground(this.COLOR60_HOVER_BACKGROUND);
    }

    @Override
    public void updateUI(VMDPinWidget widget, ObjectState previousState, ObjectState state) {
        widget.setOpaque(state.isHovered() || state.isFocused());
        if (state.isSelected()) {
            widget.setBorder(BORDER60_PIN_SELECT);
        } else {
            widget.setBorder(BORDER_PIN);
        }
    }

    @Override
    public int getNodeAnchorGap(VMDNodeAnchor anchor) {
        return 4;
    }

    @Override
    public boolean isNodeMinimizeButtonOnRight(VMDNodeWidget widget) {
        return true;
    }

    @Override
    public Image getMinimizeWidgetImage(VMDNodeWidget widget) {
        return widget.isMinimized() ? ImageUtilities.loadImage("org/netbeans/modules/visual/resources/vmd-expand-60.png") : ImageUtilities.loadImage("org/netbeans/modules/visual/resources/vmd-collapse-60.png");
    }

    @Override
    public Widget createPinCategoryWidget(VMDNodeWidget widget, String categoryDisplayName) {
        return this.createPinCategoryWidgetCore(widget, categoryDisplayName, false);
    }

    private Widget createPinCategoryWidgetCore(VMDNodeWidget widget, String categoryDisplayName, boolean changeFont) {
        Scene scene = widget.getScene();
        LabelWidget label = new LabelWidget(scene, categoryDisplayName);
        label.setOpaque(true);
        label.setBackground(this.BORDER_CATEGORY_BACKGROUND);
        label.setForeground(this.getLabelColorFromBackground(this.BORDER_CATEGORY_BACKGROUND));
        if (changeFont) {
            Font fontPinCategory = scene.getDefaultFont().deriveFont(10.0f);
            label.setFont(fontPinCategory);
        }
        label.setAlignment(LabelWidget.Alignment.CENTER);
        label.setCheckClipping(true);
        return label;
    }

    private Color getLabelColorFromBackground(Color bg) {
        if ((double)bg.getRed() * 0.299 + (double)bg.getGreen() * 0.587 + (double)bg.getBlue() * 0.114 > 186.0) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }
}

