/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb.action;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.hironico.minisql.ui.visualdb.DBGraphScene;
import net.hironico.minisql.ui.visualdb.action.ExportSceneImageAction;

public class ExportSceneImageToFileAction
extends ExportSceneImageAction {
    public ExportSceneImageToFileAction() {
        super("To File", "icons8_png_64px.png");
    }

    @Override
    public void performSceneAction(DBGraphScene graphScene) {
        BufferedImage buffImage = this.getSceneImage();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f2) {
                return f2 != null && (f2.getName().toLowerCase().endsWith(".png") || f2.isDirectory());
            }

            @Override
            public String getDescription() {
                return "PNG files";
            }
        });
        chooser.setAcceptAllFileFilterUsed(true);
        int ret = chooser.showSaveDialog(graphScene.getView());
        if (ret != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().toLowerCase().endsWith(".png")) {
            file = new File(file.getName() + ".png");
        }
        try {
            ImageIO.write((RenderedImage)buffImage, "PNG", file);
            JOptionPane.showMessageDialog(graphScene.getView(), "Image saved into:\n" + file.getName(), "Yeah...", 1);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Cannot export image data into file.", ex);
            JOptionPane.showMessageDialog(graphScene.getView(), "Cannot write image data into the selected file.\n" + ex.getMessage(), "Ohoh...", 0);
        }
    }
}

