/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;

public class Message {
    protected boolean complete = false;
    protected ByteArrayOutputStream body = new ByteArrayOutputStream(0);
    private ByteArrayOutputStream header = new ByteArrayOutputStream(4096);
    private Writer builder = new OutputStreamWriter((OutputStream)this.header, ONSConfiguration.ONS_CHARSET);

    byte[] dump() {
        return this.header.toByteArray();
    }

    public Message(String verb) {
        try {
            this.builder.append("POST").append(" /").append(verb).append(" HTTP/1.1").append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message(Message x2) {
        try {
            x2.builder.flush();
            this.body.write(x2.body.toByteArray());
            this.header.write(x2.header.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message put(String name, String value) {
        try {
            this.builder.append(name).append(": ").append(value).append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Message ready() {
        if (this.complete) {
            return this;
        }
        try {
            this.body.close();
            this.put(Notification.internalPropertyList[19], Integer.toString(this.body.size()));
            this.builder.append("\r\n").flush();
            this.builder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.complete = true;
        return this;
    }

    protected Message sealAsIs() {
        if (this.complete) {
            return this;
        }
        try {
            this.body.close();
            this.builder.append("\r\n").flush();
            this.builder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.complete = true;
        return this;
    }

    OutputStream send(OutputStream stream) throws IOException {
        this.ready();
        stream.write(this.header.toByteArray());
        stream.write(this.body.toByteArray());
        return stream;
    }

    public OutputStream getBodyOutputStream() {
        return this.body;
    }

    public String toString() {
        return this.header.toString();
    }
}

