/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import oracle.ons.Message;
import oracle.ons.MessageReader;

public class MessageReaderTest {
    private final Random random = new Random();

    public static void main(String[] args) {
        new MessageReaderTest().go(Integer.parseInt(args[0]));
    }

    private boolean prob(double p2) {
        return this.random.nextDouble() < p2;
    }

    private String randString(int lengthMin, int lengthRange) {
        int i2;
        StringBuilder x2 = new StringBuilder();
        for (i2 = 0; i2 < lengthMin; ++i2) {
            x2.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        for (i2 = 0; i2 < lengthRange && !this.prob(1.0 / (double)lengthRange); ++i2) {
            x2.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        return x2.toString();
    }

    private void go(int num) {
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        ByteArrayOutputStream stream = new ByteArrayOutputStream(0x6500000);
        int tlen = 0;
        System.out.println(String.format("Generating %d messages...", num));
        try {
            for (int i2 = 0; i2 < num; ++i2) {
                Message m4 = this.createMessage();
                if (stream.size() > 0x6400000) {
                    System.out.println(String.format("100M (%d) exceeded, new buffer", stream.size() / 1024));
                    stream.close();
                    tlen += stream.size();
                    buffers.add(stream.toByteArray());
                    stream = new ByteArrayOutputStream();
                }
                m4.send(stream);
            }
            stream.close();
            buffers.add(stream.toByteArray());
            tlen += stream.size();
            stream = null;
        }
        catch (IOException i2) {
            // empty catch block
        }
        MessageReader reader = new MessageReader();
        System.out.println("Total length : " + Integer.toString(tlen));
        System.out.println("Parsing...");
        int mcnt = 0;
        long t0 = System.currentTimeMillis();
        for (byte[] buf : buffers) {
            int bpos = 0;
            while (bpos < buf.length) {
                int len = Math.min(this.random.nextInt(8192) + 16384, buf.length - bpos);
                reader.feedBuffer(buf, bpos, len);
                bpos += len;
                while (reader.available()) {
                    reader.remove();
                    ++mcnt;
                }
            }
        }
        long t1 = System.currentTimeMillis();
        double speed = 0.953674 * ((double)tlen / (double)(t1 - t0)) / 1000.0;
        System.out.println(String.format("Parsed %d messages in %d msec (%f Mb/sec)", mcnt, (int)(t1 - t0), speed));
    }

    private Message createMessage() {
        Message msg = new Message(this.randString(5, 5));
        while (this.prob(0.7)) {
            msg.put(this.randString(5, 15), this.randString(2, 20));
        }
        if (this.prob(0.2)) {
            byte[] body = new byte[this.random.nextInt(128)];
            this.random.nextBytes(body);
            try {
                msg.getBodyOutputStream().write(body);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        msg.ready();
        return msg;
    }
}

