/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.Message;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.Publisher;

public class Notification {
    protected Map<String, String> properties = new HashMap<String, String>(4);
    protected byte[] body = new byte[0];
    protected String method;
    protected String verb;
    private String[] subscribers = null;
    protected long creationTime = -1L;
    protected long deliveryTime = -1L;
    private boolean systemEventFlag = false;
    private Throwable exception = null;
    protected int readHelperContentLength = 0;
    private NotificationKey key = null;
    protected final String[] internalProperties = new String[internalPropertyList.length];
    public static final int RESULT_SUCCESS = 1;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Map<String, Integer> internalPropertyMap;
    protected static final int INTPROP_RESULT = 0;
    protected static final int INTPROP_MESSAGE = 1;
    protected static final int INTPROP_ORIGIN = 2;
    protected static final int INTPROP_STAMP = 3;
    protected static final int INTPROP_VERSION = 4;
    protected static final int INTPROP_TYPE = 5;
    protected static final int INTPROP_AFFECTED_COMPONENTS = 6;
    protected static final int INTPROP_AFFECTED_NODES = 7;
    protected static final int INTPROP_GENERATING_COMPONENT = 8;
    protected static final int INTPROP_GENERATING_PROCESS = 9;
    protected static final int INTPROP_GENERATING_NODE = 10;
    protected static final int INTPROP_EVENT_ID = 11;
    protected static final int INTPROP_CTIME = 12;
    protected static final int INTPROP_CLUSTER_ID = 13;
    protected static final int INTPROP_CLUSTER_NAME = 14;
    protected static final int INTPROP_INSTANCE_ID = 15;
    protected static final int INTPROP_INSTANCE_NAME = 16;
    protected static final int INTPROP_LOCAL_ONLY = 17;
    protected static final int INTPROP_NUMBER_OF_PROPERTIES = 18;
    protected static final int INTPROP_CONTENT_LENGTH = 19;
    protected static final int INTPROP_SUBSCRIBER = 20;
    protected static final String[] internalPropertyList;
    private static UUID onsSessionId;
    private static AtomicInteger messageIdGenerator;

    private String getInternalNonNull(int prop) {
        return this.internalProperties[prop] != null ? this.internalProperties[prop] : "";
    }

    public String getVersion() {
        return this.getInternalNonNull(4);
    }

    public String affectedComponents() {
        return this.internalProperties[6];
    }

    public String affectedNodes() {
        return this.internalProperties[7];
    }

    public String generatingComponent() {
        return this.internalProperties[8];
    }

    public String generatingNode() {
        String node = this.internalProperties[10];
        if (node == null) {
            node = this.generatingNodeFromEventId();
        }
        return node;
    }

    public String generatingProcess() {
        return this.internalProperties[9];
    }

    public String clusterId() {
        return this.internalProperties[13];
    }

    public String clusterName() {
        return this.internalProperties[14];
    }

    public String instanceId() {
        return this.internalProperties[15];
    }

    public String instanceName() {
        return this.internalProperties[16];
    }

    public boolean isSystemNotification() {
        return this.systemEventFlag;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Deprecated
    public Notification(String type, String ignore1, String ignore2, byte[] body, ONS ignore3) {
        this("event");
        this.internalProperties[5] = type;
        this.internalProperties[6] = ignore1;
        this.internalProperties[7] = ignore2;
        if (null != body) {
            this.body = body;
        }
    }

    public Notification(String type, String ignore1, String ignore2, byte[] body) {
        this("event");
        this.internalProperties[5] = type;
        this.internalProperties[6] = ignore1;
        this.internalProperties[7] = ignore2;
        if (null != body) {
            this.body = body;
        }
    }

    public Notification put(String key, String value) {
        Integer x2 = internalPropertyMap.get(key.toLowerCase());
        if (x2 != null) {
            this.internalProperties[x2.intValue()] = value;
            if (x2 == 19) {
                this.readHelperContentLength = Integer.parseInt(value);
            }
        } else {
            this.properties.put(key, value);
        }
        return this;
    }

    public void putInternalProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public boolean hasProperty(String key) {
        Integer i2 = internalPropertyMap.get(key.toLowerCase());
        return i2 != null && this.internalProperties[i2] != null || this.properties.containsKey(key);
    }

    public String get(String key) {
        Integer x2 = internalPropertyMap.get(key.toLowerCase());
        return x2 != null ? this.internalProperties[x2] : this.properties.get(key);
    }

    public String getNonNull(String key, String ifNull) {
        Integer x2 = internalPropertyMap.get(key.toLowerCase());
        String v2 = x2 != null ? this.internalProperties[x2] : this.properties.get(key);
        return v2 != null ? v2 : ifNull;
    }

    @Deprecated
    public void setProperty(String key, String val) {
        this.put(key, val);
    }

    @Deprecated
    public String getProperty(String s2) {
        return this.get(s2);
    }

    private static String nvl(String a2, String b2) {
        return a2 != null ? a2 : b2;
    }

    public NotificationKey getKey() {
        if (this.key == null) {
            if (this.internalProperties[3] == null || this.internalProperties[3].equals("00000000.00000000")) {
                return null;
            }
            this.key = new NotificationKey();
        }
        return this.key;
    }

    Notification(Throwable exception, String verb, Notification status) {
        this.creationTime = System.currentTimeMillis();
        this.systemEventFlag = true;
        this.exception = exception;
        this.verb = verb;
        if (status != null) {
            System.arraycopy(status.internalProperties, 0, this.internalProperties, 0, internalPropertyList.length);
            this.properties.putAll(status.properties);
        }
    }

    public Notification() {
        this.creationTime = System.currentTimeMillis();
    }

    public Notification(String verb) {
        this.creationTime = System.currentTimeMillis();
        this.verb = verb;
    }

    public String toNiceString() {
        StringBuilder sb = new StringBuilder("[[ ").append(this.verb).append("\n");
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[i2] == null) continue;
            sb.append("  ").append(internalPropertyList[i2]).append(':').append(this.internalProperties[i2]).append("\n");
        }
        for (Map.Entry<String, String> v2 : this.properties.entrySet()) {
            sb.append("  ").append(v2.getKey()).append(':').append(v2.getValue()).append("\n");
        }
        return sb.append("]]\n").toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.verb).append(" ");
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[i2] == null) continue;
            sb.append(internalPropertyList[i2]).append(':').append(this.internalProperties[i2]).append(";");
        }
        sb.append(this.properties.toString());
        return sb.append(")").toString();
    }

    public String[] getSubscribers() {
        if (this.subscribers == null) {
            this.subscribers = this.internalProperties[20] == null ? EMPTY_ARRAY : this.internalProperties[20].split(";\\s*");
        }
        return this.subscribers;
    }

    public String getEventType() {
        return this.internalProperties[5];
    }

    public int getResult() {
        return this.internalProperties[0] != null && this.internalProperties[0].equals("success") ? 1 : 0;
    }

    public String getMessage(String ifNull) {
        return this.internalProperties[1] != null ? this.internalProperties[1] : ifNull;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Deprecated
    public void print() {
        System.out.println(this.toString());
    }

    public String type() {
        return this.getEventType();
    }

    public byte[] body() {
        return this.getBody();
    }

    private String generatingNodeFromEventId() {
        int endIdx;
        int begIdx;
        String node = null;
        String eventId = this.internalProperties[11];
        if (eventId != null && (begIdx = eventId.indexOf(64)) != -1 && (endIdx = eventId.indexOf(58, ++begIdx)) != -1) {
            node = eventId.substring(begIdx, endIdx);
        }
        return node;
    }

    protected synchronized Message toMessageVersion4(Publisher publisher) throws IOException {
        Message message = new Message(this.verb);
        String saveGeneratingComponent = null;
        this.internalProperties[18] = Integer.toString(this.properties.size());
        this.internalProperties[12] = Long.toString(this.creationTime);
        this.internalProperties[11] = Integer.toString(messageIdGenerator.getAndIncrement()) + '@' + ONSConfiguration.getHostname() + ':' + onsSessionId.toString();
        if (this.internalProperties[17] == null) {
            this.internalProperties[17] = "false";
        }
        if (publisher.componentName != null) {
            saveGeneratingComponent = this.internalProperties[8];
            this.internalProperties[8] = publisher.componentName;
        }
        message.put(internalPropertyList[4], "4");
        for (int i2 = 5; i2 <= 18; ++i2) {
            message.put(internalPropertyList[i2], this.getInternalNonNull(i2));
        }
        if (publisher.componentName != null) {
            this.internalProperties[8] = saveGeneratingComponent;
        }
        for (Map.Entry<String, String> x2 : this.properties.entrySet()) {
            message.put(x2.getKey(), x2.getValue());
        }
        message.getBodyOutputStream().write(this.body);
        return message.ready();
    }

    protected synchronized Message toMessage(Publisher publisher) throws IOException {
        Message message = new Message(this.verb);
        String saveGeneratingComponent = null;
        message.put(internalPropertyList[4], "5");
        this.internalProperties[11] = Integer.toString(messageIdGenerator.getAndIncrement()) + '@' + ONSConfiguration.getHostname() + ':' + onsSessionId.toString();
        if (publisher.componentName != null) {
            saveGeneratingComponent = this.internalProperties[8];
            this.internalProperties[8] = publisher.componentName;
        }
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (i2 == 19 || this.internalProperties[i2] == null || this.internalProperties[i2].isEmpty()) continue;
            message.put(internalPropertyList[i2], this.internalProperties[i2]);
        }
        if (publisher.componentName != null) {
            this.internalProperties[8] = saveGeneratingComponent;
        }
        for (Map.Entry<String, String> x2 : this.properties.entrySet()) {
            message.put(x2.getKey(), x2.getValue());
        }
        message.getBodyOutputStream().write(this.body);
        return message;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long deliveryTime() {
        return this.deliveryTime;
    }

    public String id() {
        return this.internalProperties[11];
    }

    @Deprecated
    public NotificationProperty[] getAllProperties() {
        int count = 0;
        int j2 = 0;
        for (String p2 : this.internalProperties) {
            if (p2 == null) continue;
            ++count;
        }
        NotificationProperty[] result = new NotificationProperty[count + this.properties.size()];
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            if (this.internalProperties[j2] == null) continue;
            result[j2++] = new NotificationProperty(internalPropertyList[i2], this.internalProperties[j2]);
        }
        for (Map.Entry<String, String> x2 : this.properties.entrySet()) {
            result[j2++] = new NotificationProperty(x2.getKey(), x2.getValue());
        }
        return result;
    }

    public void setLocalOnly() {
        this.internalProperties[17] = "true";
    }

    public boolean getLocalOnly() {
        String lo = this.internalProperties[17];
        return lo != null && lo.toLowerCase().equals("true");
    }

    public String getVerb() {
        return this.verb;
    }

    public String dump() {
        try {
            return new String(this.toMessage(null).dump());
        }
        catch (IOException e2) {
            return "Error!";
        }
    }

    @Deprecated
    public void print(ONS ons) {
        this.print();
    }

    static {
        internalPropertyList = new String[]{"Result", "Message", "origin", "stamp", "Version", "eventType", "affectedComponents", "affectedNodes", "generatingComponent", "generatingProcess", "generatingNode", "eventId", "creationTime", "clusterId", "clusterName", "instanceId", "instanceName", "LocalOnly", "numberOfProperties", "Content-Length", "SubscriberID"};
        HashMap<String, Integer> aInternalProperties = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < internalPropertyList.length; ++i2) {
            aInternalProperties.put(internalPropertyList[i2].toLowerCase(), i2);
        }
        internalPropertyMap = Collections.unmodifiableMap(aInternalProperties);
        onsSessionId = UUID.randomUUID();
        messageIdGenerator = new AtomicInteger(0);
    }

    class NotificationKey {
        String stamp;

        public NotificationKey() {
            this.stamp = Notification.nvl(Notification.this.internalProperties[3], "~") + "@" + Notification.nvl(Notification.this.internalProperties[2], "[]");
        }

        public boolean expired(long windowStart) {
            return Notification.this.creationTime < windowStart;
        }

        public void touch() {
            Notification.this.creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object o2) {
            return o2 != null && this.getClass() == o2.getClass() && this.stamp.equals(((NotificationKey)o2).stamp);
        }

        public int hashCode() {
            return this.stamp.hashCode();
        }
    }
}

