/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ons.Message;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;

class SubscriptionProxy {
    private final Map<Integer, WeakReference<Subscriber>> frontendSubscribers = new ConcurrentHashMap<Integer, WeakReference<Subscriber>>();
    private final NotificationNetwork network;
    private final Map<Notification.NotificationKey, Notification.NotificationKey> notificationHistory = new ConcurrentHashMap<Notification.NotificationKey, Notification.NotificationKey>();
    private final Queue<Notification.NotificationKey> notificationHistoryTimeouts = new LinkedList<Notification.NotificationKey>();
    private final String subscriptionKey;
    protected final Message subscriptionMessage;
    private volatile Notification registrationNotification = null;

    public SubscriptionProxy(NotificationNetwork network, Subscriber subscriber) {
        this.add(subscriber);
        this.subscriptionKey = subscriber.getSubscriptionKey();
        this.subscriptionMessage = subscriber.getSubscriptionMessage();
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(Notification n2) throws InterruptedException {
        ++this.network.messageReceived;
        if (n2.getKey() != null) {
            long windowStart = System.currentTimeMillis() - this.network.config.getNotificationWindow();
            Notification.NotificationKey key = this.notificationHistory.get(n2.getKey());
            if (key != null) {
                ++this.network.messageDropped;
                return;
            }
            SubscriptionProxy subscriptionProxy = this;
            synchronized (subscriptionProxy) {
                while (!this.notificationHistoryTimeouts.isEmpty() && this.notificationHistoryTimeouts.peek().expired(windowStart)) {
                    this.notificationHistory.remove(this.notificationHistoryTimeouts.remove());
                }
                this.notificationHistoryTimeouts.add(n2.getKey());
            }
            this.notificationHistory.put(n2.getKey(), n2.getKey());
        }
        for (WeakReference<Subscriber> s2 : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s2.get();
            if (subscriber == null) continue;
            subscriber.put(n2);
        }
    }

    public void add(Subscriber s2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.frontendSubscribers.put(s2.id, new WeakReference<Subscriber>(s2));
        if (this.registrationNotification != null) {
            try {
                s2.put(this.registrationNotification);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void setRegistrationNotification(Notification n2) {
        this.registrationNotification = n2;
    }

    public void remove(Subscriber subscriber) {
        this.frontendSubscribers.remove(subscriber.id);
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public boolean isEmpty() {
        return this.frontendSubscribers.isEmpty();
    }

    protected void setServerSubscriberInfo(Node node, String sid) {
        for (WeakReference<Subscriber> s2 : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s2.get();
            if (subscriber == null) continue;
            subscriber.setServerSubscriberInfo(node, sid);
        }
    }
}

