/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;

public class ASN1ConstructedInputStream
extends FilterInputStream {
    private int a;
    private int b = 0;
    private int c = -1;

    public ASN1ConstructedInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTagClass(128);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n2) throws IOException {
        this(inputStream, n2, 128);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, int n2, int n3) throws IOException {
        super(inputStream);
        ASN1Header aSN1Header = new ASN1Header(this.in);
        aSN1Header.checkTag(n2);
        aSN1Header.checkTagClass(n3);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected");
        }
        this.a(aSN1Header);
    }

    public ASN1ConstructedInputStream(InputStream inputStream, ASN1Header aSN1Header) {
        super(inputStream);
        this.a(aSN1Header);
    }

    private void a(ASN1Header aSN1Header) {
        this.a = aSN1Header.getBodyLength();
    }

    @Override
    public int read() throws IOException {
        if (this.c == -1) {
            if (this.a != -1 && this.b >= this.a) {
                return -1;
            }
            int n2 = super.read();
            if (n2 == -1) {
                throw new ASN1FormatException("End of input.");
            }
            ++this.b;
            return n2;
        }
        int n3 = this.c;
        this.c = -1;
        ++this.b;
        return n3;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (this.a == -1 || this.b + n3 <= this.a) {
            int n4 = 0;
            if (this.c != -1) {
                byArray[n2] = (byte)this.c;
                n4 = 1;
            }
            int n5 = n4 + super.read(byArray, n2, n3 - n4);
            this.b += n5;
            return n5;
        }
        throw new ASN1FormatException("Contents length exceeded.");
    }

    @Override
    public int available() throws IOException {
        return (this.c != -1 ? 1 : 0) + super.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void a(int n2) {
        if (this.c == -1) {
            this.c = n2 & 0xFF;
            --this.b;
        } else {
            throw new IllegalStateException("Pushback buffer is full.");
        }
    }

    public boolean hasMoreData() throws IOException {
        if (this.a >= 0) {
            return this.b < this.a;
        }
        int n2 = this.read();
        if (n2 == -1) {
            throw new ASN1FormatException("End of input.");
        }
        this.a(n2);
        return n2 != 0;
    }

    public void terminate(boolean bl) throws IOException {
        if (bl) {
            while (this.hasMoreData()) {
                ASN1Utils.inputASN1Object(this);
            }
        }
        if (this.a >= 0) {
            if (this.b < this.a) {
                throw new ASN1FormatException("End of constructed encoding expected.");
            }
        } else {
            if (this.read() != 0) {
                throw new ASN1FormatException("First end-of-contents octet expected.");
            }
            if (this.read() != 0) {
                throw new ASN1FormatException("Second end-of-contents octet expected.");
            }
        }
    }

    public void terminate() throws IOException {
        this.terminate(false);
    }

    public int getCurrentIDByte() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            return -1;
        }
        this.a(n2);
        return n2;
    }

    public int getCurrentTag() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            return -1;
        }
        this.a(n2);
        int n3 = n2 & 0x1F;
        return n3;
    }

    public void setCurrentTag(int n2) throws IOException {
        int n3 = this.read();
        if (n3 == -1) {
            throw new EOFException();
        }
        this.a((n3 & 0x20) + n2);
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

