/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public class ASN1String
implements ASN1TaggedObject {
    private ASN1Header a;
    private String b;
    private byte[] c;
    private static final int d = 22;

    public ASN1String(String string) {
        this.a(string, 22);
    }

    public ASN1String(String string, int n2) {
        this.a(string, n2);
    }

    public ASN1String(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(String string, int n2) {
        int n3;
        this.b = string;
        if (n2 == 12) {
            this.c = Utils.toUTF8(string);
            n3 = this.c.length;
        } else {
            n3 = n2 == 30 ? 2 * string.length() : (n2 == 28 ? 4 * string.length() : string.length());
        }
        this.a = new ASN1Header(n2, 0, 0, n3);
    }

    @Override
    public ASN1Header getHeader() {
        return this.a;
    }

    public String getValue() {
        return this.b;
    }

    public int getTag() {
        return this.a.getTag();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a.getTag()) {
            case 19: {
                stringBuffer.append("PrintableString");
                break;
            }
            case 20: {
                stringBuffer.append("T61String");
                break;
            }
            case 22: {
                stringBuffer.append("IA5String");
                break;
            }
            case 25: {
                stringBuffer.append("GraphicString");
                break;
            }
            case 26: {
                stringBuffer.append("VisibleString");
                break;
            }
            case 27: {
                stringBuffer.append("GeneralString");
                break;
            }
            case 30: {
                stringBuffer.append("BMPString");
                break;
            }
            case 28: {
                stringBuffer.append("UniversalString");
                break;
            }
            case 12: {
                stringBuffer.append("UTF8String");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ASN.1 string type.");
            }
        }
        stringBuffer.append(" \"");
        stringBuffer.append(this.b);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = ASN1String.a(inputStream, stringBuffer);
        this.a(stringBuffer.toString(), n2);
    }

    public static String inputValue(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        ASN1String.a(inputStream, stringBuffer);
        return stringBuffer.toString();
    }

    private static int a(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        int n2 = aSN1Header.getTag();
        if (n2 != 19 && n2 != 20 && n2 != 22 && n2 != 25 && n2 != 26 && n2 != 27 && n2 != 30 && n2 != 28 && n2 != 12) {
            throw new ASN1FormatException("Got tag " + n2 + " instead of an ASN.1 string type.");
        }
        if (aSN1Header.getEncodingMethod() == 0) {
            byte[] byArray = aSN1Header.readBody(inputStream);
            if (n2 == 30) {
                int n3 = byArray.length - 1;
                for (int i2 = 0; i2 < n3; i2 += 2) {
                    stringBuffer.append((char)(byArray[i2] << 8 | byArray[i2 + 1] & 0xFF));
                }
            } else if (n2 == 28) {
                int n4 = byArray.length - 1;
                for (int i3 = 0; i3 < n4; i3 += 4) {
                    stringBuffer.append((char)(byArray[i3] << 24 | byArray[i3 + 1] << 16 | byArray[i3 + 2] << 8 | byArray[i3 + 3] & 0xFF));
                }
            } else if (n2 == 12) {
                stringBuffer.append(Utils.fromUTF8(byArray));
            } else {
                int n5 = byArray.length;
                for (int i4 = 0; i4 < n5; ++i4) {
                    stringBuffer.append((char)(byArray[i4] & 0xFF));
                }
            }
        } else {
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.hasMoreData()) {
                int n6 = ASN1String.a(inputStream, stringBuffer);
                if (n6 == n2) continue;
                throw new ASN1FormatException("Got tag " + n6 + " instead of " + n2 + ".");
            }
            aSN1ConstructedInputStream.terminate();
        }
        return n2;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        int n2 = this.a.getTag();
        if (n2 == 12) {
            outputStream.write(this.c);
        } else if (n2 == 30) {
            ASN1String.a(outputStream, this.b);
        } else if (n2 == 28) {
            ASN1String.b(outputStream, this.b);
        } else {
            ASN1String.c(outputStream, this.b);
        }
    }

    @Override
    public int length() {
        return this.a.totalLength();
    }

    public static void outputValue(OutputStream outputStream, String string) throws IOException {
        ASN1String.a(outputStream, string, 22, 0);
    }

    public static void outputValue(OutputStream outputStream, String string, int n2) throws IOException {
        ASN1String.a(outputStream, string, n2, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, String string, int n2) throws IOException {
        ASN1String.a(outputStream, string, n2, 128);
    }

    private static void a(OutputStream outputStream, String string, int n2, int n3) throws IOException {
        outputStream.write(n3 + n2);
        if (n2 == 12) {
            byte[] byArray = Utils.toUTF8(string);
            ASN1Utils.outputLengthBytes(outputStream, byArray.length);
            outputStream.write(byArray);
        } else if (n2 == 30) {
            ASN1Utils.outputLengthBytes(outputStream, 2 * string.length());
            ASN1String.a(outputStream, string);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, string.length());
            ASN1String.c(outputStream, string);
        }
    }

    private static void a(OutputStream outputStream, String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            outputStream.write((byte)(c2 >> 8));
            outputStream.write((byte)c2);
        }
    }

    private static void b(OutputStream outputStream, String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            outputStream.write((byte)(c2 >> 24));
            outputStream.write((byte)(c2 >> 16));
            outputStream.write((byte)(c2 >> 8));
            outputStream.write((byte)c2);
        }
    }

    private static void c(OutputStream outputStream, String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            outputStream.write((byte)string.charAt(i2));
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

