/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class Attribute
implements ASN1Object,
Externalizable {
    private ASN1ObjectID type;
    private ArrayList<ASN1Object> values;
    private ASN1Sequence seq = null;

    public Attribute() {
    }

    public Attribute(ASN1ObjectID type) {
        this.type = type;
        this.values = new ArrayList();
    }

    public Attribute(ASN1ObjectID type, ASN1Object value) {
        this(type);
        this.addValue(value);
    }

    public Attribute(ASN1ObjectID type, Vector<? extends ASN1Object> values) {
        this(type);
        this.setValues(values);
    }

    public Attribute(ASN1ObjectID type, List<? extends ASN1Object> values) {
        this(type);
        this.setValues(values);
    }

    public Attribute(InputStream is) throws IOException {
        this.input(is);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public void addValue(ASN1Object value) {
        this.values.add(value);
        this.reset();
    }

    public void setValues(Vector<? extends ASN1Object> values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.clear();
        this.reset();
        int size = values.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.values.add(values.get(i2));
        }
    }

    public void setValues(List<? extends ASN1Object> values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.clear();
        this.reset();
        int size = values.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.values.add(values.get(i2));
        }
    }

    @Deprecated
    public Enumeration<ASN1Object> values() {
        return this.values == null ? null : new VectorOverArrayList<ASN1Object>(this.values).elements();
    }

    @Deprecated
    public Vector<ASN1Object> getValues() {
        return this.values == null ? null : new VectorOverArrayList<ASN1Object>(this.values);
    }

    public ArrayList<ASN1Object> getValuesAsList() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String s2 = this.type + " : {";
        Iterator<ASN1Object> i2 = this.values.iterator();
        while (i2.hasNext()) {
            s2 = s2 + " " + i2.next();
            if (!i2.hasNext()) continue;
            s2 = s2 + ",";
        }
        s2 = s2 + " }";
        return s2;
    }

    @Override
    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.type = new ASN1ObjectID(seq);
        this.values = new ArrayList();
        ASN1SetInputStream set = new ASN1SetInputStream(seq);
        do {
            this.values.add(ASN1Utils.inputASN1Object(set));
        } while (seq.hasMoreData());
        set.terminate();
        seq.terminate();
        this.reset();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            s2.addElement(this.type);
            s2.addElement(new ASN1Set(this.values));
            this.seq = s2;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

