/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeSet
implements ASN1Object,
Cloneable,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, Attribute> attributes;
    private ASN1Set contents;

    public AttributeSet() {
        this.attributes = new LinkedHashMap();
    }

    public AttributeSet(InputStream is) throws IOException {
        this.input(is);
    }

    public Attribute addAttribute(Attribute attr) {
        this.update();
        return this.attributes.put(attr.getType(), attr);
    }

    public Attribute addAttribute(ASN1ObjectID type, ASN1Object value) {
        return this.addAttribute(new Attribute(type, value));
    }

    public Attribute addAttribute(ASN1ObjectID type, Vector<? extends ASN1Object> values) {
        return this.addAttribute(new Attribute(type, values));
    }

    public Attribute addAttribute(ASN1ObjectID type, List<? extends ASN1Object> values) {
        return this.addAttribute(new Attribute(type, values));
    }

    public Attribute getAttribute(ASN1ObjectID type) {
        if (this.hasAttribute(type)) {
            return this.attributes.get(type);
        }
        return null;
    }

    public void addAttributeValue(ASN1ObjectID type, ASN1Object value) {
        Attribute a2 = this.getAttribute(type);
        if (a2 != null) {
            a2.addValue(value);
        } else {
            this.addAttribute(type, value);
        }
    }

    @Deprecated
    public Vector<ASN1Object> getAttributeValues(ASN1ObjectID type) {
        Attribute a2 = this.getAttribute(type);
        return a2 != null ? a2.getValues() : null;
    }

    public ArrayList<ASN1Object> getAttributeValuesAsList(ASN1ObjectID type) {
        Attribute a2 = this.getAttribute(type);
        return a2 != null ? a2.getValuesAsList() : null;
    }

    public Map<ASN1ObjectID, Attribute> getAttributesAsMap() {
        return this.attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID type) {
        return this.attributes.containsKey(type);
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> types() {
        return this.attributes == null ? null : new Vector<ASN1ObjectID>(this.attributes.keySet()).elements();
    }

    public Object clone() {
        AttributeSet a2 = new AttributeSet();
        a2.attributes = new LinkedHashMap<ASN1ObjectID, Attribute>(this.attributes);
        return a2;
    }

    public String toString() {
        String s2 = "{";
        Iterator<Attribute> i2 = this.attributes.values().iterator();
        while (i2.hasNext()) {
            s2 = s2 + " " + i2.next();
            if (!i2.hasNext()) continue;
            s2 = s2 + ",";
        }
        s2 = s2 + " }";
        return s2;
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.attributes = new LinkedHashMap();
        ASN1SetInputStream sis = new ASN1SetInputStream(is);
        while (sis.hasMoreData()) {
            Attribute attr = new Attribute(sis);
            this.attributes.put(attr.getType(), attr);
        }
        sis.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Set().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private void update() {
        this.contents = null;
    }

    public ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set s2 = new ASN1Set();
            for (Attribute att : this.attributes.values()) {
                s2.addElement(att);
            }
            this.contents = s2;
        }
        return this.contents;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

