/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValue
implements ASN1Object,
Externalizable {
    private ASN1ObjectID type = null;
    private ASN1Object value = null;
    private ASN1Sequence contents;

    public AttributeTypeAndValue() {
    }

    public AttributeTypeAndValue(ASN1ObjectID type, ASN1Object value) {
        this.type = type;
        this.value = value;
    }

    public AttributeTypeAndValue(InputStream is) throws IOException {
        this.input(is);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public void setValue(ASN1Object value) {
        this.value = value;
        this.update();
    }

    @Override
    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.type = new ASN1ObjectID(seq);
        this.value = ASN1Utils.inputASN1Object(seq);
        seq.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            s2.addElement(this.type);
            s2.addElement(this.value);
            this.contents = s2;
        }
        return this.contents;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

