/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AttributeTypeAndValueList
implements ASN1Object,
Cloneable,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> attrMap = new LinkedHashMap();
    private transient ASN1Sequence contents;

    public AttributeTypeAndValueList() {
    }

    public AttributeTypeAndValueList(InputStream is) throws IOException {
        this.input(is);
    }

    public AttributeTypeAndValue addAttribute(AttributeTypeAndValue attr) {
        AttributeTypeAndValue a2 = this.attrMap.put(attr.getType(), attr);
        this.update();
        return a2;
    }

    public AttributeTypeAndValue addAttribute(ASN1ObjectID type, ASN1Object value) {
        return this.addAttribute(new AttributeTypeAndValue(type, value));
    }

    public AttributeTypeAndValue getAttribute(ASN1ObjectID type) {
        if (this.hasAttribute(type)) {
            return this.attrMap.get(type);
        }
        return null;
    }

    public ASN1Object getAttributeValue(ASN1ObjectID type) {
        AttributeTypeAndValue a2 = this.getAttribute(type);
        return a2 != null ? a2.getValue() : null;
    }

    public boolean isEmpty() {
        return this.attrMap.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID type) {
        return this.attrMap.containsKey(type);
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> types() {
        return this.attrMap == null ? null : new Vector<ASN1ObjectID>(this.attrMap.keySet()).elements();
    }

    public Object clone() {
        try {
            AttributeTypeAndValueList a2 = (AttributeTypeAndValueList)super.clone();
            a2.attrMap = this.attrMap == null ? null : new LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue>(this.attrMap);
            return a2;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("{ ");
        for (AttributeTypeAndValue att : this.attrMap.values()) {
            s2.append(att);
            s2.append(", ");
        }
        if (s2.length() >= 2) {
            s2.setLength(s2.length() - 2);
        }
        s2.append(" }");
        return s2.toString();
    }

    @Deprecated
    public Vector<AttributeTypeAndValue> elements() {
        return this.attrMap == null ? null : new Vector<AttributeTypeAndValue>(this.attrMap.values());
    }

    public ArrayList<AttributeTypeAndValue> elementsAsList() {
        return this.attrMap == null ? null : new ArrayList<AttributeTypeAndValue>(this.attrMap.values());
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> elementsAsMap() {
        return this.attrMap;
    }

    public int size() {
        return this.attrMap.size();
    }

    public AttributeTypeAndValue elementAt(int n2) {
        ArrayList<AttributeTypeAndValue> l2 = new ArrayList<AttributeTypeAndValue>(this.attrMap.values());
        return l2.get(n2);
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.attrMap.clear();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            AttributeTypeAndValue attr = new AttributeTypeAndValue(sis);
            this.attrMap.put(attr.getType(), attr);
        }
        sis.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    ASN1Sequence toASN1() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.attrMap.values());
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

