/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class AuthorityInfoAccess
implements ASN1Object,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, ArrayList<GeneralName>> access = new LinkedHashMap();
    private ASN1Sequence contents = null;

    public AuthorityInfoAccess() {
    }

    public AuthorityInfoAccess(InputStream is) throws IOException {
        this.input(is);
    }

    public void addAccessDescription(ASN1ObjectID method, GeneralName location) {
        ArrayList<GeneralName> v2 = this.access.get(method);
        if (v2 == null) {
            v2 = new ArrayList();
        }
        v2.add(location);
        this.access.put(method, v2);
        this.reset();
    }

    @Deprecated
    public Enumeration<ASN1ObjectID> accessMethods() {
        return this.access == null ? null : new Vector<ASN1ObjectID>(this.access.keySet()).elements();
    }

    public Vector<GeneralName> getAccessDescriptions(ASN1ObjectID method) {
        ArrayList<GeneralName> v2 = this.access.get(method);
        if (v2 != null && v2.size() > 0) {
            return new VectorOverArrayList<GeneralName>(v2);
        }
        return null;
    }

    public ArrayList<GeneralName> getAccessDescriptionsAsList(ASN1ObjectID method) {
        ArrayList<GeneralName> v2 = this.access.get(method);
        if (v2 != null && v2.size() > 0) {
            return v2;
        }
        return null;
    }

    public boolean hasAccessMethod(ASN1ObjectID method) {
        return this.getAccessDescriptionsAsList(method) != null;
    }

    public int methodCount() {
        return this.access.size();
    }

    public String toString() {
        String s2 = "AuthorityAccessInfo {";
        for (ASN1ObjectID m4 : this.access.keySet()) {
            ArrayList<GeneralName> v2 = this.access.get(m4);
            if (v2 == null) continue;
            for (GeneralName loc : v2) {
                s2 = s2 + " {" + m4.toStringCompact() + "," + loc + "}";
            }
        }
        s2 = s2 + " }";
        return s2;
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.reset();
        this.access = new LinkedHashMap();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(sis);
            ASN1ObjectID m4 = new ASN1ObjectID(seq);
            GeneralName loc = new GeneralName(seq);
            this.addAccessDescription(m4, loc);
            seq.terminate();
        }
        sis.terminate();
        if (this.access.size() == 0) {
            throw new ASN1FormatException("Sequence must contain at least 1 access description");
        }
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            for (ASN1ObjectID m4 : this.access.keySet()) {
                ArrayList<GeneralName> v2 = this.access.get(m4);
                if (v2 == null) continue;
                for (GeneralName loc : v2) {
                    ASN1Sequence dsc = new ASN1Sequence();
                    dsc.addElement(m4);
                    dsc.addElement(loc);
                    seq.addElement(dsc);
                }
            }
            this.contents = seq;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

