/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLReason
implements ASN1Object,
Externalizable {
    public static final CRLReason UNSPECIFIED = new CRLReason(0);
    public static final CRLReason KEY_COMPROMISE = new CRLReason(1);
    public static final CRLReason CA_COMPROMISE = new CRLReason(2);
    public static final CRLReason AFFILIATION_CHANGE = new CRLReason(3);
    public static final CRLReason SUPERSEDED = new CRLReason(4);
    public static final CRLReason CESSATION_OF_OPERATION = new CRLReason(5);
    public static final CRLReason CERTIFICATE_HOLD = new CRLReason(6);
    private static final CRLReason UNUSED = new CRLReason(7);
    public static final CRLReason REMOVE_FROM_CRL = new CRLReason(8);
    public static final CRLReason[] LIST = new CRLReason[]{UNSPECIFIED, KEY_COMPROMISE, CA_COMPROMISE, AFFILIATION_CHANGE, SUPERSEDED, CESSATION_OF_OPERATION, CERTIFICATE_HOLD, UNUSED, REMOVE_FROM_CRL};
    private int value;

    private CRLReason(int value) {
        this.value = value;
    }

    public CRLReason() {
    }

    public CRLReason(InputStream is) throws IOException {
        this.input(is);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == UNSPECIFIED.getValue()) {
            return "UNSPECIFIED";
        }
        if (this.value == KEY_COMPROMISE.getValue()) {
            return "KEY COMPROMISE";
        }
        if (this.value == CA_COMPROMISE.getValue()) {
            return "CA COMPROMISE";
        }
        if (this.value == AFFILIATION_CHANGE.getValue()) {
            return "AFFILIATION CHANGE";
        }
        if (this.value == SUPERSEDED.getValue()) {
            return "SUPERSEDED";
        }
        if (this.value == CESSATION_OF_OPERATION.getValue()) {
            return "CESSATION OF OPERATION";
        }
        if (this.value == CERTIFICATE_HOLD.getValue()) {
            return "CERTIFICATE HOLD";
        }
        if (this.value == REMOVE_FROM_CRL.getValue()) {
            return "REMOVE FROM CRL";
        }
        return null;
    }

    @Override
    public void input(InputStream is) throws IOException {
        try {
            ASN1GenericPrimitive valuePrim = new ASN1GenericPrimitive(is);
            ASN1Integer valueInt = (ASN1Integer)valuePrim.withTag(2);
            this.value = valueInt.intValue();
            if (this.value < 0 || this.value > 8) {
                throw new ASN1FormatException("Unrecognized crl reason value");
            }
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    @Override
    public void output(OutputStream os) throws IOException {
        new ASN1GenericPrimitive(new ASN1Integer(this.value), 10, 0).output(os);
    }

    @Override
    public int length() {
        return new ASN1GenericPrimitive(new ASN1Integer(this.value), 10, 0).length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

