/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12CRLBag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SafeContentsBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public abstract class PKCS12Bag
implements ASN1Object,
Externalizable {
    String friendlyName;
    byte[] localKeyID;

    protected PKCS12Bag() {
    }

    public static PKCS12Bag inputBag(PKCS12Safe parent, InputStream is) throws IOException {
        return PKCS12Bag.inputBag(parent, new ASN1Sequence(is));
    }

    static PKCS12Bag inputBag(PKCS12Safe parent, ASN1Sequence s2) throws IOException {
        try {
            ASN1ObjectID bt = (ASN1ObjectID)s2.elementAt(0);
            PKCS12Bag bag = null;
            if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1))) {
                bag = new PKCS12KeyBag(parent, s2);
            } else if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2))) {
                bag = new PKCS12ShroudedKeyBag(parent, s2);
            } else if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 3))) {
                bag = new PKCS12CertBag(parent, s2);
            } else if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4))) {
                bag = new PKCS12CRLBag(parent, s2);
            } else if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 5))) {
                bag = new PKCS12SecretBag(parent, s2);
            } else if (bt.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6))) {
                bag = new PKCS12SafeContentsBag(parent, s2);
            } else {
                throw new IOException("Unknown PKCS#12 bag type: " + bt);
            }
            if (s2.size() > 2) {
                ASN1Set ba = (ASN1Set)s2.elementAt(2);
                ArrayList<ASN1Object> vec = ba.elementsAsList();
                int size = vec.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ASN1Set v2;
                    ASN1Sequence a2 = (ASN1Sequence)vec.get(i2);
                    ASN1ObjectID at = (ASN1ObjectID)a2.elementAt(0);
                    if (at.equals(ASN1Utils.pkcsID, 9, 20)) {
                        v2 = (ASN1Set)a2.elementAt(1);
                        String fn = ((ASN1String)v2.elementAt(0)).getValue();
                        bag.setFriendlyName(fn);
                        continue;
                    }
                    if (!at.equals(ASN1Utils.pkcsID, 9, 21)) continue;
                    v2 = (ASN1Set)a2.elementAt(1);
                    byte[] id = ((ASN1OctetString)v2.elementAt(0)).getValue();
                    bag.setLocalKeyID(id);
                }
            }
            return bag;
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    abstract void reset();

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        this.reset();
    }

    public byte[] getLocalKeyID() {
        return this.localKeyID;
    }

    public void setLocalKeyID(byte[] localKeyID) {
        this.localKeyID = localKeyID;
        this.reset();
    }

    public ASN1Set outputAttrsASN1() {
        ASN1Set as;
        ASN1Sequence a2;
        ASN1Set ba = new ASN1Set();
        if (this.friendlyName != null) {
            a2 = new ASN1Sequence();
            a2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 20));
            as = new ASN1Set();
            as.addElement(new ASN1String(this.friendlyName, 30));
            a2.addElement(as);
            ba.addElement(a2);
        }
        if (this.localKeyID != null) {
            a2 = new ASN1Sequence();
            a2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 21));
            as = new ASN1Set();
            as.addElement(new ASN1OctetString(this.localKeyID));
            a2.addElement(as);
            ba.addElement(a2);
        }
        if (ba.elementsAsList().size() > 0) {
            return ba;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

