/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12KeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private PrivateKey key;
    private ASN1Sequence contents;

    public PKCS12KeyBag() {
    }

    public PKCS12KeyBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12KeyBag(PKCS12Safe parent, PrivateKey key) {
        this(parent);
        this.key = key;
    }

    public PKCS12KeyBag(PKCS12Safe parent, java.security.PrivateKey key) {
        this(parent);
        this.key = CryptoUtils.fromJCEPrivateKey(key);
    }

    public PKCS12KeyBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12KeyBag(PKCS12Safe parent, ASN1Sequence s2) throws IOException {
        this(parent);
        this.input(s2);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s2) throws IOException {
        this.reset();
        ASN1GenericConstructed bc = (ASN1GenericConstructed)s2.elementAt(1);
        ASN1Sequence pki = (ASN1Sequence)bc.elementAt(0);
        this.key = CryptoUtils.inputPrivateKey(Utils.toStream(pki));
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            s2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1));
            s2.addElement(new ASN1GenericConstructed(this.key, 0));
            ASN1Set attr = this.outputAttrsASN1();
            if (attr != null) {
                s2.addElement(attr);
            }
            this.contents = s2;
        }
        return this.contents;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public ASN1Sequence getPrivateKeyInfo() {
        try {
            return new ASN1Sequence(new UnsyncByteArrayInputStream(this.key.getEncoded()));
        }
        catch (IOException ex) {
            throw new StreamableInputException(ex.toString());
        }
    }

    public void setPrivateKey(PrivateKey key) {
        this.key = key;
        this.reset();
    }

    public void setPrivateKey(java.security.PrivateKey key) {
        this.key = CryptoUtils.fromJCEPrivateKey(key);
        this.reset();
    }

    public String toString() {
        String s2 = "";
        if (this.friendlyName != null) {
            s2 = s2 + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            s2 = s2 + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return s2 + this.key.toString();
    }
}

