/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private ArrayList<PKCS12Bag> bags;
    private ASN1Sequence contents;

    public PKCS12SafeContentsBag() {
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, Vector<PKCS12Bag> bags) {
        this(parent, (List<PKCS12Bag>)bags);
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, List<PKCS12Bag> bags) {
        this(parent);
        this.bags = bags == null ? null : new ArrayList<PKCS12Bag>(bags);
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12SafeContentsBag(PKCS12Safe parent, ASN1Sequence s2) throws IOException {
        this(parent);
        this.input(s2);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s2) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed bc = (ASN1GenericConstructed)s2.elementAt(1);
            ASN1Sequence cb = (ASN1Sequence)bc.elementAt(0);
            this.bags = new ArrayList();
            int n2 = cb.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bags.add(PKCS12Bag.inputBag(null, (ASN1Sequence)cb.elementAt(i2)));
            }
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s2 = new ASN1Sequence();
        s2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6));
        ASN1Sequence cb = new ASN1Sequence((List<? extends ASN1Object>)this.bags);
        s2.addElement(new ASN1GenericConstructed(cb, 0));
        ASN1Set attr = this.outputAttrsASN1();
        if (attr != null) {
            s2.addElement(attr);
        }
        this.contents = s2;
        return s2;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public Vector<PKCS12Bag> getBags() {
        return this.bags == null ? null : new VectorOverArrayList<PKCS12Bag>(this.bags);
    }

    public ArrayList<PKCS12Bag> getBagsAsList() {
        return this.bags;
    }

    public void setBags(Vector<PKCS12Bag> bags) {
        this.setBags((List<PKCS12Bag>)bags);
    }

    public void setBags(List<PKCS12Bag> bags) {
        this.bags = bags == null ? null : (bags instanceof ArrayList ? (ArrayList<Object>)bags : new ArrayList<PKCS12Bag>(bags));
        this.reset();
    }

    public void addBag(PKCS12Bag b2) {
        if (this.bags == null) {
            this.bags = new ArrayList();
        }
        this.bags.add(b2);
        this.reset();
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        if (this.friendlyName != null) {
            s2.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            s2.append("localKeyID = " + Utils.toHexString(this.localKeyID) + ", ");
        }
        s2.append("bags = {");
        int n2 = this.bags.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            s2.append(this.bags.get(i2).toString());
            if (i2 == n2 - 1) continue;
            s2.append(", ");
        }
        s2.append('}');
        return s2.toString();
    }
}

