/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509PolicyInformation
implements ASN1Object,
Externalizable {
    private ASN1ObjectID id;
    private ArrayList<ASN1Object> policyQualifiers;
    private ASN1Sequence contents;

    public X509PolicyInformation() {
    }

    public X509PolicyInformation(ASN1ObjectID id) {
        this.id = id;
    }

    public X509PolicyInformation(ASN1ObjectID id, Vector<ASN1Object> policyQualifiers) {
        this(id, (List<ASN1Object>)policyQualifiers);
    }

    public X509PolicyInformation(ASN1ObjectID id, List<ASN1Object> policyQualifiers) {
        this.id = id;
        this.policyQualifiers = policyQualifiers == null ? null : (policyQualifiers instanceof ArrayList ? (ArrayList<Object>)policyQualifiers : new ArrayList<ASN1Object>(policyQualifiers));
    }

    public X509PolicyInformation(InputStream is) throws IOException {
        this.input(is);
    }

    public void addPolicyQualifier(ASN1ObjectID qualifierID, ASN1Object qualifier) {
        if (this.id.equals(PKIX.anyPolicy) && !qualifierID.equals(PKIX.id_qt_cps) && !qualifierID.equals(PKIX.id_qt_unotice)) {
            throw new IllegalArgumentException("Illegal qualifier type for anyPolicy policy");
        }
        ASN1Sequence pq = new ASN1Sequence();
        pq.addElement(qualifierID);
        pq.addElement(qualifier);
        if (this.policyQualifiers == null) {
            this.policyQualifiers = new ArrayList();
        }
        this.policyQualifiers.add(pq);
        this.reset();
    }

    public void addCPSPointer(String uri) {
        this.addPolicyQualifier(PKIX.id_qt_cps, new ASN1String(uri, 22));
    }

    public void addUserNotice(String organization, int[] noticeNumbers, String explicitText) {
        if (organization == null ^ noticeNumbers == null) {
            throw new IllegalArgumentException("Both or neither of organization and noticeNumbers must be present");
        }
        if (organization == null && explicitText == null) {
            throw new IllegalArgumentException("No user notice content given");
        }
        ASN1Sequence userNotice = new ASN1Sequence();
        if (organization != null) {
            ASN1Sequence noticeRef = new ASN1Sequence();
            noticeRef.addElement(new ASN1String(organization));
            ASN1Sequence noticeNos = new ASN1Sequence();
            int len = noticeNumbers.length;
            for (int i2 = 0; i2 < len; ++i2) {
                noticeNos.addElement(new ASN1Integer(noticeNumbers[i2]));
            }
            noticeRef.addElement(noticeNos);
            userNotice.addElement(noticeRef);
        }
        if (explicitText != null) {
            userNotice.addElement(new ASN1String(explicitText));
        }
        this.addPolicyQualifier(PKIX.id_qt_unotice, userNotice);
    }

    public ASN1ObjectID getID() {
        return this.id;
    }

    @Deprecated
    public Vector<ASN1Object> getPolicyQualifiers() {
        return this.policyQualifiers == null ? null : new Vector<ASN1Object>(this.policyQualifiers);
    }

    public ArrayList<ASN1Object> getPolicyQualifiersAsList() {
        return this.policyQualifiers;
    }

    @Override
    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.id = new ASN1ObjectID(sis);
        this.policyQualifiers = sis.hasMoreData() ? new ASN1Sequence(sis).elementsAsList() : null;
        sis.terminate();
        this.reset();
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            s2.addElement(this.id);
            if (this.policyQualifiers != null) {
                s2.addElement(new ASN1Sequence((List<? extends ASN1Object>)this.policyQualifiers));
            }
            this.contents = s2;
        }
        return this.contents;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    private void reset() {
        this.contents = null;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("id = " + this.id);
        if (this.policyQualifiers != null) {
            s2.append(", policyQualifiers = " + Utils.toHexString(Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.policyQualifiers))));
        }
        return s2.toString();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

