/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPoint;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLDistributionPoints;
    private ArrayList<CRLDistPoint> distPoint = new ArrayList();

    public CRLDistPointExtension() {
        super(TYPE);
    }

    public CRLDistPointExtension(CRLDistPoint crlDistPoint) {
        this(crlDistPoint, false);
    }

    public CRLDistPointExtension(CRLDistPoint crlDistPoint, boolean critical) {
        super(TYPE, critical);
        this.addCRLDistPoint(crlDistPoint);
    }

    public CRLDistPointExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addCRLDistPoint(CRLDistPoint crlDistPoint) {
        this.distPoint.add(crlDistPoint);
        this.setValue(this.toByteArray());
    }

    public Vector<CRLDistPoint> getCRLDistPoints() {
        ArrayList<CRLDistPoint> l2 = this.getCRLDistPointsAsList();
        return l2 == null ? null : new VectorOverArrayList<CRLDistPoint>(l2);
    }

    public ArrayList<CRLDistPoint> getCRLDistPointsAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPoint;
    }

    private byte[] toByteArray() {
        byte[] b2 = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.distPoint));
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            if (this.distPoint == null) {
                this.distPoint = new ArrayList();
            } else {
                this.distPoint.clear();
            }
            while (sis.hasMoreData()) {
                this.distPoint.add(new CRLDistPoint(sis));
            }
            sis.terminate();
            if (this.distPoint.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("crlDistPointExtension { oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCRLDistPointsAsList() != null) {
            s2.append("CRLDistributionPoints = { ");
            boolean mid = false;
            int size = this.getCRLDistPointsAsList().size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.getCRLDistPointsAsList().get(i2).toString());
                mid = true;
            }
            s2.append(" }");
        }
        s2.append("] }");
        return s2.toString();
    }
}

