/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class ExtKeyUsageExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_extKeyUsage;
    private ArrayList<ASN1ObjectID> keyPurposes = new ArrayList();

    public ExtKeyUsageExtension() {
        super(TYPE);
    }

    public ExtKeyUsageExtension(ASN1ObjectID keyPurpose) {
        this(keyPurpose, false);
    }

    public ExtKeyUsageExtension(ASN1ObjectID keyPurpose, boolean critical) {
        super(TYPE, critical);
        this.keyPurposes.add(keyPurpose);
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(Vector<ASN1ObjectID> keyPurposes, boolean critical) {
        this((List<ASN1ObjectID>)keyPurposes, critical);
    }

    public ExtKeyUsageExtension(List<ASN1ObjectID> keyPurposes, boolean critical) {
        super(TYPE, critical);
        this.keyPurposes = keyPurposes == null ? null : (keyPurposes instanceof ArrayList ? (ArrayList<Object>)keyPurposes : new ArrayList<ASN1ObjectID>(keyPurposes));
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addKeyPurpose(ASN1ObjectID keyPurpose) {
        this.keyPurposes.add(keyPurpose);
        this.setValue(this.toByteArray());
    }

    public Enumeration<ASN1ObjectID> getKeyPurposes() {
        ArrayList<ASN1ObjectID> l2 = this.getKeyPurposesAsList();
        return l2 == null ? null : new VectorOverArrayList<ASN1ObjectID>(l2).elements();
    }

    public ArrayList<ASN1ObjectID> getKeyPurposesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes;
    }

    public boolean hasKeyPurpose(ASN1ObjectID keyPurpose) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes.contains(keyPurpose);
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        int size = this.keyPurposes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            seq.addElement(this.keyPurposes.get(i2));
        }
        byte[] b2 = Utils.toBytes(seq);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            this.keyPurposes = new ArrayList();
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(this.getValue()));
            while (sis.hasMoreData()) {
                this.keyPurposes.add(new ASN1ObjectID(sis));
            }
            sis.terminate();
            if (this.keyPurposes.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("extKeyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.keyPurposes != null) {
            s2.append("OIDs of key usage = {");
            boolean mid = false;
            int size = this.keyPurposes.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.keyPurposes.get(i2).toString());
                mid = true;
            }
            s2.append("}");
        }
        s2.append("]}");
        return s2.toString();
    }
}

