/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class NetscapeCertTypeExtension
extends X509Extension {
    public static final int SSL_CLIENT = 0;
    public static final int SSL_SERVER = 1;
    public static final int SMIME = 2;
    public static final int OBJECT_SIGNING = 3;
    public static final int SSL_CA = 5;
    public static final int SMIME_CA = 6;
    public static final int OBJECT_SIGNING_CA = 7;
    private static final int RESERVED = 4;
    private static final int[] LIST = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String[] description = new String[]{"SSL CLIENT", "SSL SERVER", "SMIME", "OBJECT SIGNING", "RESERVED", "SSL_CA", "SMIME CA", "OBJECT SIGNING_CA"};
    private static final ASN1ObjectID TYPE = X509Extension.id_netscape_ce_type;
    private boolean[] certUsage = new boolean[LIST.length];

    public NetscapeCertTypeExtension() {
        super(TYPE);
    }

    public NetscapeCertTypeExtension(boolean critical) {
        super(TYPE, critical);
        this.setValue(this.toByteArray());
    }

    public NetscapeCertTypeExtension(int[] flags, boolean critical) {
        super(TYPE, critical);
        this.setUsageFlags(flags);
    }

    public NetscapeCertTypeExtension(InputStream is) throws IOException {
        super(is);
    }

    public boolean hasUsageFlag(int flag) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certUsage != null && flag < this.certUsage.length ? this.certUsage[flag] : false;
    }

    public void setUsageFlag(int flag) {
        this.doSetUsageFlag(flag);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] flags) {
        int len = flags.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.doSetUsageFlag(flags[i2]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearUsageFlag(int flag) {
        if (this.certUsage != null && flag < this.certUsage.length) {
            this.certUsage[flag] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllUsageFlags() {
        if (this.certUsage != null) {
            int len = this.certUsage.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.certUsage[i2] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetUsageFlag(int flag) {
        if (this.certUsage == null || this.certUsage.length < LIST.length) {
            boolean[] newUsages = new boolean[LIST.length];
            if (this.certUsage != null) {
                System.arraycopy(this.certUsage, 0, newUsages, 0, this.certUsage.length);
            }
            this.certUsage = newUsages;
        }
        this.certUsage[flag] = true;
    }

    private byte[] toByteArray() {
        ASN1BitString bs = new ASN1BitString(this.certUsage.length);
        for (int i2 = 0; i2 < this.certUsage.length; ++i2) {
            if (!this.certUsage[i2]) continue;
            bs.setBit(i2);
        }
        byte[] b2 = Utils.toBytes(bs);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            int i2;
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString b2 = new ASN1BitString(is);
            this.certUsage = new boolean[b2.bitLength()];
            try {
                for (i2 = 0; i2 < this.certUsage.length; ++i2) {
                    this.certUsage[i2] = b2.testBit(i2);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new ASN1FormatException("Unknown cert usage flag: " + i2);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("netscapeCertTypeExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean mid = false;
        for (int i2 = 0; i2 < LIST.length; ++i2) {
            if (!this.hasUsageFlag(i2)) continue;
            if (mid) {
                s2.append(", ");
            }
            s2.append(description[i2]);
            mid = true;
        }
        s2.append("]}");
        return s2.toString();
    }
}

