/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.DSAPublicKey;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class DSA
extends Signature {
    public static final ASN1ObjectID dsaKeyOID = AlgID.dsa.getOID();
    public static final ASN1ObjectID dsaKeyOldOID = AlgID.dsaOld.getOID();
    public static final ASN1ObjectID dsaSigOID = AlgID.dsaWithSHA1.getOID();
    public static final ASN1ObjectID dsaSigOldOID = AlgID.dsaWithSHA.getOID();
    public static final ASN1ObjectID dsaSigOldOID2 = AlgID.dsaWithSHA1Old.getOID();
    private ASN1ObjectID c = dsaSigOID;
    private DSAPublicKey d;
    private DSAPrivateKey e;
    private RandomBitsSource f;
    private MessageDigest g;
    private byte[] h;

    public DSA() {
    }

    public DSA(DSAPublicKey dSAPublicKey) {
        this();
        oracle.security.crypto.core.a.a(dSAPublicKey, 4096);
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.d = dSAPublicKey;
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey) {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault());
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource) {
        this();
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.a.a(dSAPublicKey, 4096);
        oracle.security.crypto.core.a.a(dSAPrivateKey, 4096);
        this.d = dSAPublicKey;
        this.e = dSAPrivateKey;
        this.f = randomBitsSource;
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, randomBitsSource);
        this.setDocument(byArray);
        this.sign();
    }

    public DSA(DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public DSA(DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(null, dSAPrivateKey, randomBitsSource, byArray);
    }

    public DSA(DSAPublicKey dSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(dSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.c = algorithmIdentifier.getOID();
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.c, false);
    }

    @Override
    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return AlgID.dsaWithSHA1;
    }

    @Override
    public String algName() {
        return "DSA";
    }

    @Override
    public void setHash(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.h = byArray;
        this.b = null;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException();
        }
        oracle.security.crypto.core.a.a(publicKey, 4096);
        this.d = (DSAPublicKey)publicKey;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        oracle.security.crypto.core.a.a(privateKey, 4096);
        this.e = (DSAPrivateKey)privateKey;
    }

    @Override
    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.f = randomBitsSource;
    }

    @Override
    public boolean verify() throws AuthenticationException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray;
            BigInt bigInt;
            BigInt bigInt2;
            BigInt bigInt3 = this.d.a();
            DSAParams dSAParams = this.d.getParams();
            BigInt bigInt4 = dSAParams.a();
            BigInt bigInt5 = dSAParams.b();
            BigInt bigInt6 = dSAParams.c();
            oracle.security.crypto.core.a.a(bigInt4.bitLength(), 4096);
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(this.getSigBytes()));
            if (aSN1Sequence.size() != 2) {
                throw new AuthenticationException("Invalid signature format");
            }
            try {
                bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
                bigInt = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            }
            catch (ClassCastException classCastException) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (bigInt2.signum() < 0 || bigInt2.compareTo(bigInt5) > 0 || bigInt.signum() < 0 || bigInt.compareTo(bigInt5) > 0) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (this.h != null) {
                byArray = this.h;
            } else {
                if (this.g == null) {
                    try {
                        this.g = MessageDigest.getInstance(AlgID.sha_1);
                    }
                    catch (AlgorithmIdentifierException algorithmIdentifierException) {
                        throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                    }
                }
                if (this.getDocument() != null) {
                    this.g.init();
                    this.g.update(this.getDocument());
                }
                this.g.computeCurrent();
                byArray = this.g.getDigestBits();
            }
            BigInt bigInt7 = new BigInt(1, byArray);
            BigInt bigInt8 = bigInt.modInverse(bigInt5);
            BigInt bigInt9 = bigInt8.multiply(bigInt7).mod(bigInt5);
            BigInt bigInt10 = bigInt8.multiply(bigInt2).mod(bigInt5);
            BigInt bigInt11 = bigInt6.modPow(bigInt9, bigInt4).multiply(bigInt3.modPow(bigInt10, bigInt4)).mod(bigInt4);
            return bigInt11.mod(bigInt5).equals(bigInt2);
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
    }

    @Override
    public byte[] sign() throws SignatureException {
        BigInt bigInt;
        byte[] byArray;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.f == null) {
            this.f = RandomBitsSource.getDefault();
        }
        BigInt bigInt2 = this.e.c();
        DSAParams dSAParams = this.e.getParams();
        BigInt bigInt3 = dSAParams.a();
        BigInt bigInt4 = dSAParams.b();
        BigInt bigInt5 = dSAParams.c();
        oracle.security.crypto.core.a.a(bigInt3.bitLength(), 4096);
        if (this.h != null) {
            byArray = this.h;
        } else {
            if (this.g == null) {
                try {
                    this.g = MessageDigest.getInstance(AlgID.sha_1);
                }
                catch (AlgorithmIdentifierException algorithmIdentifierException) {
                    throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                }
            }
            if (this.getDocument() != null) {
                this.g.init();
                this.g.update(this.getDocument());
            }
            this.g.computeCurrent();
            byArray = this.g.a();
        }
        BigInt bigInt6 = new BigInt(1, byArray);
        int n2 = bigInt4.bitLength();
        while ((bigInt = this.f.randomBigInt(n2)).compareTo(BigInt.ONE) <= 0 || bigInt.compareTo(bigInt4) >= 0) {
        }
        BigInt bigInt7 = bigInt.modInverse(bigInt4);
        BigInt bigInt8 = bigInt5.modPow(bigInt, bigInt3).mod(bigInt4);
        BigInt bigInt9 = bigInt6.add(bigInt2.multiply(bigInt8)).mod(bigInt4).multiply(bigInt7).mod(bigInt4);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(bigInt8));
        aSN1Sequence.addElement(new ASN1Integer(bigInt9));
        this.setSigBytes(Utils.toBytes(aSN1Sequence));
        return this.getSigBytes();
    }
}

