/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.DSAPublicKey;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.core.math.Prime;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public final class DSAKeyPairGenerator
extends KeyPairGenerator {
    private DSAParams e;
    private AlgorithmIdentifier f = AlgID.dsa;
    private boolean g;
    protected static final DSAParams a = new DSAParams(new BigInt("12492156315694258518438122119006323799237110162140490763848993256055871214032560900677394116414321425392480831123940478668629071213037930849067708987561797"), new BigInt("801990017674004996592495372795475144432167785027"), new BigInt("2416161294771127319901315666703790942713833681450164303616597296690475377189730893345413708325615307310225313979735602963720957950755258782529372026391641"), Utils.fromHexString("aeef7fdc2ec34351c33f81bb85365f0f5fab95ff"), 34, BigInt.valueOf(2L));
    protected static final DSAParams b = new DSAParams(new BigInt("847198100946155561710307399779508173184457128156664161164146219421882327915073475669013220667420258484908654810304407590381994918086595198517076267445552648272351841808065130519547223061029101550004978958642084687668586641485517199"), new BigInt("822710224377225222128937326700907925490005902807"), new BigInt("774809834959489591459661268156343047964339133423157824672710776212233910908008334483365011387676918733816159938484546866731411707418746020651507449962477749235816006996558751009410902691182747947857176879528177046533903302222963959"), Utils.fromHexString("ffeb77a7ffcf7fd721e755baae2f8b3ecdb71336"), 130, BigInt.valueOf(2L));
    protected static final DSAParams c = new DSAParams(new BigInt("161756768501353294066626183132608614763109713347781303307809494201788145786086766632565723776515877527063255282137713643496150680763718237323344135572062802611728216674705098439563128548289535101877916048620151565468004419332049256669008213336599980552248203559391936808645815662034554991029528611306511263023"), new BigInt("1079797971804353485335126622997120532804240961111"), new BigInt("6530309311322880764774476607659473863630893214684539533075034340133395178524950590072708632400423957022360602591219745803762207151326446958725779643269855471917579006976398481954391601082152120248406291574749383155233113276975161340818874285909301731513558916061705580890998449766759627672339082497014715890"), Utils.fromHexString("b5460f2173273a4280d748ae3b5794acfddbc631"), 130, BigInt.valueOf(2L));

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.equals(AlgID.dsa) || algorithmIdentifier.equals(AlgID.dsaOld)) {
            this.f = algorithmIdentifier;
            ASN1Object aSN1Object = algorithmIdentifier.getParameters();
            if (aSN1Object != null && aSN1Object.getClass() != ASN1Null.class) {
                this.e = (DSAParams)aSN1Object;
            }
        } else {
            throw new AlgorithmIdentifierException("Unknown DSA key algorithm identifier");
        }
    }

    @Override
    public void initialize(int n2, RandomBitsSource randomBitsSource) {
        this.initialize(DSAKeyPairGenerator.getParameters(n2, randomBitsSource), randomBitsSource);
    }

    public void initialize(DSAParams dSAParams, RandomBitsSource randomBitsSource) {
        oracle.security.crypto.core.a.a(dSAParams.getP().bitLength(), 4096);
        this.e = dSAParams;
        this.setRandomBitsSource(randomBitsSource);
        this.g = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInt bigInt;
        if (!this.g) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        BigInt bigInt2 = this.e.a();
        BigInt bigInt3 = this.e.b();
        BigInt bigInt4 = this.e.c();
        oracle.security.crypto.core.a.a(bigInt2.bitLength(), 4096);
        if (this.d == null) {
            this.d = RandomBitsSource.getDefault();
        }
        int n2 = bigInt3.bitLength();
        while ((bigInt = this.d.randomBigInt(n2)).compareTo(BigInt.ONE) <= 0 || bigInt.compareTo(bigInt3) >= 0) {
        }
        BigInt bigInt5 = bigInt4.modPow(bigInt, bigInt2);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInt5, this.e);
        dSAPublicKey.setKeyAlgOID(this.f.getOID());
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInt, this.e);
        dSAPrivateKey.setKeyAlgOID(this.f.getOID());
        FIPS_140_2.testKeyPair(dSAPublicKey, dSAPrivateKey);
        return new KeyPair(dSAPublicKey, dSAPrivateKey);
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    public static DSAParams getParameters(int n2, RandomBitsSource randomBitsSource) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (n2 == 512) {
            return a;
        }
        if (n2 == 768) {
            return b;
        }
        if (n2 == 1024) {
            return c;
        }
        return DSAKeyPairGenerator.generateParameters(n2, randomBitsSource);
    }

    public static DSAParams generateParameters(int n2, RandomBitsSource randomBitsSource) {
        return DSAKeyPairGenerator.generateParameters(n2, null, randomBitsSource);
    }

    public static DSAParams generateParameters(int n2, byte[] byArray, RandomBitsSource randomBitsSource) {
        int n3;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.a.a(n2, 4096);
        byte[] byArray2 = null;
        boolean bl = false;
        if (byArray != null && byArray.length >= 20) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = new byte[20];
            bl = true;
        }
        BigInt bigInt = null;
        BigInt bigInt2 = null;
        BigInt bigInt3 = null;
        byte[] byArray3 = new byte[byArray2.length];
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        while (true) {
            if (bl) {
                randomBitsSource.randomBytes(byArray2);
            } else {
                bl = true;
            }
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            bigInt2 = DSAKeyPairGenerator.a(byArray3, messageDigest);
            if (!Prime.isProbablePrime(bigInt2, 100, randomBitsSource)) continue;
            for (n3 = 0; !(n3 >= 4096 || (bigInt = DSAKeyPairGenerator.a(n2, bigInt2, byArray3, messageDigest)).compareTo(BigInt.ONE.shiftLeft(n2 - 1)) >= 0 && Prime.isProbablePrime(bigInt, 100, randomBitsSource)); ++n3) {
                bigInt = null;
            }
            if (bigInt != null) break;
        }
        BigInt bigInt4 = bigInt.subtract(BigInt.ONE).divide(bigInt2);
        BigInt bigInt5 = BigInt.TWO;
        while ((bigInt3 = bigInt5.modPow(bigInt4, bigInt)).compareTo(BigInt.ONE) == 0) {
            bigInt5 = bigInt5.add(BigInt.ONE);
        }
        return new DSAParams(bigInt, bigInt2, bigInt3, byArray2, n3, bigInt5);
    }

    static BigInt a(byte[] byArray, MessageDigest messageDigest) {
        int n2;
        byte[] byArray2 = new byte[20];
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.computeCurrent();
        System.arraycopy(messageDigest.a(), 0, byArray2, 0, 20);
        for (n2 = byArray.length - 1; n2 >= 0 && (byArray[n2] = (byte)((byArray[n2] & 0xFF) + 1)) == 0; --n2) {
        }
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.computeCurrent();
        for (n2 = 0; n2 < 20; ++n2) {
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ messageDigest.a()[n2]);
        }
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        byArray2[19] = (byte)(byArray2[19] | 1);
        return new BigInt(1, byArray2);
    }

    static BigInt a(int n2, BigInt bigInt, byte[] byArray, MessageDigest messageDigest) {
        int n3 = (n2 - 1) / 160;
        BigInt bigInt2 = BigInt.ONE.shiftLeft(n2 - 1);
        BigInt bigInt3 = bigInt2.subtract(BigInt.ONE);
        byte[] byArray2 = new byte[(n3 + 1) * 20];
        for (int i2 = byArray2.length - 20; i2 >= 0; i2 -= 20) {
            for (int i3 = byArray.length - 1; i3 >= 0 && (byArray[i3] = (byte)((byArray[i3] & 0xFF) + 1)) == 0; --i3) {
            }
            messageDigest.init();
            messageDigest.update(byArray);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.a(), 0, byArray2, i2, 20);
        }
        BigInt bigInt4 = new BigInt(1, byArray2).and(bigInt3).add(bigInt2);
        return bigInt4.subtract(bigInt4.mod(bigInt.shiftLeft(1))).add(BigInt.ONE);
    }
}

