/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest a;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.a = messageDigest;
    }

    @Override
    public synchronized int read() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.a.update((byte)n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n5 = 0; n5 < n3 && (n4 = this.read()) != -1; ++n5) {
            byArray[n2 + n5] = (byte)n4;
        }
        return n5 != 0 ? n5 : -1;
    }

    public byte[] computeCurrent() {
        this.a.computeCurrent();
        return this.a.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.a;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.a = messageDigest;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

