/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public abstract class DigestRandomBitsSource
extends RandomBitsSource {
    private byte[] a;
    private byte[] b = new byte[0];
    private long c;
    private int d;
    private MessageDigest e;
    private boolean f = false;
    private static final int g = 20;

    protected DigestRandomBitsSource() {
    }

    protected synchronized void a(AlgorithmIdentifier algorithmIdentifier) {
        try {
            this.e = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        this.a = new byte[this.e.blockSize()];
        this.f = false;
    }

    @Override
    public synchronized void seed(byte[] byArray) {
        this.e.init();
        this.e.update(this.a);
        this.e.update(byArray);
        this.e.computeCurrent();
        this.a = this.e.a();
        this.d = 0;
        this.b = new byte[0];
        this.f = true;
        this.a().initialize();
    }

    public synchronized void seed(Object object) {
        this.e.init();
        this.e.update(this.a);
        this.e.update(object.hashCode());
        this.e.update(object.toString());
        this.e.computeCurrent();
        this.a = this.e.a();
        this.d = 0;
        this.b = new byte[0];
        this.f = true;
        this.a().initialize();
    }

    @Override
    public synchronized void seed() {
        this.seed(EntropySource.getDefault());
    }

    @Override
    public synchronized void seed(EntropySource entropySource) {
        this.seed(entropySource.generateBytes(new byte[20]));
    }

    @Override
    public synchronized byte randomByte() {
        if (!this.f) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.d == this.b.length) {
            this.b = this.b();
            this.d = 0;
        }
        byte by = this.b[this.d++];
        this.a().testRandomByte(by);
        return by;
    }

    @Override
    public synchronized byte[] randomBytes(byte[] byArray) {
        int n2;
        if (!this.f) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        int n3 = byArray.length;
        System.arraycopy(this.b, this.d, byArray, 0, n2);
        this.d += n2;
        int n4 = n3;
        for (n2 = Math.min(this.b.length - this.d, n3); n2 < n4; n2 += this.b.length) {
            this.b = this.b();
            this.d = Math.min(this.b.length, n3 - n2);
            System.arraycopy(this.b, 0, byArray, n2, this.d);
        }
        this.a().testRandomBytes(byArray, 0, n3);
        return byArray;
    }

    @Override
    public synchronized void clear() {
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = 0;
            }
        }
        if (this.e != null) {
            this.e.init();
        }
        this.b = null;
        this.d = 0;
        this.c = 0;
        this.f = false;
    }

    private byte[] b() {
        this.e.init();
        this.e.update(this.a);
        this.e.update(this.c++);
        this.e.computeCurrent();
        return this.e.a();
    }
}

