/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public final class HMAC
extends MAC {
    private AlgorithmIdentifier b;
    private SymmetricKey c;
    private byte[] d;
    private byte[] e;
    private byte[] f;
    private int g;
    private int h;
    private MessageDigest i;
    private MessageDigest j;
    private MessageDigest.MDState k;
    private MessageDigest.MDState l;
    private byte[] m;
    private boolean n;

    public HMAC() {
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        this.c = symmetricKey;
        this.d = (byte[])symmetricKey.d().clone();
        this.g = 0;
        this.h = this.d.length;
        this.i = MessageDigest.getInstance(algorithmIdentifier);
        this.j = MessageDigest.getInstance(algorithmIdentifier);
        this.c();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n2, int n3) throws AlgorithmIdentifierException {
        this.d = (byte[])byArray.clone();
        this.g = n2;
        this.h = n3;
        this.i = MessageDigest.getInstance(algorithmIdentifier);
        this.j = MessageDigest.getInstance(algorithmIdentifier);
        this.c();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this(algorithmIdentifier, byArray, 0, byArray.length);
    }

    private HMAC(byte[] byArray, int n2, int n3) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.d = (byte[])byArray.clone();
        this.g = n2;
        this.h = n3;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.a.a(symmetricKey, 4096);
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.b = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.b = AlgID.sha1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA1.getOID())) {
            this.b = AlgID.sha1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA256.getOID())) {
            this.b = AlgID.sha_256;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA384.getOID())) {
            this.b = AlgID.sha_384;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA512.getOID())) {
            this.b = AlgID.sha_512;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.i = MessageDigest.getInstance(this.b);
        this.j = MessageDigest.getInstance(this.b);
        if (symmetricKey == null) {
            this.d = new byte[0];
            this.g = 0;
            this.h = 0;
        } else {
            this.d = (byte[])symmetricKey.d().clone();
            this.g = 0;
            this.h = this.d.length;
        }
        this.c = symmetricKey;
        this.c();
        this.a = algorithmIdentifier;
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.b = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.b = AlgID.sha1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA256.getOID())) {
            this.b = AlgID.sha_256;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA384.getOID())) {
            this.b = AlgID.sha_384;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacWithSHA512.getOID())) {
            this.b = AlgID.sha_512;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.i = MessageDigest.getInstance(this.b);
        this.j = MessageDigest.getInstance(this.b);
        if (this.d == null) {
            this.d = new byte[0];
            this.g = 0;
            this.h = 0;
        } else {
            this.c();
        }
        this.a = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setKey(byte[] byArray, int n2, int n3) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.d = (byte[])byArray.clone();
        this.g = n2;
        this.h = n3;
        this.c();
    }

    public void setKey(byte[] byArray) {
        this.setKey(byArray, 0, byArray.length);
    }

    @Override
    public void init() {
        this.i.a(this.k);
        this.j.a(this.l);
        this.n = false;
    }

    private void c() {
        byte[] byArray;
        int n2 = this.i.blockSize();
        int n3 = this.j.getDigestLength();
        if (this.h > n2) {
            this.i.init();
            this.i.update(this.d, this.g, this.h);
            this.i.computeCurrent();
            byArray = this.i.a();
            this.i.init();
        } else {
            byArray = new byte[this.h];
            System.arraycopy(this.d, this.g, byArray, 0, this.h);
        }
        this.m = new byte[n3];
        this.e = new byte[n2];
        this.f = new byte[n2];
        Utils.setArray(this.e, (byte)54);
        Utils.setArray(this.f, (byte)92);
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray.length) {
            int n6 = n4;
            this.e[n6] = (byte)(this.e[n6] ^ byArray[n5]);
            int n7 = n4++;
            this.f[n7] = (byte)(this.f[n7] ^ byArray[n5]);
            ++n5;
        }
        this.i.update(this.e);
        this.i.computeCurrent();
        this.j.update(this.f);
        this.j.computeCurrent();
        this.k = (MessageDigest.MDState)this.i.b().clone();
        this.l = (MessageDigest.MDState)this.j.b().clone();
        this.n = false;
        Utils.setArray(byArray, (byte)0);
    }

    @Override
    public void update(byte by) {
        this.i.update(by);
        this.n = false;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.i.update(byArray, n2, n3);
        this.n = false;
    }

    @Override
    public void computeCurrent() {
        MessageDigest messageDigest = (MessageDigest)this.i.clone();
        this.i.computeCurrent();
        this.j.update(this.i.a());
        this.j.computeCurrent();
        System.arraycopy(this.j.a(), 0, this.m, 0, this.m.length);
        this.n = true;
        this.i = messageDigest;
        this.j.a(this.l);
    }

    @Override
    public String algName() {
        return "HMAC-" + this.j.algName();
    }

    @Override
    public int blockSize() {
        return this.i.blockSize();
    }

    @Override
    public int getDigestLength() {
        return this.j.getDigestLength();
    }

    @Override
    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    @Override
    byte[] a() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.m;
    }

    @Override
    public boolean isValid() {
        return this.n;
    }

    @Override
    public void erase() {
        this.c = null;
        if (this.d != null) {
            Utils.setArray(this.d, (byte)0);
            this.d = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    @Override
    public Object clone() {
        HMAC hMAC = new HMAC(this.d, this.g, this.h);
        hMAC.i = (MessageDigest)this.i.clone();
        hMAC.j = (MessageDigest)this.j.clone();
        hMAC.k = (MessageDigest.MDState)this.k.clone();
        hMAC.l = (MessageDigest.MDState)this.l.clone();
        hMAC.e = (byte[])this.e.clone();
        hMAC.f = (byte[])this.f.clone();
        hMAC.m = (byte[])this.m.clone();
        hMAC.n = this.n;
        return hMAC;
    }

    @Override
    protected MessageDigest.MDState b() {
        return null;
    }

    @Override
    protected void a(MessageDigest.MDState mDState) {
        throw new RuntimeException("setState not valid for HMAC class");
    }
}

