/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public final class RC2
extends BlockCipher {
    private static final int g = 8;
    private static final byte[] h = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private int i;
    private boolean j = false;
    private short[] k;

    public RC2() {
        super(8);
        this.d = 1;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.e = symmetricKey;
        this.f = randomBitsSource;
        this.a(algorithmIdentifier);
        this.a((SymmetricKey)this.e);
        this.c();
        this.c = iD;
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.j = false;
        this.i = 0;
        if (algorithmIdentifier.getOID().equals(AlgID.RC2_CBC.getOID())) {
            byte[] byArray = null;
            RC2AlgorithmIdentifier rC2AlgorithmIdentifier = null;
            rC2AlgorithmIdentifier = !(algorithmIdentifier instanceof RC2AlgorithmIdentifier) ? new RC2AlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters()) : (RC2AlgorithmIdentifier)algorithmIdentifier;
            byArray = rC2AlgorithmIdentifier.getIV();
            int n2 = rC2AlgorithmIdentifier.getEffectiveKeyLength();
            if (n2 > 0) {
                this.j = true;
                this.i = n2;
            }
            if (byArray == null) {
                byArray = new byte[this.b];
                this.b().randomBytes(byArray);
            }
            try {
                this.a(byArray);
            }
            catch (CipherException cipherException) {
                throw new AlgorithmIdentifierException(cipherException.toString());
            }
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for RC2");
        }
    }

    private void a(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n2;
        oracle.security.crypto.core.a.a(symmetricKey, 1024);
        int n3 = Math.min(symmetricKey.d().length, 128);
        if (n3 < 1) {
            throw new InvalidKeyException("Invalid RC2 key.");
        }
        if (!this.j) {
            this.i = n3 * 8;
        }
        int n4 = (this.i + 7) / 8;
        int n5 = 255 >> 8 * n4 - this.i;
        byte[] byArray = new byte[128];
        System.arraycopy(symmetricKey.d(), 0, byArray, 0, n3);
        for (n2 = n3; n2 < 128; ++n2) {
            byArray[n2] = h[byArray[n2 - 1] + byArray[n2 - n3] & 0xFF];
        }
        byArray[128 - n4] = h[byArray[128 - n4] & n5 & 0xFF];
        for (n2 = 127 - n4; n2 >= 0; --n2) {
            byArray[n2] = h[(byArray[n2 + 1] ^ byArray[n2 + n4]) & 0xFF];
        }
        this.k = new short[64];
        for (n2 = 0; n2 < 128; n2 += 2) {
            this.k[n2 / 2] = (short)(byArray[n2 + 1] << 8 | byArray[n2] & 0xFF);
        }
    }

    @Override
    protected void a(byte[] byArray, int n2, byte[] byArray2, int n3) throws CipherException {
        short s2 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s3 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s4 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s5 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        int n4 = 63;
        while (n4 >= 0) {
            if (n4 == 19 | n4 == 43) {
                s5 = (short)(s5 - this.k[s4 & 0x3F]);
                s4 = (short)(s4 - this.k[s3 & 0x3F]);
                s3 = (short)(s3 - this.k[s2 & 0x3F]);
                s2 = (short)(s2 - this.k[s5 & 0x3F]);
            }
            s5 = (short)(Utils.rotrShort(s5, 5) - (s2 & ~s4) - (s3 & s4) - this.k[n4--]);
            s4 = (short)(Utils.rotrShort(s4, 3) - (s5 & ~s3) - (s2 & s3) - this.k[n4--]);
            s3 = (short)(Utils.rotrShort(s3, 2) - (s4 & ~s2) - (s5 & s2) - this.k[n4--]);
            s2 = (short)(Utils.rotrShort(s2, 1) - (s3 & ~s5) - (s4 & s5) - this.k[n4--]);
        }
        byArray2[n3++] = (byte)s2;
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s3;
        byArray2[n3++] = (byte)(s3 >>> 8);
        byArray2[n3++] = (byte)s4;
        byArray2[n3++] = (byte)(s4 >>> 8);
        byArray2[n3++] = (byte)s5;
        byArray2[n3++] = (byte)(s5 >>> 8);
    }

    @Override
    protected void b(byte[] byArray, int n2, byte[] byArray2, int n3) throws CipherException {
        short s2 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s3 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s4 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        short s5 = (short)(byArray[n2++] & 0xFF | byArray[n2++] << 8);
        int n4 = 0;
        while (n4 < 64) {
            s2 = Utils.rotlShort(s2 + (s3 & ~s5) + (s4 & s5) + this.k[n4++], 1);
            s3 = Utils.rotlShort(s3 + (s4 & ~s2) + (s5 & s2) + this.k[n4++], 2);
            s4 = Utils.rotlShort(s4 + (s5 & ~s3) + (s2 & s3) + this.k[n4++], 3);
            s5 = Utils.rotlShort(s5 + (s2 & ~s4) + (s3 & s4) + this.k[n4++], 5);
            if (!(n4 == 20 | n4 == 44)) continue;
            s2 = (short)(s2 + this.k[s5 & 0x3F]);
            s3 = (short)(s3 + this.k[s2 & 0x3F]);
            s4 = (short)(s4 + this.k[s3 & 0x3F]);
            s5 = (short)(s5 + this.k[s4 & 0x3F]);
        }
        byArray2[n3++] = (byte)s2;
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s3;
        byArray2[n3++] = (byte)(s3 >>> 8);
        byArray2[n3++] = (byte)s4;
        byArray2[n3++] = (byte)(s4 >>> 8);
        byArray2[n3++] = (byte)s5;
        byArray2[n3++] = (byte)(s5 >>> 8);
    }

    @Override
    public String algName() {
        return "RC2";
    }

    @Override
    public void erase() {
        super.erase();
        Utils.setArray(this.k, (short)0);
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return new RC2AlgorithmIdentifier(this.getIV(), this.i);
    }

    public int getEffectiveKeyLength() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.i;
    }

    public String toString() {
        return this.algName();
    }
}

