/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public abstract class RSAKey
implements java.security.interfaces.RSAKey,
ASN1Object,
Key {
    private BigInt a;
    private BigInt b;

    protected RSAKey() {
    }

    protected RSAKey(byte[] byArray) throws IOException {
        this.setBytes(byArray);
    }

    protected RSAKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    protected RSAKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toBytes(aSN1Sequence));
    }

    protected RSAKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setModulusExponent(bigInteger, bigInteger2);
    }

    RSAKey(BigInt bigInt, BigInt bigInt2) {
        this.a(bigInt, bigInt2);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            return 0;
        }
        return this.a.bitLength();
    }

    @Override
    public void erase() {
        if (this.b != null && !this.isPublic()) {
            this.b.erase();
        }
        this.b = null;
        this.a = null;
    }

    protected void a() {
        if (!(this.isPublic() || this.getAllowExport() && FIPS_140_2.getAllowKeyExport())) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    @Override
    public abstract Object clone();

    public void setBytes(byte[] byArray) throws IOException {
        FIPS_140_2.assertReadyState();
        if (byArray.length != 0) {
            this.input(new UnsyncByteArrayInputStream(byArray));
        }
    }

    public int modulusLength() {
        FIPS_140_2.assertReadyState();
        return Utils.length(this.a);
    }

    @Override
    public BigInteger getModulus() {
        return new BigInteger(this.b().toByteArray());
    }

    BigInt b() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public BigInteger getExponent() {
        this.a();
        return new BigInteger(this.c().toByteArray());
    }

    BigInt c() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public void setModulusExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    void a(BigInt bigInt, BigInt bigInt2) {
        FIPS_140_2.assertReadyState();
        this.erase();
        this.b = bigInt2;
        this.a = bigInt;
    }

    public abstract boolean isPublic();

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

