/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.MaskException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.OAEPAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.e;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public final class RSApkcs1
extends Cipher {
    private static final int a = 0;
    private static final int b = 1;
    private e c;
    private MessageDigest g;
    private int h = 1;
    private byte[] i;

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        oracle.security.crypto.core.a.a(key, 16384);
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        this.f = randomBitsSource;
        this.a(algorithmIdentifier);
        super.erase();
        this.e = key;
        this.c();
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            if (algorithmIdentifier.getParameters() != null && !(algorithmIdentifier.getParameters() instanceof ASN1Null)) {
                throw new AlgorithmIdentifierException("The rsaEncryption OID must be accompanied by NULL parameters");
            }
            this.h = 1;
        } else if (algorithmIdentifier.getOID().equals(OAEPAlgorithmIdentifier.a)) {
            OAEPAlgorithmIdentifier oAEPAlgorithmIdentifier = algorithmIdentifier instanceof OAEPAlgorithmIdentifier ? (OAEPAlgorithmIdentifier)algorithmIdentifier : new OAEPAlgorithmIdentifier(algorithmIdentifier.getParameters());
            AlgorithmIdentifier algorithmIdentifier2 = oAEPAlgorithmIdentifier.getPSourceFunc();
            if (!algorithmIdentifier2.getOID().equals(OAEPAlgorithmIdentifier.b)) {
                throw new AlgorithmIdentifierException("Only pSpecified AlgIDs are supported for OAEP encoding");
            }
            ASN1Object aSN1Object = algorithmIdentifier2.getParameters();
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new AlgorithmIdentifierException("pSourceFunc parameters must be an instance of ASN1OctetString");
            }
            this.i = ((ASN1OctetString)aSN1Object).getValue();
            this.g = MessageDigest.getInstance(oAEPAlgorithmIdentifier.getHashFunc());
            this.c = oracle.security.crypto.core.e.b(oAEPAlgorithmIdentifier.getMaskGenFunc());
            this.h = 0;
        } else {
            throw new AlgorithmIdentifierException("Unsupported AlgorithmIdentifier: " + algorithmIdentifier);
        }
    }

    private byte[] a(byte[] byArray) throws CipherException {
        int n2;
        int n3 = byArray.length;
        if (this.g == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance, the MessageDigest of this instance has been explicitly set to null");
        }
        if (this.c == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance, the MaskGenerator of this instance has been explicitly set to null");
        }
        int n4 = this.g.getDigestLength();
        if (n3 < 2 * n4 + 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        int n5 = n3 - n4;
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, n4, byArray3, 0, n5);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.c.a(byArray3, n4));
            byArray5 = Utils.xor(byArray3, this.c.a(byArray4, n5));
        }
        catch (MaskException maskException) {
            throw new CipherException(maskException.toString());
        }
        byte[] byArray6 = new byte[n4];
        System.arraycopy(byArray5, 0, byArray6, 0, n4);
        this.g.init();
        if (this.i != null) {
            this.g.update(this.i);
        }
        this.g.computeCurrent();
        if (!Utils.areEqual(byArray6, this.g.getDigestBits())) {
            throw new CipherException("Decoding error");
        }
        for (n2 = n4; n2 < n5 && byArray5[n2] == 0; ++n2) {
        }
        if (n2 == n5 || byArray5[n2] != 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray7 = new byte[n5 - n2 - 1];
        System.arraycopy(byArray5, n2 + 1, byArray7, 0, byArray7.length);
        return byArray7;
    }

    private byte[] a(byte[] byArray, int n2) throws CipherException {
        if (this.g == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance, the MessageDigest of this instance has not been configured");
        }
        if (this.c == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance, the MaskGenerator of this instance has not been configured");
        }
        int n3 = byArray.length;
        int n4 = this.g.getDigestLength();
        if (n3 > n2 - 2 * n4 - 1) {
            throw new CipherException("Message too long");
        }
        this.g.init();
        if (this.i != null) {
            this.g.update(this.i);
        }
        this.g.computeCurrent();
        byte[] byArray2 = new byte[n2 - n4];
        System.arraycopy(this.g.getDigestBits(), 0, byArray2, 0, n4);
        byArray2[byArray2.length - n3 - 1] = 1;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - n3, n3);
        byte[] byArray3 = new byte[n4];
        this.b().randomBytes(byArray3);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.c.a(byArray3, byArray2.length));
            byArray5 = Utils.xor(byArray3, this.c.a(byArray4, n4));
        }
        catch (MaskException maskException) {
            throw new CipherException(maskException.toString());
        }
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray6, 0, n4);
        System.arraycopy(byArray4, 0, byArray6, n4, byArray4.length);
        return byArray6;
    }

    private byte[] b(byte[] byArray) throws CipherException {
        int n2;
        int n3 = byArray.length;
        if (n3 < 10 || byArray[0] != 2 && byArray[0] != 1) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1 && !((RSAKey)this.e).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 2 && ((RSAKey)this.e).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1) {
            for (n2 = 1; n2 < n3 && byArray[n2] != 0; ++n2) {
                if ((byArray[n2] & 0xFF) == 255) continue;
                throw new CipherException("Decoding error");
            }
        } else {
            for (n2 = 1; n2 < n3 && byArray[n2] != 0; ++n2) {
            }
        }
        if (n2 == n3 || n2 < 9) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n3 - n2 - 1];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] b(byte[] byArray, int n2) throws CipherException {
        int n3 = byArray.length;
        int n4 = n2 - n3;
        if (n4 < 10) {
            throw new CipherException("Message too long");
        }
        byte[] byArray2 = new byte[n2];
        if (((RSAKey)this.e).isPublic()) {
            RandomBitsSource randomBitsSource = this.b();
            byArray2[0] = 2;
            for (int i2 = 1; i2 < n4 - 1; ++i2) {
                byte by = randomBitsSource.randomByte();
                while (by == 0) {
                    by = randomBitsSource.randomByte();
                }
                byArray2[i2] = by;
            }
        } else {
            byArray2[0] = 1;
            for (int i3 = 1; i3 < n4 - 1; ++i3) {
                byArray2[i3] = -1;
            }
        }
        byArray2[n4 - 1] = 0;
        System.arraycopy(byArray, 0, byArray2, n4, n3);
        return byArray2;
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        this.d();
        return this.a(byArray, n2, n3, false);
    }

    private byte[] a(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        RSAKey rSAKey = (RSAKey)this.e;
        BigInt bigInt = rSAKey.b();
        int n4 = Utils.length(bigInt);
        byte[] byArray2 = null;
        if (n2 == 0 && n3 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        if (byArray2.length != n4) {
            throw new CipherException("Decryption error");
        }
        BigInt bigInt2 = new BigInt(1, byArray2);
        if (bigInt2.compareTo(bigInt) >= 0) {
            throw new CipherException("Decryption error");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        BigInt bigInt3 = rSA.a(bigInt2);
        if (bigInt3.compareTo(BigInt.valueOf(256L).pow(n4 - 1)) >= 0) {
            throw new CipherException("Decryption error");
        }
        byte[] byArray3 = Utils.toByteArray(bigInt3);
        byte[] byArray4 = new byte[n4 - 1];
        System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
        try {
            switch (this.h) {
                case 0: {
                    return this.a(byArray4);
                }
                case 1: {
                    return this.b(byArray4);
                }
            }
            throw new CipherException("Unknown encoding method");
        }
        catch (CipherException cipherException) {
            throw new CipherException("Decryption error");
        }
    }

    @Override
    public void decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        byte[] byArray3 = this.decrypt(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        this.e();
        return this.b(byArray, n2, n3, bl);
    }

    private byte[] b(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        RSAKey rSAKey = (RSAKey)this.e;
        int n4 = Utils.length(rSAKey.b());
        byte[] byArray2 = new byte[n4 - 1];
        byte[] byArray3 = null;
        if (n2 == 0 && n3 == byArray.length) {
            byArray3 = byArray;
        } else {
            byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
        }
        try {
            switch (this.h) {
                case 0: {
                    byArray2 = this.a(byArray3, n4 - 1);
                    break;
                }
                case 1: {
                    byArray2 = this.b(byArray3, n4 - 1);
                    break;
                }
                default: {
                    throw new CipherException("Unknown encoding method: " + this.h);
                }
            }
        }
        catch (CipherException cipherException) {
            throw new CipherException("Message too long");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        byte[] byArray4 = Utils.toByteArray(rSA.a(new BigInt(1, byArray2)));
        byte[] byArray5 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray5, n4 - byArray4.length, byArray4.length);
        return byArray5;
    }

    @Override
    public void encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        byte[] byArray3 = this.encrypt(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
    }

    @Override
    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        throw new CipherException("Cannot wrap private key using RSA PKCS#1");
    }

    @Override
    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.c(symmetricKey.d());
    }

    private byte[] c(byte[] byArray) throws CipherException {
        this.f();
        return this.b(byArray, 0, byArray.length, false);
    }

    @Override
    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        throw new CipherException("Cannot unwrap private using RSA PKCS#1");
    }

    @Override
    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.d(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    private byte[] d(byte[] byArray) throws CipherException {
        this.g();
        return this.a(byArray, 0, byArray.length, false);
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.h == 0) {
            return new OAEPAlgorithmIdentifier(this.g.getAlgID(), this.c.a(), new AlgorithmIdentifier(OAEPAlgorithmIdentifier.b, new ASN1OctetString(this.i)));
        }
        return AlgID.rsaEncryption;
    }

    @Override
    public String algName() {
        switch (this.h) {
            case 0: {
                return "RSAES-OAEP";
            }
            case 1: {
                return "RSAES-PKCS1-v1_5";
            }
        }
        return "Unknown encoding method: " + this.h;
    }

    @Override
    public int getBlockSize() {
        return 0;
    }

    @Override
    public void erase() {
        super.erase();
        this.h = 1;
        if (this.g != null) {
            this.g.init();
            this.g = null;
        }
        if (this.c != null) {
            this.c.b();
            this.c = null;
        }
    }
}

