/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AES;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.Arcfour;
import oracle.security.crypto.core.Blowfish;
import oracle.security.crypto.core.DES;
import oracle.security.crypto.core.DES_EDE;
import oracle.security.crypto.core.DHKeyAgreement;
import oracle.security.crypto.core.DHKeyPairGenerator;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.DSA;
import oracle.security.crypto.core.DSAKeyPairGenerator;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.DSAPublicKey;
import oracle.security.crypto.core.DiffieHellman;
import oracle.security.crypto.core.ECPrivateKey;
import oracle.security.crypto.core.ECPublicKey;
import oracle.security.crypto.core.HMAC;
import oracle.security.crypto.core.MD2;
import oracle.security.crypto.core.MD4;
import oracle.security.crypto.core.MD5;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PKCS12PBE;
import oracle.security.crypto.core.PKCS5PBE;
import oracle.security.crypto.core.PasswordBasedMAC;
import oracle.security.crypto.core.RC2;
import oracle.security.crypto.core.RSAKeyPairGenerator;
import oracle.security.crypto.core.RSAMDSignature;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RSApkcs1;
import oracle.security.crypto.core.SHA;
import oracle.security.crypto.core.SymmetricKeyGenerator;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.OIDSecurityException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.b;

public final class OIDManager {
    private static OIDManager b = null;
    private Map<ASN1ObjectID, Map<String, Class<?>>> c = new HashMap();
    private Map<String, ASN1ObjectID> d = new HashMap<String, ASN1ObjectID>();
    private Map<ASN1ObjectID, String> e = new HashMap<ASN1ObjectID, String>();
    protected OIDManager a = null;
    private static final Object f = new Object();
    private static ArrayList<String> g = new ArrayList();
    private static final String h = "=: \t\r\n\f#!";
    private static char[] i = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOIDManager(OIDManager oIDManager) {
        Object object = f;
        synchronized (object) {
            for (OIDManager oIDManager2 = oIDManager; oIDManager2 != null; oIDManager2 = oIDManager2.b()) {
                Map<ASN1ObjectID, Map<String, Class<?>>> map = oIDManager2.a();
                for (ASN1ObjectID aSN1ObjectID : map.keySet()) {
                    Map<String, Class<?>> map2 = map.get(aSN1ObjectID);
                    for (String string : map2.keySet()) {
                        if (!string.equals("cipher") && !string.equals("useCipher") && !string.equals("signature") && !string.equals("useSignature") && !string.equals("keyPairGenerator") && !string.equals("symmetricKeyGenerator") && !string.equals("useKeyAgreement") && !string.equals("keyAgreement") && !string.equals("messageDigest")) continue;
                        Class<?> clazz = map2.get(string);
                        OIDManager.a(clazz);
                    }
                }
            }
            b = oIDManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OIDManager getOIDManager() {
        if (b == null) {
            Object object = f;
            synchronized (object) {
                if (b == null) {
                    b = OIDManager.c();
                }
            }
        }
        return b;
    }

    private static OIDManager c() {
        OIDManager oIDManager = new OIDManager();
        oIDManager.d();
        return oIDManager;
    }

    public OIDManager() {
    }

    public OIDManager(OIDManager oIDManager) {
        this.a = oIDManager;
    }

    public Hashtable<String, Class<?>> setMappings(ASN1ObjectID aSN1ObjectID, Hashtable<String, Class<?>> hashtable) {
        Map<String, Class<?>> map = this.setMappings(aSN1ObjectID, (Map<String, Class<?>>)hashtable);
        return map == null ? null : new Hashtable(map);
    }

    public Map<String, Class<?>> setMappings(ASN1ObjectID aSN1ObjectID, Map<String, Class<?>> map) {
        for (String string : map.keySet()) {
            if (!string.equals("cipher") && !string.equals("useCipher") && !string.equals("signature") && !string.equals("useSignature") && !string.equals("keyPairGenerator") && !string.equals("symmetricKeyGenerator") && !string.equals("useKeyAgreement") && !string.equals("keyAgreement") && !string.equals("messageDigest")) continue;
            Class<?> clazz = map.get(string);
            OIDManager.a(clazz);
        }
        return this.c.put(aSN1ObjectID, map);
    }

    Map<ASN1ObjectID, Map<String, Class<?>>> a() {
        return this.c;
    }

    OIDManager b() {
        return this.a;
    }

    public Hashtable<String, Class<?>> getMappings(ASN1ObjectID aSN1ObjectID) {
        Map<String, Class<?>> map = this.getMappingsAsMap(aSN1ObjectID);
        return map == null ? null : new Hashtable(map);
    }

    public Map<String, Class<?>> getMappingsAsMap(ASN1ObjectID aSN1ObjectID) {
        Map<String, Class<?>> map = this.c.get(aSN1ObjectID);
        if (map == null && this.a != null) {
            map = this.a.getMappingsAsMap(aSN1ObjectID);
        } else if (map == null && this.a == null) {
            map = new HashMap();
            this.c.put(aSN1ObjectID, map);
            this.a(aSN1ObjectID, map);
            map = this.c.get(aSN1ObjectID);
        }
        return map;
    }

    public Class<?> setMapping(ASN1ObjectID aSN1ObjectID, String string, Class<?> clazz) {
        Map<String, Class<?>> map;
        if (string.equals("cipher") || string.equals("useCipher") || string.equals("signature") || string.equals("useSignature") || string.equals("keyPairGenerator") || string.equals("symmetricKeyGenerator") || string.equals("useKeyAgreement") || string.equals("keyAgreement") || string.equals("messageDigest")) {
            OIDManager.a(clazz);
        }
        if ((map = this.getMappingsAsMap(aSN1ObjectID)) == null) {
            map = new HashMap();
            this.setMappings(aSN1ObjectID, map);
        }
        return map.put(string, clazz);
    }

    public Class<?> getMapping(ASN1ObjectID aSN1ObjectID, String string) {
        Map<String, Class<?>> map = this.getMappingsAsMap(aSN1ObjectID);
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.get(string);
        if (clazz == null && this.a != null) {
            clazz = this.a.getMapping(aSN1ObjectID, string);
        } else if (clazz == null && this.a == null) {
            this.a(aSN1ObjectID, map);
            clazz = map.get(string);
        }
        return clazz;
    }

    public ASN1ObjectID setAttributeTypeName(String string, ASN1ObjectID aSN1ObjectID) {
        this.e.put(aSN1ObjectID, string);
        return this.d.put(string.toUpperCase(), aSN1ObjectID);
    }

    public ASN1ObjectID getAttributeType(String string) {
        ASN1ObjectID aSN1ObjectID = this.d.get(string.toUpperCase());
        if (aSN1ObjectID == null && this.a != null) {
            aSN1ObjectID = this.a.getAttributeType(string.toUpperCase());
        }
        return aSN1ObjectID;
    }

    public String getAttributeName(ASN1ObjectID aSN1ObjectID) {
        String string = this.e.get(aSN1ObjectID);
        if (string == null && this.a != null) {
            string = this.a.getAttributeName(aSN1ObjectID);
        }
        return string;
    }

    public void load(InputStream inputStream) throws IOException {
        while (true) {
            String string = null;
            int n2 = inputStream.read();
            if (n2 == -1) break;
            while (Character.isWhitespace((char)n2)) {
                n2 = inputStream.read();
            }
            if (n2 == 35 || n2 == 33) {
                while ((n2 = inputStream.read()) != -1 && n2 != 13 && n2 != 10) {
                }
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append((char)n2);
            } while ((n2 = inputStream.read()) != -1 && n2 != 13 && n2 != 10);
            string = stringBuffer.toString();
            if (string.length() <= 0) continue;
            char c2 = string.charAt(0);
            if (c2 == '&') {
                string = string.substring(1);
            }
            try {
                ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(OIDManager.b(OIDManager.a(string)));
                Properties properties = new Properties();
                properties.load(new a(inputStream));
                HashMap hashMap = new HashMap();
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    hashMap.put(string2, Class.forName(string3));
                }
                this.setMappings(aSN1ObjectID, hashMap);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new IOException(invalidFormatException.toString());
            }
        }
    }

    private static String a(String string) {
        int n2;
        for (n2 = 0; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        return n2 < string.length() ? string.substring(n2) : "";
    }

    private static String b(String string) {
        int n2;
        for (n2 = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return n2 > 0 ? string.substring(0, n2) : "";
    }

    private void d() {
    }

    private void a(ASN1ObjectID aSN1ObjectID, Map<String, Class<?>> map) {
        if (aSN1ObjectID.equals(AlgID.rsaEncryption.getOID()) || aSN1ObjectID.equals(AlgID.rsaWithOAEPEncoding.getOID())) {
            this.a(map);
        } else if (aSN1ObjectID.equals(AlgID.md2WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.md5WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha_1WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha256WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha384WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha512WithRSAEncryption.getOID())) {
            this.b(map);
        } else if (aSN1ObjectID.equals(AlgID.dsa.getOID()) || aSN1ObjectID.equals(AlgID.dsaOld.getOID())) {
            this.c(map);
        } else if (aSN1ObjectID.equals(AlgID.dsaWithSHA1.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA1Old.getOID())) {
            this.d(map);
        } else if (aSN1ObjectID.equals(AlgID.dh.getOID())) {
            this.e(map);
        } else if (aSN1ObjectID.equals(AlgID.dhKeyAgreement.getOID())) {
            this.f(map);
        } else if (aSN1ObjectID.equals(AlgID.ecKey.getOID())) {
            this.g(map);
        } else if (aSN1ObjectID.equals(AlgID.blowfishECB.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID())) {
            this.i(map);
        } else if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
            this.j(map);
        } else if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
            this.k(map);
        } else if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.l(map);
        } else if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
            this.m(map);
        } else if (aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes256_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.n(map);
        } else if (aSN1ObjectID.equals(AlgID.md2.getOID())) {
            this.o(map);
        } else if (aSN1ObjectID.equals(AlgID.md4.getOID())) {
            this.p(map);
        } else if (aSN1ObjectID.equals(AlgID.md5.getOID())) {
            this.q(map);
        } else if (aSN1ObjectID.equals(AlgID.sha_1.getOID()) || aSN1ObjectID.equals(AlgID.sha1.getOID()) || aSN1ObjectID.equals(AlgID.sha.getOID()) || aSN1ObjectID.equals(AlgID.sha_256.getOID()) || aSN1ObjectID.equals(AlgID.sha_384.getOID()) || aSN1ObjectID.equals(AlgID.sha_512.getOID())) {
            this.r(map);
        } else if (aSN1ObjectID.equals(AlgID.hmacMD5.getOID()) || aSN1ObjectID.equals(AlgID.hmacSHA.getOID()) || aSN1ObjectID.equals(AlgID.hmacWithSHA1.getOID()) || aSN1ObjectID.equals(AlgID.hmacWithSHA224.getOID()) || aSN1ObjectID.equals(AlgID.hmacWithSHA256.getOID()) || aSN1ObjectID.equals(AlgID.hmacWithSHA384.getOID()) || aSN1ObjectID.equals(AlgID.hmacWithSHA512.getOID())) {
            this.s(map);
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
            this.t(map);
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndRC2_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndRC2_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndDES_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndRC2_CBC) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
            this.u(map);
        } else if (aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            this.v(map);
        }
    }

    private void a(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("privateKey")) {
                map.put("privateKey", RSAPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("publicKey")) {
                map.put("publicKey", RSAPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", RSApkcs1.class);
            }
            if (!map.containsKey("useCipher")) {
                map.put("useCipher", RSApkcs1.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("useSignature")) {
                map.put("useSignature", RSAMDSignature.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("keyPairGenerator")) {
                map.put("keyPairGenerator", RSAKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void b(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("signature")) {
                map.put("signature", RSAMDSignature.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void c(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("privateKey")) {
                map.put("privateKey", DSAPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("publicKey")) {
                map.put("publicKey", DSAPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("useSignature")) {
                map.put("useSignature", DSA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("keyPairGenerator")) {
                map.put("keyPairGenerator", DSAKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void d(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("signature")) {
                map.put("signature", DSA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void e(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("privateKey")) {
                map.put("privateKey", DHPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("publicKey")) {
                map.put("publicKey", DHPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("useKeyAgreement")) {
                map.put("useKeyAgreement", DHKeyAgreement.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("keyPairGenerator")) {
                map.put("keyPairGenerator", DHKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("keyAgreement")) {
                map.put("keyAgreement", DHKeyAgreement.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void f(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", DiffieHellman.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void g(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("privateKey")) {
                map.put("privateKey", ECPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!map.containsKey("publicKey")) {
                map.put("publicKey", ECPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void h(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("symmetricKeyGenerator")) {
                map.put("symmetricKeyGenerator", SymmetricKeyGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void i(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", Blowfish.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void j(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", RC2.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void k(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", Arcfour.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void l(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", DES_EDE.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void m(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", DES.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void n(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("cipher")) {
                map.put("cipher", AES.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.h(map);
    }

    private void o(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", MD2.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void p(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", MD4.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void q(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", MD5.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void r(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", SHA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void s(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", HMAC.class);
            }
            if (!map.containsKey("mac")) {
                map.put("mac", HMAC.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void t(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("pbe")) {
                map.put("pbe", PKCS12PBE.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void u(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("pbe")) {
                map.put("pbe", PKCS5PBE.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void v(Map<String, Class<?>> map) {
        try {
            if (!map.containsKey("messageDigest")) {
                map.put("messageDigest", PasswordBasedMAC.class);
            }
            if (!map.containsKey("mac")) {
                map.put("mac", PasswordBasedMAC.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void a(Class<?> clazz) {
        try {
            DSAPublicKey dSAPublicKey = new DSAPublicKey(Utils.fromHexString("308201b63082012b06072a8648ce3804013082011e02818100e6596ab57a361b583ad49f1616c3f4d14f5c979cfb7a6ce4c6a4eb7b80bca55fea753f184646f1aef1caec173b057771eda6dc3f8ebce360dc119d3bbbb7ac0b3955f63ce24135ac8a3f5dea5f0dadaf5144cab3dfbc03c748543d17e65877845451e942481494bd656a2fd48ecdfa7db8889d75a84777d6427ebebe3a8fe52f021500bd23d0cfb6a4db89c1a3983048c7c45e4bc46e57028180094caa028124447a4aadb9959c0f2ddef91210cf06937a8799336e9f155d98155a8ada8f9dfe83ed25f12d140dbee27cf81008ef453ffa2bb911492713e433bc7d9b3cff41f695e5f6534157cf30ce3082f8cde4403dbe063a6cf8d7499138e1ac9332822f0a3c60836e67d2a9ff85d7e9c12290c880acd6c5b85430777d55f203818400028180730ed85217d16ad96fc08cf9cc65497c627bfc38316e95251c447027d9dcab1e7028a3047dc4dd8141fbc5dbc99e0eeafce45a74309632dbed8d966f5545ba8a69f85f78465fef7dc59ff10c530d4e1201de18ee02c1866eb277df4c7989da98667f3360bb7d6e99ab0a91ec4a152452f313b1abc1121ef0ae83a71a55c82a0b"));
            OIDManager.a(dSAPublicKey, clazz);
        }
        catch (Throwable throwable) {
            throw new OIDSecurityException(throwable.toString());
        }
    }

    private static void a(DSAPublicKey dSAPublicKey, Class<?> clazz) {
        try {
            int n2;
            Object object;
            Object object2;
            URL uRL = OIDManager.b(clazz);
            if (uRL == null) {
                throw new OIDSecurityException("Could not get URL for JAR file containing " + clazz.getName());
            }
            if (g.contains(uRL.toString())) {
                return;
            }
            InputStream inputStream = OIDManager.a(uRL);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            Properties properties = null;
            byte[] byArray = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                object2 = zipEntry.getName();
                int n3 = (int)zipEntry.getSize();
                if (n3 <= 0 || !((String)object2).equals("META-INF/digests.properties") && !((String)object2).equals("META-INF/signature.bin")) continue;
                object = new byte[n3];
                n2 = 0;
                for (int i2 = 0; i2 < n3 && (n2 = zipInputStream.read((byte[])object, i2, n3 - i2)) != -1; i2 += n2) {
                }
                if (((String)object2).equals("META-INF/digests.properties")) {
                    properties = new Properties();
                    properties.load(new ByteArrayInputStream((byte[])object));
                    continue;
                }
                if (!((String)object2).equals("META-INF/signature.bin")) continue;
                byArray = (byte[])object.clone();
            }
            zipInputStream.close();
            if (properties == null) {
                throw new OIDSecurityException("Could not load the digest properties file for " + uRL);
            }
            if (byArray == null) {
                throw new OIDSecurityException("Could not load the signature binaries file for " + uRL);
            }
            zipInputStream = new ZipInputStream(OIDManager.a(uRL));
            object2 = new Properties();
            SHA sHA = new SHA();
            sHA.setAlgID(AlgID.sha_1);
            zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                object = zipEntry.getName();
                n2 = (int)zipEntry.getSize();
                if (n2 <= 0 || ((String)object).startsWith("META-INF/") || !((String)object).endsWith(".class")) continue;
                byte[] byArray2 = new byte[n2];
                int n4 = 0;
                for (int i3 = 0; i3 < n2 && (n4 = zipInputStream.read(byArray2, i3, n2 - i3)) != -1; i3 += n4) {
                }
                byte[] byArray3 = sHA.computeDigest(byArray2);
                byte[] byArray4 = Utils.fromHexString((String)properties.get(object));
                if (Utils.areEqual(byArray4, byArray3)) {
                    ((Properties)object2).put(object, Utils.toHexString(byArray3));
                    continue;
                }
                zipInputStream.close();
                throw new OIDSecurityException("Digest verification failed for " + (String)object);
            }
            zipInputStream.close();
            object = new ByteArrayOutputStream();
            OIDManager.writeProperties((Properties)object2, (OutputStream)object, null);
            byte[] byArray5 = ((ByteArrayOutputStream)object).toByteArray();
            DSA dSA = new DSA(dSAPublicKey, byArray, byArray5);
            if (!dSA.verify()) {
                throw new OIDSecurityException("Signature verification failed");
            }
            g.add(uRL.toString());
        }
        catch (Throwable throwable) {
            throw new OIDSecurityException(throwable.toString());
        }
    }

    private static URL b(Class clazz) throws Exception {
        return (URL)AccessController.doPrivileged(new oracle.security.crypto.util.a(clazz));
    }

    private static InputStream a(URL uRL) throws Exception {
        return (InputStream)AccessController.doPrivileged(new b(uRL));
    }

    public static void writeProperties(Properties properties, OutputStream outputStream, String string) throws IOException {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>(properties.size());
        Object object = properties.keys();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            n2 = 0;
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                if (string2.compareTo((String)arrayList.get(i2)) <= 0) continue;
                arrayList.add(i2 + 1, string2);
                n2 = 1;
                break;
            }
            if (n2 != 0) continue;
            arrayList.add(0, string2);
        }
        object = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            OIDManager.a((BufferedWriter)object, "#" + string);
        }
        n2 = arrayList.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            String string3 = (String)arrayList.get(i3);
            String string4 = (String)properties.get(string3);
            string3 = OIDManager.c(string3);
            string4 = OIDManager.c(string4);
            OIDManager.a((BufferedWriter)object, string3 + "=" + string4);
        }
        ((BufferedWriter)object).flush();
    }

    private static void a(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.write("\r\n");
    }

    private static String c(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = 0;
        block7: while (n3 < n2) {
            char c2 = string.charAt(n3++);
            switch (c2) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block7;
                }
            }
            if (c2 < '\u0014' || c2 > '\u007f') {
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(OIDManager.a(c2 >> 12 & 0xF));
                stringBuffer.append(OIDManager.a(c2 >> 8 & 0xF));
                stringBuffer.append(OIDManager.a(c2 >> 4 & 0xF));
                stringBuffer.append(OIDManager.a(c2 >> 0 & 0xF));
                continue;
            }
            if (h.indexOf(c2) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static char a(int n2) {
        return i[n2 & 0xF];
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    private class a
    extends FilterInputStream {
        private boolean b;
        private boolean c;

        public a(InputStream inputStream) {
            super(inputStream);
            this.b = false;
            this.c = false;
        }

        @Override
        public int read() throws IOException {
            int n2;
            if (this.c || (n2 = this.in.read()) == -1) {
                return -1;
            }
            if (this.b) {
                if (n2 == 13 || n2 == 10) {
                    this.b = false;
                }
            } else if (n2 == 35 || n2 == 33) {
                this.b = true;
            } else if (n2 == 38) {
                this.c = true;
            }
            return this.c ? -1 : n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5 = -1;
            for (n4 = 0; n4 < n3 && (n5 = this.read()) != -1; ++n4) {
                byArray[n2 + n4] = (byte)n5;
            }
            return n4 == 0 && n5 == -1 ? -1 : n4;
        }
    }
}

