/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class Utils {
    public static short rotlShort(int n2, int n3) {
        int n4 = n2 & 0xFFFF;
        return (short)(n4 << n3 | n4 >> 16 - n3);
    }

    public static short rotrShort(int n2, int n3) {
        int n4 = n2 & 0xFFFF;
        return (short)(n4 >> n3 | n4 << 16 - n3);
    }

    public static void setArray(byte[] byArray, byte by) {
        if (byArray == null) {
            return;
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = by;
        }
    }

    public static void setArray(short[] sArray, short s2) {
        if (sArray == null) {
            return;
        }
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = s2;
        }
    }

    public static void setArray(int[] nArray, int n2) {
        if (nArray == null) {
            return;
        }
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = n2;
        }
    }

    public static void setArray(byte[] byArray, int n2, int n3, byte by) {
        if (byArray == null) {
            return;
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            byArray[i2] = by;
        }
    }

    public static int rotl(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    public static int rotr(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    public static int bytesToWord(int n2, int n3, int n4, int n5) {
        return n5 & 0xFF | (n4 & 0xFF) << 8 | (n3 & 0xFF) << 16 | (n2 & 0xFF) << 24;
    }

    public static short bytesToShort(int n2, int n3) {
        return (short)(n3 & 0xFF | (n2 & 0xFF) << 8);
    }

    public static void bytesToWords(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = n2;
        int n6 = n3 + n4;
        for (int i2 = n3; i2 < n6; ++i2) {
            nArray[i2] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        }
    }

    public static void bytesToWords(byte[] byArray, int[] nArray) {
        Utils.bytesToWords(byArray, 0, nArray, 0, nArray.length);
    }

    public static void bytesToLongs(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        int n5 = n2;
        int n6 = n3 + n4;
        for (int i2 = n3; i2 < n6; ++i2) {
            lArray[i2] = ((long)byArray[n5++] & 0xFFL) << 56 | ((long)byArray[n5++] & 0xFFL) << 48 | ((long)byArray[n5++] & 0xFFL) << 40 | ((long)byArray[n5++] & 0xFFL) << 32 | ((long)byArray[n5++] & 0xFFL) << 24 | ((long)byArray[n5++] & 0xFFL) << 16 | ((long)byArray[n5++] & 0xFFL) << 8 | (long)byArray[n5++] & 0xFFL;
        }
    }

    public static void bytesToShorts(byte[] byArray, short[] sArray) {
        int n2 = 0;
        int n3 = sArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray[i2] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        }
    }

    public static void bytesToChars(byte[] byArray, char[] cArray) {
        int n2 = 0;
        int n3 = byArray.length / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = (char)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        }
        if (byArray.length % 2 == 1) {
            cArray[byArray.length / 2] = (char)(byArray[byArray.length - 1] & 0xFF);
        }
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56), (byte)(l2 >> 48), (byte)(l2 >> 40), (byte)(l2 >> 32), (byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2};
        return byArray;
    }

    public static byte[] wordToBytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return byArray;
    }

    public static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 >> 8), (byte)s2};
        return byArray;
    }

    public static void longsToBytes(long[] lArray, byte[] byArray) {
        Utils.longsToBytes(lArray, 0, byArray, 0, lArray.length);
    }

    public static void longsToBytes(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n2 + n4;
        for (int i2 = n2; i2 < n6; ++i2) {
            byArray[n5++] = (byte)(lArray[i2] >> 56);
            byArray[n5++] = (byte)(lArray[i2] >> 48);
            byArray[n5++] = (byte)(lArray[i2] >> 40);
            byArray[n5++] = (byte)(lArray[i2] >> 32);
            byArray[n5++] = (byte)(lArray[i2] >> 24);
            byArray[n5++] = (byte)(lArray[i2] >> 16);
            byArray[n5++] = (byte)(lArray[i2] >> 8);
            byArray[n5++] = (byte)lArray[i2];
        }
    }

    public static void wordsToBytes(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n2 + n4;
        for (int i2 = n2; i2 < n6; ++i2) {
            byArray[n5++] = (byte)(nArray[i2] >> 24);
            byArray[n5++] = (byte)(nArray[i2] >> 16);
            byArray[n5++] = (byte)(nArray[i2] >> 8);
            byArray[n5++] = (byte)nArray[i2];
        }
    }

    public static void wordsToBytes(int[] nArray, byte[] byArray) {
        Utils.wordsToBytes(nArray, 0, byArray, 0, nArray.length);
    }

    public static void shortsToBytes(short[] sArray, byte[] byArray) {
        int n2 = 0;
        int n3 = sArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2++] = (byte)(sArray[i2] >> 8);
            byArray[n2++] = (byte)sArray[i2];
        }
    }

    public static void charsToBytes(char[] cArray, byte[] byArray) {
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2++] = (byte)(cArray[i2] >> 8);
            byArray[n2++] = (byte)cArray[i2];
        }
    }

    public static byte[] unicodeToBytes(String string) {
        char[] cArray = new char[string.length()];
        byte[] byArray = new byte[cArray.length << 1];
        string.getChars(0, cArray.length, cArray, 0);
        Utils.charsToBytes(cArray, byArray);
        return byArray;
    }

    public static String bytesToUnicode(byte[] byArray) {
        char[] cArray = new char[(byArray.length - 1) / 2 + 1];
        Utils.bytesToChars(byArray, cArray);
        return new String(cArray);
    }

    public static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static void toByteArray(BigInteger bigInteger, byte[] byArray, int n2, int n3) throws ArithmeticException {
        byte[] byArray2 = Utils.toByteArray(bigInteger);
        if (byArray2.length > n3) {
            throw new ArithmeticException("The argument is too big to fit in the destination buffer");
        }
        Utils.setArray(byArray, n2, n3, (byte)0);
        System.arraycopy(byArray2, 0, byArray, n2 + (n3 - byArray2.length), byArray2.length);
    }

    public static int length(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        if (n2 == 0) {
            return 1;
        }
        return (n2 - 1) / 8 + 1;
    }

    public static byte[] toByteArray(BigInt bigInt) {
        byte[] byArray = bigInt.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static void toByteArray(BigInt bigInt, byte[] byArray, int n2, int n3) throws ArithmeticException {
        byte[] byArray2 = Utils.toByteArray(bigInt);
        if (byArray2.length > n3) {
            throw new ArithmeticException("The argument is too big to fit in the destination buffer");
        }
        Utils.setArray(byArray, n2, n3, (byte)0);
        System.arraycopy(byArray2, 0, byArray, n2 + (n3 - byArray2.length), byArray2.length);
    }

    public static int length(BigInt bigInt) {
        int n2 = bigInt.bitLength();
        if (n2 == 0) {
            return 1;
        }
        return (n2 - 1) / 8 + 1;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n5 = n2 + n4;
        while (n2 < n4) {
            if (byArray[n2] != byArray2[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static String plural(int n2, String string) {
        return n2 + " " + string + (n2 == 1 ? "" : "s");
    }

    public static String fromUTF8(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            int n5 = byArray[i2] & 0xFF;
            if (n5 < 128) {
                stringBuffer.append((char)n5);
                continue;
            }
            if ((n5 & 0xE0) == 192) {
                if (i2 == byArray.length - 1) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                if (((n4 = byArray[++i2] & 0xFF) & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n5 & 0x1F) << 6 | n4 & 0x3F));
                continue;
            }
            if ((n5 & 0xF0) == 224) {
                if (i2 >= byArray.length - 2) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n4 = byArray[++i2] & 0xFF;
                n3 = byArray[++i2] & 0xFF;
                if ((n4 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n5 & 0xF) << 12 | (n4 & 0x3F) << 6 | n3 & 0x3F));
                continue;
            }
            if ((n5 & 0xF8) == 240) {
                if (i2 >= byArray.length - 3) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n4 = byArray[++i2] & 0xFF;
                n3 = byArray[++i2] & 0xFF;
                int n6 = byArray[++i2] & 0xFF;
                if ((n4 & 0xC0) != 128 || (n3 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                int n7 = ((n5 & 1) << 20 | (n4 & 0x3F) << 12 | (n3 & 0x3F) << 6 | n6 & 0x3F) - 65536;
                stringBuffer.append((char)(55296 + (n7 >> 10)));
                stringBuffer.append((char)(56320 + (n7 & 0x3FF)));
                continue;
            }
            throw new InvalidFormatException("Illegal UTF encoding");
        }
        return stringBuffer.toString();
    }

    public static byte[] toUTF8(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length() * 2);
        try {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 < '\u0080') {
                    unsyncByteArrayOutputStream.write((byte)c2);
                    continue;
                }
                if (c2 < '\u0800') {
                    unsyncByteArrayOutputStream.write(0xC0 | c2 >> 6);
                    unsyncByteArrayOutputStream.write(0x80 | c2 & 0x3F);
                    continue;
                }
                if (c2 >= '\ud800' && c2 < '\udc00' && i2 != string.length() - 1 && string.charAt(i2 + 1) >= '\udc00' && string.charAt(i2 + 1) < '\ue000') {
                    int n3 = c2 - 55296 << 10 + (string.charAt(i2 + 1) - 56320) + 65536;
                    unsyncByteArrayOutputStream.write(0xF0 | n3 >> 18);
                    unsyncByteArrayOutputStream.write(0x80 | n3 >> 12 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n3 >> 6 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n3 & 0x3F);
                    continue;
                }
                unsyncByteArrayOutputStream.write(0xE0 | c2 >> 12);
                unsyncByteArrayOutputStream.write(0x80 | c2 >> 6 & 0x3F);
                unsyncByteArrayOutputStream.write(0x80 | c2 & 0x3F);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static int inputWord(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        if (n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(n2, n3, n4, n5);
    }

    public static int input24bit(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n2 == -1 || n3 == -1 || n4 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(0, n2, n3, n4);
    }

    public static short inputShort(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n2 == -1 || n3 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToShort(n2, n3);
    }

    public static byte inputByte(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public static byte[] inputBytes(InputStream inputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        return Utils.inputByteArray(byArray, inputStream);
    }

    public static byte[] inputByteArray(byte[] byArray, InputStream inputStream) throws IOException {
        Utils.inputByteArray(byArray, 0, byArray.length, inputStream);
        return byArray;
    }

    public static void inputByteArray(byte[] byArray, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; i2 += n4) {
            n4 = inputStream.read(byArray, i2, n5 - i2);
            if (n4 != -1) continue;
            throw new IOException("End of stream reached before all " + n3 + " expected bytes could be read. Only received " + (i2 - n2) + " bytes before the end of the stream was reached");
        }
    }

    public static byte[] toBytes(InputStream inputStream) throws IOException {
        int n2;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            unsyncByteArrayOutputStream.write(byArray, 0, n2);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static void output(long l2, OutputStream outputStream) throws IOException {
        Utils.outputLong(l2, outputStream);
    }

    public static void output(int n2, OutputStream outputStream) throws IOException {
        Utils.outputWord(n2, outputStream);
    }

    public static void output(short s2, OutputStream outputStream) throws IOException {
        Utils.outputShort(s2, outputStream);
    }

    public static void output(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        Utils.outputBignum(bigInteger, outputStream);
    }

    public static void outputLong(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l2 >> 56));
        outputStream.write((byte)(l2 >> 48));
        outputStream.write((byte)(l2 >> 40));
        outputStream.write((byte)(l2 >> 32));
        outputStream.write((byte)(l2 >> 24));
        outputStream.write((byte)(l2 >> 16));
        outputStream.write((byte)(l2 >> 8));
        outputStream.write((byte)l2);
    }

    public static void outputWord(int n2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n2 >> 24));
        outputStream.write((byte)(n2 >> 16));
        outputStream.write((byte)(n2 >> 8));
        outputStream.write((byte)n2);
    }

    public static void output24bit(int n2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n2 >> 16));
        outputStream.write((byte)(n2 >> 8));
        outputStream.write((byte)n2);
    }

    public static void outputShort(int n2, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n2 >> 8));
        outputStream.write((byte)n2);
    }

    public static void outputBignum(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        outputStream.write(Utils.toByteArray(bigInteger));
    }

    public static BigInteger inputBignum(int n2, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[n2];
        Utils.inputByteArray(byArray, inputStream);
        BigInteger bigInteger = BigInteger.valueOf(0L);
        try {
            bigInteger = new BigInteger(1, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.toString());
        }
        return bigInteger;
    }

    public static void outputString(String string, OutputStream outputStream) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static void dumpHex(PrintStream printStream, byte[] byArray) {
        int n2;
        String string = "";
        String string2 = "";
        byte[] byArray2 = new byte[]{0};
        int n3 = n2 + ((n2 = byArray.length) % 16 == 0 ? 0 : 16 - n2 % 16);
        int n4 = 0;
        while (n4 < n3) {
            if (n4 < n2) {
                byArray2[0] = byArray[n4];
                string = string + Utils.toHexString(byArray2);
                string2 = byArray[n4] >= 32 && byArray[n4] <= 125 ? string2 + (char)(byArray[n4] & 0xFF) : string2 + ".";
            } else {
                string = string + "  ";
            }
            if (++n4 % 16 == 0) {
                printStream.println(string + "\t" + string2);
                string2 = "";
                string = "";
                continue;
            }
            string = string + " ";
        }
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            stringBuffer.append(string.charAt((byArray[i2] & 0xFF) >> 4));
            stringBuffer.append(string.charAt(byArray[i2] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Utils.toHexString(byArray, 0, byArray.length);
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("malformed hex string (non-even length)");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n2 = string.length() / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return byArray;
    }

    public static String toBase64(byte[] byArray) {
        return Utils.toBase64(byArray, true, true);
    }

    public static String toBase64(byte[] byArray, boolean bl) {
        String string = bl ? System.getProperty("line.separator") : "";
        return Utils.toBase64(byArray, string, true);
    }

    public static String toBase64(byte[] byArray, boolean bl, boolean bl2) {
        String string = bl ? System.getProperty("line.separator") : "";
        return Utils.toBase64(byArray, string, bl2);
    }

    public static String toBase64(byte[] byArray, String string) {
        return Utils.toBase64(byArray, string, true);
    }

    public static String toBase64(byte[] byArray, String string, boolean bl) {
        int n2 = (byArray.length + 2) / 3 * 4 + (byArray.length / 48 + 1) * string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; i2 += 3) {
            int n4 = Math.min(byArray.length - i2, 3);
            stringBuffer.append(Utils.b((byArray[i2] & 0xFC) >> 2));
            switch (n4) {
                case 2: 
                case 3: {
                    stringBuffer.append(Utils.b(((byArray[i2] & 3) << 4) + ((byArray[i2 + 1] & 0xF0) >> 4)));
                    break;
                }
                case 1: {
                    stringBuffer.append(Utils.b((byArray[i2] & 3) << 4));
                    break;
                }
            }
            switch (n4) {
                case 3: {
                    stringBuffer.append(Utils.b(((byArray[i2 + 1] & 0xF) << 2) + ((byArray[i2 + 2] & 0xC0) >> 6)));
                    break;
                }
                case 2: {
                    stringBuffer.append(Utils.b((byArray[i2 + 1] & 0xF) << 2));
                    break;
                }
                case 1: {
                    stringBuffer.append('=');
                    break;
                }
            }
            switch (n4) {
                case 3: {
                    stringBuffer.append(Utils.b(byArray[i2 + 2] & 0x3F));
                    break;
                }
                case 1: 
                case 2: {
                    stringBuffer.append('=');
                    break;
                }
            }
            if (i2 % 48 != 45) continue;
            stringBuffer.append(string);
        }
        if (bl && byArray.length % 48 <= 45) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromBase64(String string) {
        int n2 = string.length();
        int n3 = n2 / 4 * 3;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(n3);
        int n4 = 0;
        int n5 = 0;
        while (true) {
            char c2;
            if (n5 < n2 && ((c2 = string.charAt(n5)) == '\r' || c2 == '\n')) {
                ++n5;
                continue;
            }
            if (n5 + 4 > n2) break;
            char c3 = string.charAt(n5);
            char c4 = string.charAt(n5 + 1);
            char c5 = string.charAt(n5 + 2);
            char c6 = string.charAt(n5 + 3);
            int n6 = c5 == '=' ? 1 : (c6 == '=' ? 2 : 3);
            int n7 = Utils.a(c3);
            int n8 = Utils.a(c4);
            int n9 = 0;
            int n10 = 0;
            switch (n6) {
                case 3: {
                    n10 = Utils.a(c6);
                    n9 = Utils.a(c5);
                    break;
                }
                case 2: {
                    n9 = Utils.a(c5);
                    break;
                }
            }
            try {
                unsyncByteArrayOutputStream.write((n7 << 2) + ((n8 & 0x30) >> 4));
                if (n6 != 1) {
                    unsyncByteArrayOutputStream.write(((n8 & 0xF) << 4) + ((n9 & 0x3C) >> 2));
                }
                if (n6 == 3) {
                    unsyncByteArrayOutputStream.write(((n9 & 3) << 6) + n10);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            n4 += 3;
            n5 += 4;
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private static char b(int n2) {
        if (n2 < 26) {
            return (char)(65 + n2);
        }
        if (n2 < 52) {
            return (char)(97 + n2 - 26);
        }
        if (n2 < 62) {
            return (char)(48 + n2 - 52);
        }
        if (n2 == 62) {
            return '+';
        }
        if (n2 == 63) {
            return '/';
        }
        throw new IllegalArgumentException();
    }

    private static int a(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 - 65;
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return c2 - 97 + 26;
        }
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48 + 52;
        }
        if (c2 == '+') {
            return 62;
        }
        if (c2 == '/') {
            return 63;
        }
        throw new IllegalArgumentException();
    }

    public static String stripEOL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\r' || c2 == '\n') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String fromURLEncoded(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.charAt(i2);
            if (n2 == 43) {
                n2 = 32;
            } else if (n2 == 37) {
                n2 = string.charAt(++i2);
                int n3 = Character.digit((char)n2, 16);
                n2 = string.charAt(++i2);
                int n4 = Character.digit((char)n2, 16);
                n2 = (n3 & 0xF) << 4 | n4 & 0xF;
            }
            try {
                unsyncByteArrayOutputStream.write(n2);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return unsyncByteArrayOutputStream.toString();
    }

    public static String toURLEncoded(String string) {
        return URLEncoder.encode(string);
    }

    public static Date parseDate(String string) {
        return Utils.parseDate(string, false);
    }

    public static Date parseDate(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = -2;
        int n3 = 0;
        if (bl || string.indexOf(90) == 14 || string.indexOf(43) == 14 || string.indexOf(45) == 14) {
            n3 = 100 * Utils.a(string, n2 += 2);
            n3 += Utils.a(string, n2 += 2);
        } else {
            n3 = 1900 + Utils.a(string, n2 += 2);
            if (n3 < 1950) {
                n3 += 100;
            }
        }
        int n4 = Utils.a(string, n2 += 2);
        int n5 = Utils.a(string, n2 += 2);
        int n6 = Utils.a(string, n2 += 2);
        int n7 = Utils.a(string, n2 += 2);
        int n8 = 0;
        if (string.charAt(n2 + 2) >= '0' && string.charAt(n2 + 2) <= '9') {
            n8 = Utils.a(string, n2 += 2);
        }
        int n9 = 0;
        if (string.charAt(n2 += 2) != 'Z') {
            int n10 = Utils.a(string, n2 + 1);
            int n11 = Utils.a(string, n2 + 3);
            n9 = (n10 * 60 + n11) * 60 * 1000;
            if (string.charAt(n2) == '-') {
                n9 = -n9;
            }
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n9, "");
        Calendar calendar = Calendar.getInstance(simpleTimeZone);
        calendar.set(n3, n4 - 1, n5, n6, n7, n8);
        return calendar.getTime();
    }

    static int a(String string, int n2) {
        return 10 * (string.charAt(n2) - 48) + (string.charAt(n2 + 1) - 48);
    }

    public static String formatDate(Date date) {
        return Utils.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean bl) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(Utils.a(gregorianCalendar.get(1) / 100));
        }
        stringBuffer.append(Utils.a(gregorianCalendar.get(1) % 100));
        stringBuffer.append(Utils.a(gregorianCalendar.get(2) + 1));
        stringBuffer.append(Utils.a(gregorianCalendar.get(5)));
        int n2 = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n2 += 12;
        }
        stringBuffer.append(Utils.a(n2));
        stringBuffer.append(Utils.a(gregorianCalendar.get(12)));
        stringBuffer.append(Utils.a(gregorianCalendar.get(13)));
        return stringBuffer.append("Z").toString();
    }

    static String a(int n2) {
        String string = Integer.toString(n2);
        if (string.length() == 2) {
            return string;
        }
        return "0" + string;
    }

    public static Date daysFrom(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime();
    }

    public static Date daysFromNow(int n2) {
        return Utils.daysFrom(new Date(), n2);
    }

    public static Date minutesFrom(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n2);
        return calendar.getTime();
    }

    public static byte[] toBytes(Streamable streamable) {
        try {
            FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
            streamable.output(fixedByteArrayOutputStream);
            return fixedByteArrayOutputStream.getBytes();
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException);
        }
    }

    public static InputStream toStream(Streamable streamable) {
        return new UnsyncByteArrayInputStream(Utils.toBytes(streamable));
    }

    public static int hashBytes(Streamable streamable) {
        return new String(Utils.toBytes(streamable)).hashCode();
    }

    public static String toString(Vector<?> vector) {
        return Utils.toString(vector);
    }

    public static String toString(List<?> list) {
        if (list == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(list.get(i2).toString());
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = n2 - byArray2.length;
        if (n3 < 0) {
            return Utils.xor(byArray2, byArray);
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        for (int i2 = n3; i2 < n2; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2 - n3]);
        }
        return byArray3;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

