/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import oracle.security.pki.OraclePKIDebug;

public final class OraclePKIX509CertUsage {
    public static final int SSL = 1;
    public static final int S_MIME_ENCRYPTION = 2;
    public static final int S_MIME_SIGNATURE = 4;
    public static final int CODE_SIGNING = 8;
    public static final int CA_SIGNING = 16;
    public static final int TRUST_POINT = 32;
    public static final int UNSUPPORTED_USAGE = 64;

    static boolean a(X509Certificate x509Certificate) {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        String string = "2.5.29.15";
        if (set != null && !set.isEmpty()) {
            OraclePKIDebug.a("Critical Extensions Present");
            for (String string2 : set) {
                OraclePKIDebug.a("Extensions " + string2);
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static int keyUsageForCert(X509Certificate x509Certificate) {
        int n2;
        boolean[] blArray = x509Certificate.getKeyUsage();
        boolean bl = OraclePKIX509CertUsage.a(x509Certificate);
        int n3 = n2 = bl ? 0 : 32;
        if (blArray == null) {
            return 3 | n2;
        }
        if (blArray[0] && !blArray[2] && !blArray[5]) {
            return 0xC | n2;
        }
        if (!(!blArray[1] || blArray[0] || blArray[2] || blArray[3] || blArray[4] || blArray[5] || blArray[6] || blArray[7] || blArray[9])) {
            if (bl) {
                return 64;
            }
            return 0xC | n2;
        }
        if (blArray[2] && !blArray[5]) {
            return 3 | n2;
        }
        if (blArray[5]) {
            return 48;
        }
        if (bl) {
            return 64;
        }
        return 3 | n2;
    }

    public static boolean isCertValidFor(Certificate certificate, int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16 && n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException("Invalid Usage" + n2);
        }
        return certificate instanceof X509Certificate && (n2 & OraclePKIX509CertUsage.keyUsageForCert((X509Certificate)certificate)) != 0;
    }

    public static boolean isCertChainValidFor(Certificate[] certificateArray, int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16 && n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException("Invalid Usage " + n2);
        }
        if (certificateArray.length == 0) {
            return false;
        }
        if (!OraclePKIX509CertUsage.isCertValidFor(certificateArray[0], n2)) {
            return false;
        }
        for (int i2 = 1; i2 < certificateArray.length; ++i2) {
            if (OraclePKIX509CertUsage.isCertValidFor(certificateArray[i2], 32)) continue;
            return false;
        }
        return true;
    }
}

