/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import oracle.security.pki.ldap.ConnectionUtil$ConnectThread;

public class ConnectionUtil {
    public static InitialLdapContext getDefaultDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        long l2 = 10000L;
        Hashtable hashtable = ConnectionUtil.a(string, string2, string3, string4);
        hashtable.put("java.naming.ldap.attributes.binary", "userpkcs12");
        ConnectionUtil$ConnectThread connectionUtil$ConnectThread = new ConnectionUtil$ConnectThread(hashtable, null);
        connectionUtil$ConnectThread.start();
        try {
            connectionUtil$ConnectThread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new CommunicationException("Thread InterruptedException encountered - enable to create JNDI connection");
        }
        InitialLdapContext initialLdapContext = connectionUtil$ConnectThread.a();
        if (connectionUtil$ConnectThread.isAlive() && initialLdapContext == null) {
            connectionUtil$ConnectThread.interrupt();
            throw new CommunicationException("returnInitialLdapContext() times out after " + l2 + " ms - JNDI initialization method not returning");
        }
        if (initialLdapContext == null) {
            NamingException namingException = connectionUtil$ConnectThread.b();
            namingException.fillInStackTrace();
            throw namingException;
        }
        return initialLdapContext;
    }

    public static InitialLdapContext getSSLDirCtx(String string, String string2, String string3, String string4) throws NamingException {
        Hashtable hashtable = ConnectionUtil.a(string, string2, string3, string4);
        hashtable.put("java.naming.ldap.attributes.binary", "userpkcs12");
        hashtable.put("java.naming.ldap.factory.socket", "oracle.security.pki.ldap.LdapSSLSocketFactory");
        hashtable.put("java.naming.security.protocol", "ssl");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        int n2 = 0;
        while (true) {
            ++n2;
            try {
                return new InitialLdapContext(hashtable, null);
            }
            catch (NamingException namingException) {
                Throwable throwable;
                if (((throwable = namingException.getRootCause()) instanceof SSLHandshakeException || throwable instanceof SSLException) && n2 <= 2) continue;
                throw namingException;
            }
            break;
        }
    }

    private static Hashtable a(String string, String string2, String string3, String string4) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("java.naming.") || System.getProperty(string5).equals("com.evermind.server.ApplicationInitialContextFactory")) continue;
            hashtable.put(string5, System.getProperty(string5));
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        hashtable.put("java.naming.provider.url", "ldap://" + string + ":" + string2 + "/");
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string4);
        hashtable.put("java.naming.referral", "follow");
        return hashtable;
    }
}

