/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.security.pki.OraclePKIX509CertUsage;
import oracle.security.pki.ssl.OracleSSLDebug;
import oracle.security.pki.ssl.OracleSSLX509KeyManagerImpl$Entry;

final class OracleSSLX509KeyManagerImpl {
    Map a = new HashMap();

    public OracleSSLX509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            try {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                OracleSSLDebug.a("OracleX509KeyManager: Checking alias " + string);
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                Key key = keyStore.getKey(string, cArray);
                if (certificateArray == null || key == null || !OraclePKIX509CertUsage.isCertChainValidFor(certificateArray, 1)) continue;
                this.a.put(string, new OracleSSLX509KeyManagerImpl$Entry(this, certificateArray, (PrivateKey)key));
            }
            catch (ClassCastException classCastException) {
                OracleSSLDebug.a("OracleX509KeyManager: Not a Private Key " + classCastException);
            }
        }
        OracleSSLDebug.a("OracleX509KeyManager: Key Manager created with " + this.a.size() + " key pairs");
    }

    public final String a(String string, Principal[] principalArray) {
        OracleSSLDebug.a("OracleX509KeyManager: chooseClientAlias ");
        String[] stringArray = this.c(string, principalArray);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public final String b(String string, Principal[] principalArray) {
        OracleSSLDebug.a("OracleX509KeyManager: chooseServerAlias ");
        String[] stringArray = this.d(string, principalArray);
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public final X509Certificate[] a(String string) {
        OracleSSLDebug.a("OracleX509KeyManager: getCertificateChain " + string);
        if (!this.a.containsKey(string)) {
            return null;
        }
        return ((OracleSSLX509KeyManagerImpl$Entry)this.a.get(string)).a();
    }

    public final PrivateKey b(String string) {
        if (!this.a.containsKey(string)) {
            return null;
        }
        return ((OracleSSLX509KeyManagerImpl$Entry)this.a.get(string)).b();
    }

    public final String[] c(String string, Principal[] principalArray) {
        Vector<String> vector = new Vector<String>(this.a.size());
        Set set = this.a.entrySet();
        for (Map.Entry entry : set) {
            if (!OracleSSLX509KeyManagerImpl.a(((OracleSSLX509KeyManagerImpl$Entry)entry.getValue()).a(), principalArray) || !OracleSSLX509KeyManagerImpl.a(((OracleSSLX509KeyManagerImpl$Entry)entry.getValue()).b(), string)) continue;
            vector.addElement((String)entry.getKey());
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public final String[] d(String string, Principal[] principalArray) {
        return this.c(string, principalArray);
    }

    private static final boolean a(X509Certificate[] x509CertificateArray, Principal[] principalArray) {
        if (principalArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            for (int i3 = 0; i3 < principalArray.length; ++i3) {
                OracleSSLDebug.a("OracleX509KeyManager: check issuer " + principalArray[i3]);
                if (!x509CertificateArray[i2].getIssuerX500Principal().getName().equals(principalArray[i3].getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean a(PrivateKey privateKey, String string) {
        return string.equalsIgnoreCase(privateKey.getAlgorithm());
    }
}

