/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEventImpl;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
final class ONSDatabaseFailoverEvent
extends OracleFailoverEventImpl {
    private static final String ONS_FAILOVER_EVENT_DELIMITER = "{} =";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ONSDatabaseFailoverEvent(Notification n2) throws UniversalConnectionPoolException {
        super(n2.type());
        String drainTimeout;
        String reason;
        String cardinality;
        String status;
        String db_domain;
        String host;
        String database;
        String instance;
        ClioSupport.ilogFinest(null, null, null, null, "Notification: " + n2 + ", eventType: " + n2.type() + ", eventBody: " + n2.body());
        String version = n2.get("version");
        if (version != null && !version.startsWith("1.")) {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event version " + version);
            this.setValidity(false);
            return;
        }
        String service = n2.get("service");
        if (service != null) {
            this.setServiceName(service.trim().toLowerCase());
        }
        if ((instance = n2.get("instance")) != null && !instance.equals(" ")) {
            this.setInstanceName(instance.trim().toLowerCase());
        }
        if ((database = n2.get("database")) != null) {
            this.setDbUniqueName(database.trim().toLowerCase());
        }
        if ((host = n2.get("host")) != null) {
            this.setHostName(host.trim().toLowerCase());
        }
        if ((db_domain = n2.get("db_domain")) != null) {
            this.setDbDomainName(db_domain.trim().toLowerCase());
        }
        if ((status = n2.get("status")) != null) {
            this.setStatus(status);
        }
        if ((cardinality = n2.get("card")) != null) {
            try {
                this.setCardinality(Integer.parseInt(cardinality));
            }
            catch (NumberFormatException nfe) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid cardinality " + nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if ((reason = n2.get("reason")) != null) {
            this.setReason(reason.trim().toLowerCase());
        }
        if ((drainTimeout = n2.get("drain_timeout")) != null) {
            try {
                this.setDrainTimeout(Integer.parseInt(drainTimeout));
            }
            catch (NumberFormatException nfe) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid drain_timeout " + nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        String timestampValueStr = null;
        String timezoneValueStr = null;
        String tsprop = n2.get("timestamp");
        if (tsprop != null) {
            timestampValueStr = tsprop;
        }
        String tzprop = n2.get("timezone");
        if (tsprop != null) {
            timezoneValueStr = "GMT" + tzprop;
        }
        if (timestampValueStr == null && timezoneValueStr == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Older server, no timestamp/timezone in HA event");
        } else {
            SimpleDateFormat format = timezoneValueStr != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            Date ts = null;
            String tsWithZoneString = timezoneValueStr != null ? timestampValueStr + " " + timezoneValueStr : timestampValueStr;
            try {
                ts = format.parse(tsWithZoneString);
            }
            catch (ParseException pe) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + tsWithZoneString);
                this.setValidity(false);
                return;
            }
            if (ts == null) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + tsWithZoneString);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(ts);
            this.setTimeZone(timezoneValueStr);
        }
    }

    ONSDatabaseFailoverEvent(String eventType, byte[] eventBody) throws UniversalConnectionPoolException {
        super(eventType);
        ClioSupport.ilogFinest(null, null, null, null, "eventType: " + eventType + ", eventBody: " + eventBody);
        StringTokenizer strTokens = null;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_FAILOVER_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
        String st = null;
        String val = null;
        String key = null;
        String timestampValueStr = null;
        String timezoneValueStr = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.startsWith("1.")) {
                ClioSupport.ilogFinest(null, null, null, null, "Invalid Event version " + val);
                this.setValidity(false);
                return;
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                this.setServiceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                this.setInstanceName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                this.setDbUniqueName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                this.setHostName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("db_domain") && val != null) {
                this.setDbDomainName(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                this.setStatus(val);
                continue;
            }
            if (key.equalsIgnoreCase("card") && val != null) {
                try {
                    this.setCardinality(Integer.parseInt(val));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    ClioSupport.ilogFinest(null, null, null, null, "invalid cardinality " + nfe.getMessage());
                    this.setValidity(false);
                    return;
                }
            }
            if (key.equalsIgnoreCase("reason") && val != null) {
                this.setReason(val.trim().toLowerCase());
                continue;
            }
            if (key.equalsIgnoreCase("timestamp") && val != null) {
                String space = strTokens.nextToken();
                String hmsValue = strTokens.nextToken();
                timestampValueStr = val + " " + hmsValue;
                continue;
            }
            if (key.equalsIgnoreCase("timezone") && val != null) {
                timezoneValueStr = "GMT" + val;
                continue;
            }
            if (!key.equalsIgnoreCase("drain_timeout") || val == null) continue;
            try {
                this.setDrainTimeout(Integer.parseInt(val));
            }
            catch (NumberFormatException nfe) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid drain_timeout " + nfe.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if (timestampValueStr == null && timezoneValueStr == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Older server, no timestamp/timezone in HA event");
        } else {
            SimpleDateFormat format = timezoneValueStr != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            Date ts = null;
            String tsWithZoneString = timezoneValueStr != null ? timestampValueStr + " " + timezoneValueStr : timestampValueStr;
            try {
                ts = format.parse(tsWithZoneString);
            }
            catch (ParseException pe) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + tsWithZoneString);
                this.setValidity(false);
                return;
            }
            if (ts == null) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + tsWithZoneString);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(ts);
            this.setTimeZone(timezoneValueStr);
        }
        strTokens = null;
    }

    static {
        try {
            $$$methodRef$$$1 = ONSDatabaseFailoverEvent.class.getDeclaredConstructor(String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSDatabaseFailoverEvent.class.getDeclaredConstructor(Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

