/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleConnectionPoolDataSourceConnectionFactoryAdapter
extends ConnectionPoolDataSourceConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource) throws UniversalConnectionPoolException {
        super(connectionPoolDataSource);
        this.initializeUrlFromConnectionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        ClioSupport.ilogFinest(null, null, null, null, "Oracle Connection Pool Datasource CFA: about to create connection");
        String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
        Properties props = null;
        PooledConnection connection = null;
        if (null == instanceName || "".equals(instanceName) || !(this.m_connectionPoolDataSource instanceof OracleConnectionPoolDataSource)) {
            ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
            connection = (PooledConnection)super.createConnection(connectionRequestInfo);
        } else {
            ConnectionPoolDataSource connectionPoolDataSource = this.m_connectionPoolDataSource;
            synchronized (connectionPoolDataSource) {
                try {
                    props = ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).getConnectionProperties();
                    if (null != props) {
                        props.setProperty("oracle.jdbc.targetInstanceName", instanceName);
                        ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).setConnectionProperties(props);
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + instanceName);
                    connection = (PooledConnection)super.createConnection(connectionRequestInfo);
                }
                catch (SQLException e2) {
                    ClioSupport.ilogThrowing(null, null, null, null, e2);
                    UCPErrorHandler.throwUniversalConnectionPoolException(257, e2);
                }
                finally {
                    if (null != props) {
                        props.remove("oracle.jdbc.targetInstanceName");
                        try {
                            ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).setConnectionProperties(props);
                        }
                        catch (SQLException e3) {
                            ClioSupport.ilogThrowing(null, null, null, null, e3);
                            UCPErrorHandler.throwUniversalConnectionPoolException(257, e3);
                        }
                    }
                }
            }
        }
        return connection;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        return new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_connectionPoolDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m4 = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m4.invoke((Object)this.m_connectionPoolDataSource, new Object[0]);
            ClioSupport.ilogFinest(null, null, null, null, "initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    @Override
    public void setUrl(String url) {
        Class<?> dsClass = this.m_connectionPoolDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m4 = cls.getMethod("setURL", String.class);
            m4.invoke((Object)this.m_connectionPoolDataSource, url);
        }
        catch (Exception exc) {
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
    }

    static {
        try {
            $$$methodRef$$$4 = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(ConnectionPoolDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("initializeUrlFromConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createPooledConnection", Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

