/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.sql.SQLUtil;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.ListSuperShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RangeSuperShardKeys;
import oracle.ucp.routing.ShardRoutingCacheBase;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.MappedLongAdder;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.routing")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public abstract class ShardRoutingCache
extends ShardRoutingCacheBase
implements DataDependentRoutingCache {
    private final Map<L2RoutingKey, List<Chunk>> l2RoutingCache = new ConcurrentHashMap<L2RoutingKey, List<Chunk>>();
    private final Map<OracleShardingKey, OracleShardingKey> lookupKeyCache = new ConcurrentHashMap<OracleShardingKey, OracleShardingKey>();
    protected final ChunkEventHandler chunkEventHandler = this.prepareChunkEventHandler();
    protected final AtomicReference<ShardingMetadata> shardingMetadata = new AtomicReference<Object>(null);
    private final MappedLongAdder<String> shardConnectionCounter = new MappedLongAdder();
    private final MappedLongAdder<String> shardPendingConnectionCounter = new MappedLongAdder();
    private final Map<String, String> currentActiveShards = new ConcurrentHashMap<String, String>();
    private static final short DB_VERSION_19c = 19000;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    private RoutingKey routingKeysForVersionedChunk(String chunkName) {
        Optional keys = this.keyForChunk(chunkName).stream().findFirst();
        return keys.isPresent() ? (RoutingKey)keys.get() : null;
    }

    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        L2RoutingKey l2Key = new L2RoutingKey(shardingKey, superKey);
        if (this.l2RoutingCache.containsKey(l2Key)) {
            return true;
        }
        OracleShardingKey shardKeyToLookup = this.lookupKey(shardingKey);
        NavigableSet<RoutingKey> keySet = this.allKeys();
        for (RoutingKey routingKey : keySet) {
            if (!routingKey.containsShardingKey(shardKeyToLookup, superKey)) continue;
            return true;
        }
        return false;
    }

    private Chunk update(RoutingKey routingKey, String chunkName) {
        if (routingKey == null || chunkName == null || chunkName.equals("")) {
            return null;
        }
        Chunk newChunk = new Chunk(chunkName);
        Chunk cachedChunk = this.get(routingKey);
        if (cachedChunk != null && !cachedChunk.name().equals(chunkName)) {
            ClioSupport.ilogFinest(null, null, null, null, "Replace chunk for key:" + routingKey + " with new Chunk:" + chunkName + " , (old chunk:" + cachedChunk.name() + ")");
            this.replace(routingKey, cachedChunk, newChunk);
            this.l2RoutingCache.clear();
            return cachedChunk;
        }
        if (cachedChunk == null) {
            RoutingKey chunkRoutingKey = this.routingKeysForVersionedChunk(chunkName);
            if (this.putIfAbsent(routingKey, newChunk) == null) {
                this.l2RoutingCache.clear();
                if (chunkRoutingKey != null && !routingKey.equals(chunkRoutingKey)) {
                    int maxVersion = ((Chunk)this.chunks(chunkName).stream().max((o1, o2) -> o1.version() - o2.version()).get()).version();
                    this.get(chunkRoutingKey).setVersion(maxVersion + 1);
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk keys:" + chunkRoutingKey + " has split,hence updated chunk name to:" + this.get(chunkRoutingKey).name());
                }
            }
        }
        return this.get(routingKey);
    }

    @Override
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo cri) throws SQLException {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        OracleConnection oConn = (OracleConnection)connection;
        if (oConn != null && jdbcCri.getShardingKey() != null) {
            String chunk = this.getChunkNameForKey(jdbcCri);
            oConn.setChunkInfo(key, superKey, chunk);
        }
        if (key != null) {
            this.lookupKeyCache.remove(key);
        }
        this.l2RoutingCache.remove(new L2RoutingKey(key, superKey));
    }

    protected void cleanup() {
        Set<Chunk> chunksToRemove = this.noInstsChunks();
        chunksToRemove.forEach(p2 -> this.remove((Chunk)p2));
        if (chunksToRemove.size() > 0) {
            this.l2RoutingCache.clear();
            ClioSupport.ilogFinest(null, null, null, null, "Cleaned up shard routing cache!");
        }
    }

    protected void clearCache() {
        this.lookupKeyCache.clear();
        this.l2RoutingCache.clear();
        super.clear();
    }

    protected boolean isMaxPerShardReached(ServiceMember member) {
        String shardUniqueId = member.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return false;
        }
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return this.shardConnectionCounter.get(shardUniqueId).sum() + this.shardPendingConnectionCounter.get(shardUniqueId).sum() >= (long)maxPerShard;
    }

    boolean isMaxPerShardConfigured() {
        int maxPerShard = this.service().connectionSource().limits().getMaxPerShard();
        return maxPerShard < Integer.MAX_VALUE;
    }

    @Override
    public void onConnectionRequest(ServiceMember instance) {
        String shardUniqueId = instance.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(shardUniqueId).increment();
    }

    @Override
    public void onConnectionRequestComplete(ServiceMember instance) {
        String shardUniqueId = instance.dbUniqueId();
        if (shardUniqueId == null || shardUniqueId.equals("")) {
            return;
        }
        this.shardPendingConnectionCounter.get(shardUniqueId).decrement();
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        return this.instancesToGrow(cri).stream().sorted((i1, i2) -> i1.activeCount.get() - i2.activeCount.get()).findFirst().orElse(null);
    }

    @Override
    public void onConnectionCreation(Connection connection, ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        try {
            Chunk connChunk;
            String serviceName = this.service().connectionSource().defaultServiceName();
            if (this.shardingMetadata.get() == null) {
                this.shardingMetadata.compareAndSet(null, ShardRoutingCache.fetchShardingMetadata(connection, serviceName));
            }
            ServiceMember connInstance = this.getConnectionInstance(connection);
            String shardUniqueId = connInstance.dbUniqueId();
            String shardName = ShardRoutingCache.getShardNameFromConnection(connection);
            if (this.isMaxPerShardReached(connInstance)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(389);
            }
            this.shardConnectionCounter.get(shardUniqueId).increment();
            this.currentActiveShards.putIfAbsent(shardUniqueId, shardName);
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            ClioSupport.ilogFinest(null, null, null, null, String.format("\n\tCreating connection with OracleShardingKey(%s,%s)\n", jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey()));
            if (!this.allInstances(jdbcCri).contains(connInstance)) {
                this.buildTopologyForInstance(connection, serviceName);
                return;
            }
            if (jdbcCri.getShardingKey() == null) {
                return;
            }
            String connChunkName = ShardRoutingCache.fetchDatabaseChunkName(connection);
            String topoChunkName = this.getChunkNameForKey(jdbcCri);
            if (topoChunkName == null) {
                this.buildTopologyForInstance(connection, serviceName);
                return;
            }
            if (connChunkName == null) {
                return;
            }
            RoutingKey routingKey = this.routingKeysForVersionedChunk(connChunkName);
            Chunk.Metadata metadata = null;
            if (routingKey == null) {
                metadata = ShardRoutingCache.fetchChunkMetadata(connection, connChunkName, serviceName);
                if (metadata == null) {
                    return;
                }
                routingKey = this.makeRoutingKey(metadata);
            }
            if ((connChunk = this.update(routingKey, connChunkName)) != null && !connChunk.hasInstance(connInstance)) {
                if (metadata == null) {
                    metadata = ShardRoutingCache.fetchChunkMetadata(connection, connChunkName, serviceName);
                }
                connChunk.addInstanceWithPriority(connInstance, metadata.priority);
                connChunk.setAffinitizedInstId(metadata.affinitizedInstId);
                connChunk.setId(metadata.chunkId);
                connChunk.setUniqueId(metadata.chunkUniqueId);
                connChunk.addShardInfo(metadata.shardName, metadata.priority);
            }
        }
        catch (SQLException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
    }

    private static String getShardNameFromConnection(Connection conn) throws SQLException {
        return ((OracleConnection)conn).getServerSessionInfo().getProperty("AUTH_DBNAME", "");
    }

    protected ServiceMember getConnectionInstance(Connection conn) {
        ServiceMember member = null;
        try {
            Properties props = ((OracleConnection)conn).getServerSessionInfo();
            if (this.service() != null) {
                member = this.service().getMember(props.getProperty("INSTANCE_NAME"), props.getProperty("DATABASE_NAME"), props.getProperty("SERVER_HOST"), props.getProperty("SERVICE_NAME"));
            }
            if (member == null) {
                member = new ServiceMember(props, this.service());
            }
        }
        catch (SQLException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
        return member;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchDatabaseChunkName(Connection oConn) {
        if (oConn == null) {
            return null;
        }
        String sql = "select sys_context('userenv', 'chunk_id') from dual";
        try (Statement stmt = oConn.createStatement();
             ResultSet rs = stmt.executeQuery("select sys_context('userenv', 'chunk_id') from dual");){
            if (!rs.next()) return null;
            String dbChunk = rs.getString(1);
            String string = dbChunk != null ? dbChunk.toLowerCase() : null;
            return string;
        }
        catch (SQLException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
        return null;
    }

    private String getChunkNameForKey(ConnectionRetrievalInfo cri) {
        List<Chunk> chunks = this.chunks(cri);
        if (chunks == null || chunks.size() == 0) {
            return null;
        }
        return chunks.get(0).absoluteName();
    }

    @Override
    public void onConnectionClosure(Connection connection) {
        String shardUniqueId = this.getConnectionInstance(connection).dbUniqueId();
        this.shardConnectionCounter.get(shardUniqueId).decrement();
    }

    protected void buildTopologyForInstance(Connection connection, String serviceName) {
        try {
            ServiceMember connInstance = this.getConnectionInstance(connection);
            ClioSupport.ilogFinest(null, null, null, null, "Building topo for Instance " + connInstance.name());
            List<Chunk.Metadata> chunkInfoList = ShardRoutingCache.fetchInstanceChunksMetadata(connection, serviceName);
            for (Chunk.Metadata chunkInfo : chunkInfoList) {
                String chunkName = chunkInfo.chunkName;
                RoutingKey key = this.makeRoutingKey(chunkInfo);
                if (this.update(key, chunkName) == null) continue;
                Chunk connChunk = this.get(key);
                connChunk.addInstanceWithPriority(connInstance, chunkInfo.priority);
                connChunk.setAffinitizedInstId(chunkInfo.affinitizedInstId);
                connChunk.setId(chunkInfo.chunkId);
                connChunk.setUniqueId(chunkInfo.chunkUniqueId);
                if (chunkInfo.shardName == null) continue;
                connChunk.addShardInfo(chunkInfo.shardName, chunkInfo.priority);
            }
        }
        catch (SQLException e2) {
            ClioSupport.ilogThrowing(null, null, null, null, e2);
        }
    }

    protected abstract Service service();

    protected ShardingMetadata shardingMetadata() {
        return this.shardingMetadata.get();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RoutingKey makeRoutingKey(Chunk.Metadata chunkInfo) throws SQLException {
        void var6_9;
        SuperShardingKeys superShardingKeys;
        ShardingMetadata sm = this.shardingMetadata();
        ShardingMetadata.ShardingType ssType = this.shardingMetadata().getSuperShardingType();
        if (ssType != ShardingMetadata.ShardingType.NONE) {
            if (ssType == ShardingMetadata.ShardingType.LIST) {
                superShardingKeys = new ListSuperShardingKeys(OracleShardingKeyImpl.decodeKeys(chunkInfo.superKeyHigh, sm, true, true));
            } else {
                if (ssType != ShardingMetadata.ShardingType.RANGE) throw new IllegalStateException("Super Shard Type in database not recognized");
                superShardingKeys = new RangeSuperShardKeys(OracleShardingKeyImpl.decodeKeys(chunkInfo.superKeyHigh, sm, true, true).get(0), OracleShardingKeyImpl.decodeKeys(chunkInfo.superKeyLow, sm, true, false).get(0));
            }
        } else {
            superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        }
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        if (sType == ShardingMetadata.ShardingType.LIST) {
            ListShardingKeys listShardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyHigh, sm, false, true));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else if (sType == ShardingMetadata.ShardingType.RANGE) {
            RangeShardingKeys rangeShardingKeys = new RangeShardingKeys(OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyHigh, sm, false, true).get(0), OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyLow, sm, false, false).get(0));
            return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
        } else {
            if (sType != ShardingMetadata.ShardingType.HASH) throw new IllegalStateException("Shard Type in database not recognized");
            HashRangeShardingKeys hashRangeShardingKeys = new HashRangeShardingKeys(OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyHigh, sm, false, true).get(0), OracleShardingKeyImpl.decodeKeys(chunkInfo.shardKeyLow, sm, false, false).get(0));
        }
        return new RoutingKey((ShardingKeys)var6_9, superShardingKeys);
    }

    @Override
    public void startEventHandler(ONSDriver onsDriver) throws UniversalConnectionPoolException {
        if (onsDriver != null) {
            this.chunkEventHandler.start(onsDriver);
        }
    }

    private Chunk matchingChunk(String chunkName, ServiceMember instance) {
        Optional chunks = this.chunks(instance, chunkName).stream().findFirst();
        return chunks.isPresent() ? (Chunk)chunks.get() : null;
    }

    private boolean hasMatchingChunk(String chunkName, ServiceMember instance) {
        return this.chunks(instance, chunkName).size() > 0;
    }

    private ChunkEventHandler prepareChunkEventHandler() {
        return new ChunkEventHandler(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected void onEvent(ChunkEventHandler.Event event) {
                ServiceMember instanceToLookup;
                if (event.eventType().equalsIgnoreCase("routing")) {
                    ShardRoutingCache.this.clearCache();
                    return;
                }
                if (!event.eventType().equalsIgnoreCase("chunk")) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not chunk event , ignoring it");
                    return;
                }
                if (event.chunkName() == null || event.chunkName().length() <= 0) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event: Chunk name is empty, ignoring it");
                    return;
                }
                ServiceMember eventInst = ShardRoutingCache.this.service().getMember(event.instanceName(), event.database(), ShardRoutingCache.this.service().name());
                if (eventInst == null) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event: Instance name not known or null, ignoring it");
                    return;
                }
                ServiceMember serviceMember = instanceToLookup = event.status() == ChunkEventHandler.Event.Status.UP ? null : eventInst;
                if (!ShardRoutingCache.this.hasMatchingChunk(event.chunkName(), instanceToLookup)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Not applicable chunk event:Chunk not known, ignoring it");
                    return;
                }
                Chunk chunk = ShardRoutingCache.this.matchingChunk(event.chunkName(), instanceToLookup);
                if (chunk == null) {
                    return;
                }
                boolean isReadOnlyAllowed = Boolean.valueOf(Util.getReadOnlyInstanceAllowed());
                if ((event.status() == ChunkEventHandler.Event.Status.DOWN || !isReadOnlyAllowed && event.status() == ChunkEventHandler.Event.Status.READONLY) && chunk.hasInstance(eventInst)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk Event Handler : Removed Instance " + eventInst + " for Chunk :" + chunk.name());
                    chunk.removeInstance(eventInst);
                }
                if (event.status() == ChunkEventHandler.Event.Status.UP) {
                    chunk.addInstanceWithPriority(eventInst, event.priority());
                }
                if (event.status() == ChunkEventHandler.Event.Status.SPLIT && chunk.hasInstance(eventInst)) {
                    ClioSupport.ilogFinest(null, null, null, null, "Chunk Event Handler : Removed Instance " + eventInst + " for Chunk :" + chunk.name());
                    int priority = chunk.instancePriority(eventInst);
                    chunk.removeInstance(eventInst);
                    if (ShardRoutingCache.this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
                        RoutingKey splitKey2;
                        RoutingKey key = ShardRoutingCache.this.routingKeysForVersionedChunk(chunk.name());
                        OracleShardingKeyImpl boundary = new OracleShardingKeyBuilderImpl().subkey(event.hashSplitBoundary(), OracleType.NUMBER).build();
                        List<ShardingKeys> splitKeys = ((HashRangeShardingKeys)key.shardingKeys).split(boundary);
                        if (splitKeys.size() <= 0 && splitKeys.size() != 2) {
                            ClioSupport.ilogWarning(null, null, null, null, "Hash boundary could not be used to split the chunk");
                            ShardRoutingCache.this.cleanup();
                            return;
                        }
                        RoutingKey splitKey1 = new RoutingKey(splitKeys.get(0), key.superShardingKeys);
                        if (ShardRoutingCache.this.update(splitKey1, event.chunkName()) != null) {
                            ShardRoutingCache.this.get(splitKey1).addInstanceWithPriority(eventInst, priority);
                            ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + splitKey1 + " for Chunk:" + ShardRoutingCache.this.get(splitKey1));
                        }
                        if (ShardRoutingCache.this.update(splitKey2 = new RoutingKey(splitKeys.get(1), key.superShardingKeys), event.newChunkName()) != null) {
                            ShardRoutingCache.this.get(splitKey2).addInstanceWithPriority(eventInst, priority);
                            ClioSupport.ilogFinest(null, null, null, null, " Added Routing key: " + splitKey2 + " for Chunk:" + ShardRoutingCache.this.get(splitKey2));
                        }
                    }
                }
                ShardRoutingCache.this.cleanup();
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(ShardRoutingCache.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("onEvent", ChunkEventHandler.Event.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public void onHAEvent(FailoverDriver.Event haEvent) {
        ServiceMember eventInst = this.service().getMember(haEvent.instance(), haEvent.database(), haEvent.host(), haEvent.serviceName());
        if (eventInst != null) {
            this.chunks(eventInst).forEach(p2 -> this.remove((Chunk)p2));
        }
        this.cleanup();
    }

    @Override
    public boolean selected(CoreConnection connection, Set<ServiceMember> instanceSet) {
        if (instanceSet == null || instanceSet.size() <= 0) {
            return false;
        }
        return instanceSet.contains(connection.serviceMember());
    }

    protected List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return new ArrayList<Chunk>();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (key == null) {
            return null;
        }
        if (this.shardingMetadata() == null) {
            return null;
        }
        L2RoutingKey l2Key = new L2RoutingKey(key, superKey);
        List<Chunk> chunks = this.l2RoutingCache.get(l2Key);
        if (chunks != null) {
            return chunks;
        }
        OracleShardingKey lookupKey = this.lookupKey(key);
        List<Chunk> chunksForKey = this.keyToChunkMap().entrySet().stream().filter(cacheEntry -> this.entryContainsRoutingKey((Map.Entry<RoutingKey, Chunk>)cacheEntry, key, lookupKey, superKey)).map(cacheEntry -> (Chunk)cacheEntry.getValue()).collect(Collectors.toList());
        if (!chunksForKey.isEmpty()) {
            this.l2RoutingCache.put(l2Key, chunksForKey);
        }
        return chunksForKey;
    }

    protected boolean entryContainsRoutingKey(Map.Entry<RoutingKey, Chunk> routingTableRow, OracleShardingKey shardingKey, OracleShardingKey lookupKey, OracleShardingKey superKey) {
        return routingTableRow.getKey().containsShardingKey(lookupKey, superKey);
    }

    private OracleShardingKey lookupKey(OracleShardingKey key) {
        if (key == null) {
            return null;
        }
        OracleShardingKey lookupKey = key;
        if (this.shardingMetadata().getShardingType() == ShardingMetadata.ShardingType.HASH) {
            OracleShardingKey cachedLookupKey = this.lookupKeyCache.get(key);
            if (cachedLookupKey != null) {
                return cachedLookupKey;
            }
            long keyHash = ((OracleShardingKeyImpl)key).shardKeyOraHash(this.shardingMetadata());
            lookupKey = new OracleShardingKeyBuilderImpl().subkey(keyHash, OracleType.NUMBER).oraHash(keyHash).build();
            this.lookupKeyCache.putIfAbsent(key, lookupKey);
        }
        return lookupKey;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (jdbcCri.getShardingKey() == null) {
            return true;
        }
        if (this.shardingMetadata.get() == null) {
            return false;
        }
        OracleShardingKey shardKey = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        ShardingMetadata metadata = this.shardingMetadata.get();
        if (!((OracleShardingKeyImpl)shardKey).isValid(metadata)) {
            throw new IllegalArgumentException("Sharding Keys provided do not match the sharded database metadata");
        }
        if (superKey != null && !((OracleShardingKeyImpl)superKey).isValid(metadata)) {
            throw new IllegalArgumentException("Super Sharding Keys provided do not match the sharded database metadata");
        }
        return this.hasKeyMapped(shardKey, superKey);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo cri) {
        Set<ServiceMember> instances = this.allPriorityInstances(cri);
        if (instances != null && instances.size() >= 0) {
            return instances.stream().filter(e2 -> !this.isMaxPerShardReached((ServiceMember)e2)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasInstanceToGrow(ConnectionRetrievalInfo cri) {
        Set<ServiceMember> instances = this.allPriorityInstances(cri);
        if (instances != null && instances.size() == 0) {
            return true;
        }
        return instances.stream().anyMatch(sm -> !this.isMaxPerShardReached((ServiceMember)sm));
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c2 -> {
                Set<ServiceMember> priorityInstances = c2.priorityInstances();
                if (priorityInstances != null && priorityInstances.size() > 0) {
                    allInstances.addAll(priorityInstances);
                }
            });
        }
        return allInstances;
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        HashSet<ServiceMember> allInstances = new HashSet<ServiceMember>();
        if (reqChunks != null) {
            reqChunks.stream().forEach(c2 -> {
                Set<ServiceMember> instanceSet = c2.instances();
                if (instanceSet != null && instanceSet.size() > 0) {
                    allInstances.addAll(instanceSet);
                }
            });
        }
        return allInstances;
    }

    @Override
    @DisableTrace
    public String cacheEntries() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("\n\t\t SHARD ROUTING CACHE \n\n \nSUPER SHARDING KEY\t\t SHARDING KEY\t\t\t\t\t\t\tCHUNK NAME \t\tINSTANCES\n\n" + this.keyToChunkMap().entrySet().stream().map(entry -> String.format("%-70s", entry.getKey()) + "\t\t" + ((Chunk)entry.getValue()).toString()).collect(Collectors.joining("\n")));
        return infoStr.toString();
    }

    @Override
    @DisableTrace
    public String metadataInfo() {
        StringBuffer infoStr = new StringBuffer();
        infoStr.append("\t\t SHARDING INFO:\n\tSuper Sharding Type :" + this.shardingMetadata().getSuperShardingType().toString());
        infoStr.append("\n\tSharding Type :" + this.shardingMetadata().getShardingType().toString());
        return infoStr.toString();
    }

    @Override
    public void destroy() {
        this.l2RoutingCache.clear();
        this.clear();
        this.chunkEventHandler.stop();
    }

    @Override
    public void onError(ConnectionRetrievalInfo cri, ServiceMember instance) {
        String chunkName = this.getChunkNameForKey(cri);
        Chunk chunk = this.matchingChunk(chunkName, instance);
        if (chunk != null) {
            chunk.removeInstance(instance);
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
        if (key != null) {
            this.lookupKeyCache.remove(key);
        }
        this.l2RoutingCache.remove(new L2RoutingKey(key, superKey));
        this.cleanup();
    }

    public String shardConnectionStats() {
        return "Shard Connection Stats for Service (<Shards:{connection count}) " + this.service().name() + this.currentActiveShards + ":{" + this.shardConnectionCounter + '}';
    }

    public boolean hasAvailableConnectionForKey(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (this.hasKeyMapped(jdbcCri.getShardingKey(), jdbcCri.getSuperShardingKey())) {
            return this.allInstances(jdbcCri).stream().anyMatch(inst -> inst.activeCount.get() - inst.borrowedCount.get() > 0);
        }
        return false;
    }

    private static List<Chunk.Metadata> fetchInstanceChunksMetadata(Connection oConn, String serviceName) throws SQLException {
        if (oConn == null) {
            return null;
        }
        ArrayList<Chunk.Metadata> chunkInfoList = new ArrayList<Chunk.Metadata>();
        short dbVersion = ((OracleConnection)oConn).getVersionNumber();
        String sql = dbVersion >= 19000 ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?) and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS WHERE SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        try (PreparedStatement stmt = oConn.prepareStatement(sql);){
            if (dbVersion >= 19000) {
                stmt.setString(1, serviceName);
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Chunk.Metadata chunkInfo = new Chunk.Metadata();
                    chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                    Blob shardKeyLowBlob = rs.getBlob("SHARD_KEY_LOW");
                    chunkInfo.shardKeyLow = shardKeyLowBlob != null ? shardKeyLowBlob.getBinaryStream() : null;
                    Blob shardKeyHighBlob = rs.getBlob("SHARD_KEY_HIGH");
                    chunkInfo.shardKeyHigh = shardKeyHighBlob != null ? shardKeyHighBlob.getBinaryStream() : null;
                    Blob superKeyLow = rs.getBlob("GROUP_KEY_LOW");
                    chunkInfo.superKeyLow = superKeyLow != null ? superKeyLow.getBinaryStream() : null;
                    Blob superKeyHigh = rs.getBlob("GROUP_KEY_HIGH");
                    chunkInfo.superKeyHigh = superKeyHigh != null ? superKeyHigh.getBinaryStream() : null;
                    chunkInfo.priority = rs.getInt("PRIORITY");
                    chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                    chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                    chunkInfo.shardName = rs.getString("SHARD_NAME");
                    chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                    chunkInfoList.add(chunkInfo);
                }
            }
        }
        return chunkInfoList;
    }

    private static Chunk.Metadata fetchChunkMetadata(Connection oConn, String chunkName, String serviceName) throws SQLException {
        Chunk.Metadata chunkInfo;
        if (oConn == null) {
            return null;
        }
        short dbVersion = ((OracleConnection)oConn).getVersionNumber();
        String sql = dbVersion >= 19000 ? "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)" : "select CHUNK_NAME, SHARD_KEY_LOW, SHARD_KEY_HIGH, GROUP_KEY_LOW ,  GROUP_KEY_HIGH, PRIORITY,  INST_ID, CHUNK_ID, SHARD_NAME, CHUNK_UNIQUE_ID from LOCAL_CHUNKS where lower(CHUNK_NAME) like '" + chunkName.toLowerCase() + "' and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL";
        try (PreparedStatement stmt = oConn.prepareStatement(sql);){
            if (dbVersion >= 19000) {
                stmt.setString(1, serviceName);
            }
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    chunkInfo = new Chunk.Metadata();
                    chunkInfo.chunkName = rs.getString("CHUNK_NAME").toLowerCase();
                    chunkInfo.shardKeyLow = rs.getBlob("SHARD_KEY_LOW") != null ? rs.getBlob(2).getBinaryStream() : null;
                    InputStream inputStream = chunkInfo.shardKeyHigh = rs.getBlob("SHARD_KEY_HIGH") != null ? rs.getBlob(3).getBinaryStream() : null;
                    if (rs.getBlob(4) != null) {
                        chunkInfo.superKeyLow = rs.getBlob("GROUP_KEY_LOW").getBinaryStream();
                    }
                    if (rs.getBlob(5) != null) {
                        chunkInfo.superKeyHigh = rs.getBlob("GROUP_KEY_HIGH").getBinaryStream();
                    }
                    chunkInfo.priority = rs.getInt("PRIORITY");
                    chunkInfo.affinitizedInstId = rs.getInt("INST_ID");
                    chunkInfo.chunkId = rs.getInt("CHUNK_ID");
                    chunkInfo.shardName = rs.getString("SHARD_NAME");
                    chunkInfo.chunkUniqueId = rs.getInt("CHUNK_UNIQUE_ID");
                } else {
                    chunkInfo = null;
                }
            }
        }
        return chunkInfo;
    }

    protected static ShardingMetadata fetchShardingMetadata(Connection oConn, String serviceName) throws SQLException {
        ShardingMetadata shardingMetadata;
        block58: {
            String sqlColTypes;
            String sqlTypes;
            if (oConn == null) {
                return null;
            }
            short dbVersion = ((OracleConnection)oConn).getVersionNumber();
            if (dbVersion >= 19000) {
                sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
                sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS  WHERE TABFAM_ID=(SELECT TABFAM_ID FROM  LOCAL_TABLE_FAMILY_SERVICES WHERE SERVICE_NAME=?)";
            } else {
                sqlTypes = "select GROUP_TYPE, GROUP_COL_NUM, SHARD_TYPE, SHARD_COL_NUM, DEF_VERSION from LOCAL_CHUNK_TYPES ";
                sqlColTypes = "select SHARD_LEVEL, COL_NAME, COL_IDX_IN_KEY, EFF_TYPE , CHARACTER_SET from LOCAL_CHUNK_COLUMNS ";
            }
            try (PreparedStatement stmt = oConn.prepareStatement(sqlTypes);){
                if (dbVersion >= 19000) {
                    stmt.setString(1, serviceName);
                }
                try (ResultSet rsTypes = stmt.executeQuery();){
                    if (rsTypes.next()) {
                        String superTypeStr = rsTypes.getString("GROUP_TYPE");
                        ShardingMetadata.ShardingType superType = ShardingMetadata.ShardingType.valueOf(superTypeStr);
                        String shardTypeStr = rsTypes.getString("SHARD_TYPE");
                        ShardingMetadata.ShardingType shardType = ShardingMetadata.ShardingType.valueOf(shardTypeStr);
                        int metaVersion = rsTypes.getInt("DEF_VERSION");
                        ArrayList<ShardingMetadata.SubKeyMetadata> colInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        ArrayList<ShardingMetadata.SubKeyMetadata> colGrpInfos = new ArrayList<ShardingMetadata.SubKeyMetadata>();
                        try (PreparedStatement stmt1 = oConn.prepareStatement(sqlColTypes);){
                            if (dbVersion >= 19000) {
                                stmt1.setString(1, serviceName);
                            }
                            try (ResultSet rsCols = stmt1.executeQuery();){
                                while (rsCols.next()) {
                                    int shardLevel = rsCols.getInt("SHARD_LEVEL");
                                    ShardingMetadata.SubKeyMetadata subKeyMetadata = new ShardingMetadata.SubKeyMetadata(rsCols.getInt("COL_IDX_IN_KEY"), SQLUtil.getExternalType(rsCols.getInt("EFF_TYPE")), rsCols.getInt("CHARACTER_SET"));
                                    if (shardLevel == 0) {
                                        colGrpInfos.add(subKeyMetadata);
                                        continue;
                                    }
                                    if (shardLevel == 1) {
                                        colInfos.add(subKeyMetadata);
                                        continue;
                                    }
                                    throw new IllegalStateException("Invalid Shard Key Level in database");
                                }
                            }
                        }
                        shardingMetadata = new ShardingMetadata(metaVersion, shardType, superType, colInfos, colGrpInfos);
                        break block58;
                    }
                    shardingMetadata = null;
                }
            }
        }
        return shardingMetadata;
    }

    static {
        try {
            $$$methodRef$$$57 = ShardRoutingCache.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$56 = ShardRoutingCache.class.getDeclaredMethod("access$600", ShardRoutingCache.class, RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$55 = ShardRoutingCache.class.getDeclaredMethod("access$300", ShardRoutingCache.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$54 = ShardRoutingCache.class.getDeclaredMethod("access$200", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$53 = ShardRoutingCache.class.getDeclaredMethod("access$100", ShardRoutingCache.class, String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$52 = ShardRoutingCache.class.getDeclaredMethod("lambda$update$0", Chunk.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$51 = ShardRoutingCache.class.getDeclaredMethod("lambda$cleanup$1", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$50 = ShardRoutingCache.class.getDeclaredMethod("lambda$getBestInstanceToGrow$2", ServiceMember.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$49 = ShardRoutingCache.class.getDeclaredMethod("lambda$onHAEvent$3", Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$48 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$4", OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$47 = ShardRoutingCache.class.getDeclaredMethod("lambda$chunks$5", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$46 = ShardRoutingCache.class.getDeclaredMethod("lambda$instancesToGrow$6", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$45 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasInstanceToGrow$7", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$44 = ShardRoutingCache.class.getDeclaredMethod("lambda$allPriorityInstances$8", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$43 = ShardRoutingCache.class.getDeclaredMethod("lambda$allInstances$9", Set.class, Chunk.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$42 = ShardRoutingCache.class.getDeclaredMethod("lambda$cacheEntries$10", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$41 = ShardRoutingCache.class.getDeclaredMethod("lambda$hasAvailableConnectionForKey$11", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$40 = ShardRoutingCache.class.getDeclaredMethod("fetchShardingMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$39 = ShardRoutingCache.class.getDeclaredMethod("fetchChunkMetadata", Connection.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$38 = ShardRoutingCache.class.getDeclaredMethod("fetchInstanceChunksMetadata", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$37 = ShardRoutingCache.class.getDeclaredMethod("hasAvailableConnectionForKey", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$36 = ShardRoutingCache.class.getDeclaredMethod("shardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$35 = ShardRoutingCache.class.getDeclaredMethod("onError", ConnectionRetrievalInfo.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$34 = ShardRoutingCache.class.getDeclaredMethod("destroy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$33 = ShardRoutingCache.class.getDeclaredMethod("allInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$32 = ShardRoutingCache.class.getDeclaredMethod("allPriorityInstances", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$31 = ShardRoutingCache.class.getDeclaredMethod("hasInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$30 = ShardRoutingCache.class.getDeclaredMethod("instancesToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$29 = ShardRoutingCache.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$28 = ShardRoutingCache.class.getDeclaredMethod("lookupKey", OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$27 = ShardRoutingCache.class.getDeclaredMethod("entryContainsRoutingKey", Map.Entry.class, OracleShardingKey.class, OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$26 = ShardRoutingCache.class.getDeclaredMethod("chunks", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$25 = ShardRoutingCache.class.getDeclaredMethod("selected", CoreConnection.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$24 = ShardRoutingCache.class.getDeclaredMethod("onHAEvent", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$23 = ShardRoutingCache.class.getDeclaredMethod("prepareChunkEventHandler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$22 = ShardRoutingCache.class.getDeclaredMethod("hasMatchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$21 = ShardRoutingCache.class.getDeclaredMethod("matchingChunk", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$20 = ShardRoutingCache.class.getDeclaredMethod("startEventHandler", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$19 = ShardRoutingCache.class.getDeclaredMethod("makeRoutingKey", Chunk.Metadata.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$18 = ShardRoutingCache.class.getDeclaredMethod("shardingMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$17 = ShardRoutingCache.class.getDeclaredMethod("buildTopologyForInstance", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$16 = ShardRoutingCache.class.getDeclaredMethod("onConnectionClosure", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$15 = ShardRoutingCache.class.getDeclaredMethod("getChunkNameForKey", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$14 = ShardRoutingCache.class.getDeclaredMethod("fetchDatabaseChunkName", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$13 = ShardRoutingCache.class.getDeclaredMethod("getConnectionInstance", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$12 = ShardRoutingCache.class.getDeclaredMethod("getShardNameFromConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$11 = ShardRoutingCache.class.getDeclaredMethod("onConnectionCreation", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$10 = ShardRoutingCache.class.getDeclaredMethod("getBestInstanceToGrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$9 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequestComplete", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$8 = ShardRoutingCache.class.getDeclaredMethod("onConnectionRequest", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$7 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardConfigured", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$6 = ShardRoutingCache.class.getDeclaredMethod("isMaxPerShardReached", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$5 = ShardRoutingCache.class.getDeclaredMethod("clearCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$4 = ShardRoutingCache.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$3 = ShardRoutingCache.class.getDeclaredMethod("onConnectionBorrow", Connection.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$2 = ShardRoutingCache.class.getDeclaredMethod("update", RoutingKey.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$1 = ShardRoutingCache.class.getDeclaredMethod("hasKeyMapped", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
        try {
            $$$methodRef$$$0 = ShardRoutingCache.class.getDeclaredMethod("routingKeysForVersionedChunk", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.routing");
    }

    private static class L2RoutingKey {
        private final OracleShardingKey key;
        private final OracleShardingKey superKey;
        private final int hashCode;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        L2RoutingKey(OracleShardingKey k2, OracleShardingKey sk) {
            this.key = k2;
            this.superKey = sk;
            this.hashCode = (this.key != null ? this.key.hashCode() : 0) + (this.superKey != null ? this.superKey.hashCode() : 0);
        }

        @DisableTrace
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            L2RoutingKey other = (L2RoutingKey)obj;
            if (this.key == null) {
                return false;
            }
            if (this.key.equals(other.key)) {
                if (this.superKey == null && other.superKey == null) {
                    return true;
                }
                if (this.superKey != null && this.superKey.equals(other.superKey)) {
                    return true;
                }
            }
            return false;
        }

        @DisableTrace
        public int hashCode() {
            return this.hashCode;
        }

        static {
            try {
                $$$methodRef$$$0 = L2RoutingKey.class.getDeclaredConstructor(OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    protected static class RoutingKey
    implements Comparable<RoutingKey> {
        private final SuperShardingKeys superShardingKeys;
        private final ShardingKeys shardingKeys;
        private final int hashCode;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        RoutingKey(ShardingKeys keys, SuperShardingKeys superShardingKeys) {
            this.superShardingKeys = superShardingKeys;
            this.shardingKeys = keys;
            this.hashCode = Objects.hash(superShardingKeys, this.shardingKeys);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == null) {
                return false;
            }
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof RoutingKey)) {
                return false;
            }
            RoutingKey otherKey = (RoutingKey)otherObj;
            return this.superShardingKeys.equals(otherKey.superShardingKeys) && this.shardingKeys.equals(otherKey.shardingKeys);
        }

        private boolean containsShardingKey(OracleShardingKey shardingKey, OracleShardingKey superKey) {
            if (superKey != null && this.superShardingKeys == null) {
                return false;
            }
            if (this.superShardingKeys != null && !this.superShardingKeys.equals(SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS)) {
                if (superKey == null) {
                    return false;
                }
                if (!this.superShardingKeys.contains(superKey)) {
                    return false;
                }
            }
            if (shardingKey == null) {
                return false;
            }
            return this.shardingKeys.contains(shardingKey);
        }

        @DisableTrace
        public String toString() {
            return (this.superShardingKeys != null ? this.superShardingKeys.toString() : "") + (this.shardingKeys != null ? "\t\t" + this.shardingKeys.toString() : "");
        }

        @Override
        public int compareTo(RoutingKey o2) {
            int equal = this.superShardingKeys.compareTo(o2.superShardingKeys);
            if (equal != 0) {
                return equal;
            }
            int result = this.shardingKeys.compareTo(o2.shardingKeys);
            return result;
        }

        static {
            try {
                $$$methodRef$$$8 = RoutingKey.class.getDeclaredConstructor(ShardingKeys.class, SuperShardingKeys.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = RoutingKey.class.getDeclaredMethod("access$500", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = RoutingKey.class.getDeclaredMethod("access$400", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = RoutingKey.class.getDeclaredMethod("access$000", RoutingKey.class, OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = RoutingKey.class.getDeclaredMethod("compareTo", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = RoutingKey.class.getDeclaredMethod("compareTo", RoutingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = RoutingKey.class.getDeclaredMethod("containsShardingKey", OracleShardingKey.class, OracleShardingKey.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = RoutingKey.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = RoutingKey.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

